<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=1024, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <!-- ألوان شريط الحالة للـ Android -->
<meta name="theme-color" content="#ffffff">
<!-- للـ iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
  <title>MADAD HOLDING Management System</title>
  
  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
 <link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">


    <link rel="manifest" href="manifest.json">
 

  <script>
    if ('serviceWorker' in navigator) {
      navigator.serviceWorker.register('service-worker.js')
        .then(() => console.log('✅ Service Worker Registered'))
        .catch(err => console.error('❌ Service Worker Failed:', err));
    }
  </script>

<script>
  // لو التطبيق مفتوح من الشاشة الرئيسية (Standalone) أو من التصفح العادي، نحوله على طول للصفحة الرئيسية
  if (window.matchMedia('(display-mode: standalone)').matches || window.navigator.standalone === true) {
    window.location.href = 'Login.php'; // هنا حط رابط المنيو أو الصفحة الأساسية
  }
</script>

 <style>
   
    #installBtn {
      position: relative;
    color: var(--secondary);
    font-size: 1.6rem;
    cursor: pointer;
    padding: 0.7rem;
    border-radius: 16px;
    background: #f9f9f9;
    transition: all 0.3s ease;
    user-select: none;
    box-shadow: 3px 3px 6px rgba(161,154,135,0.25), -3px -3px 6px #fff;
    }


    
  </style>


</head>
<body>

  <!-- Header -->
<header class="header" role="banner" aria-label="PageHead" 
        style="display:flex; justify-content:center; align-items:center; height:100px;">
  <div class="logo-container" aria-label="شعار الشركة">
    <img src="MADADHOLDING.jpeg" class="logo-3d" alt="MADAD HOLDING" style="width: 201px; height:auto;" />
  </div>
</header>


  <!-- Marquee -->
  

  <!-- Main Content -->
  <main class="main-content" role="main">
  <br><br><br>
 <br><br><br>
 <section id="login-section" class="projects-container" aria-label="تسجيل الدخول" style="display: block;">

  
  <h1 style="display: flex; align-items: center; gap: 10px; font-size: 1.8rem; margin: 0;">
  <i class="fas fa-handshake" style="color: #A19A87;"></i>
  مرحبًا بكم في  
  <span style="color: #485E47; font-weight: bold;">MADAD HOLDING Management System</span>
</h1>

  <br>

  <br>

   <button id="installBtn"   onclick="installApp()" style="display: flex; align-items: center; gap: 8px;">
  <i class="fas fa-download"></i> تحميل التطبيق
  <i class="fab fa-windows" 
   style="color: #A19A87; font-size: 1.2em; cursor: pointer;" 
   title="ويندوز"></i>

<i class="fab fa-android" 
   style="color: #A19A87; font-size: 1.2em; cursor: pointer;" 
   title="أندرويد"></i>

</button>
 

</div>





</section>

  
  </main>
 <br><br><br> <br>
  <!-- Scroll Top Button -->
  <button id="scrollTopBtn" class="fas fa-arrow-up"
          onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>
<br><br>
  <!-- Footer -->
  <footer class="site-footer">
    <div class="footer-container">
      <p>
        <span class="footer-symbol">©</span>
        <span id="currentYear" class="footer-year"></span>
        جميع الحقوق محفوظة لشركة مداد القابضة
      </p>
    </div>
  </footer>

  <!-- Scripts -->
  <script>
    document.getElementById('currentYear').textContent = new Date().getFullYear();
  </script>

  <script>
// منع تحديد النصوص
document.addEventListener('selectstart', function (e) {
    e.preventDefault();
}, false);

// منع الكليك يمين
document.addEventListener('contextmenu', function (e) {
    e.preventDefault();
}, false);

// منع السحب
document.addEventListener('dragstart', function (e) {
    e.preventDefault();
}, false);

// منع الحفظ وأوامر المطور
window.addEventListener('keydown', function (e) {
    // اختصارات Ctrl + (S, U, P, C, X, A)
    if (e.ctrlKey && ['s', 'u', 'p', 'c', 'x', 'a'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ هذا الاختصار معطل على هذا الموقع");
    }
    // منع F12
    if (e.key === 'F12') {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
    // منع Ctrl+Shift+I و Ctrl+Shift+J
    if (e.ctrlKey && e.shiftKey && ['i', 'j'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
}, true); // capture mode
</script>







<script>
  let deferredPrompt;
  let installBtn = document.getElementById('installBtn');

  // كشف إذا المتصفح بيدعم beforeinstallprompt
  if ('onbeforeinstallprompt' in window) {
    console.log("ℹ️ المتصفح يدعم beforeinstallprompt");

    window.addEventListener('beforeinstallprompt', (e) => {
      e.preventDefault();
      deferredPrompt = e;
      console.log("✅ حدث beforeinstallprompt اشتغل");
      installBtn.style.display = 'inline-block';
    });

  } else {
    console.warn("❌ المتصفح لا يدعم beforeinstallprompt أو لا يمكن إظهاره الآن");
    document.body.insertAdjacentHTML('beforeend',
      `<p style="color:red;margin-top:20px;font-size:16px;">
        📢 لا يمكن عرض زر التثبيت الآن، جرب مسح بيانات الموقع وزيارته مرة أخرى من Chrome على أندرويد.
      </p>`
    );
  }

  function installApp() {
    if (deferredPrompt) {
      deferredPrompt.prompt();
      deferredPrompt.userChoice.then((choiceResult) => {
        if (choiceResult.outcome === 'accepted') {
          console.log('✅ تم التثبيت');
          window.location.href = 'Login.php';
        } else {
          console.log('❌ رفض التثبيت');
        }
        deferredPrompt = null;
      });
    }
  }
</script>






  <script src="script.js"></script>

</body>
</html>