<?php
session_start();
if (!isset($_SESSION['username']) || !isset($_SESSION['usertype'])) {
    header("Location: Login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
    <meta name="viewport" content="width=1024, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <!-- ألوان شريط الحالة للـ Android -->
<meta name="theme-color" content="#ffffff">
<!-- للـ iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
<title>MADAD HOLDING Management System</title>
  
  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
 <link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">
  <!-- Chart.js with 3D plugin -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-3d@latest/dist/chartjs-plugin-3d.min.js"></script>


</head>
<body>

 <!-- Header -->
<?php include 'header.php'; ?>


  <!-- Main Content -->
  <main class="main-content" role="main">
  <section class="projects-container" aria-label="المستخدمين">
  <div class="section-header" style="display: flex; align-items: center; justify-content: space-between; direction: rtl;">

    <!-- العنوان مع الـ combobox -->
    <div style="display: flex; align-items: center; gap: 15px;">
      <h2 class="section-title" style="display: flex; align-items: center; gap: 8px; margin: 0;">
        <i class="fas fa-users" aria-hidden="true"></i>
        المستخدمين
      </h2>
    </div>

    <!-- الأيقونات على الشمال -->
    <div style="display: flex; align-items: center; gap: 10px;">
      
      <!-- إضافة مستخدم -->
       <div class="navS-icon" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="إضافة مستخدم" 
           onclick="toggleAddUserForm();setActiveNavIconS(this)">
        <i class="fas fa-user-plus"></i>
        <span class="tooltip" role="tooltip">إضافة مستخدم</span>
      </div>

      <!-- عرض المستخدمين -->
      <div class="navS-icon active" tabindex="0" role="button"
           style="width: 50px; cursor: pointer;" 
           aria-label="عرض المستخدمين" 
           onclick="showUserList(); setActiveNavIconS(this)">
        <i class="fas fa-list"></i>
        <span class="tooltip" role="tooltip">المستخدمين</span>
      </div>

    </div>
  </div>
</section>

<br>
<section id="add-user-section" class="projects-container" aria-label="إضافة مستخدم" style="display: none;">

 <div style="display: flex; align-items: center; justify-content: space-between;">
  <!-- العنوان -->
  <h2 class="section-title" style="margin: 0; display: flex; align-items: center; gap: 8px;">
    <i class="fas fa-user-plus" aria-hidden="true"></i>
    إضافة مستخدم
  </h2>

  <!-- الأزرار على الشمال -->
  <div style="display: flex; gap: 10px;">



  <div class="navS-icon" tabindex="0" role="button" id="BTNDeleteUser" style="display:none; width: 50px; cursor: pointer;">
      <i class="fas fa-trash-alt"></i>
      <span class="tooltip" role="tooltip">حذف</span>
    </div>


    
    <div class="navS-icon" tabindex="0" role="button" id="BTNSaveandEdit"
         style="width: 50px; cursor: pointer;" aria-label="حفظ" onclick="saveUser()">
      <i class="fas fa-save"></i>
      <span class="tooltip" role="tooltip">حفظ</span>
    </div>

    
  </div>
</div>


  <form id="add-user-form" style="margin-top: 15px; display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px;">
    
    <!-- اسم المستخدم -->
    <div class="form-field">
      <i class="fas fa-user icon-secondary"></i>
      <input type="text" name="username" placeholder="اسم المستخدم" required>
    </div>

    <!-- رقم الموبايل -->
    <div class="form-field">
      <i class="fas fa-phone icon-secondary"></i>
      <input type="tel" name="mobile" placeholder="رقم الجوال" required pattern="\d+" title="يرجى إدخال أرقام فقط">
    </div>

    <!-- البريد الإلكتروني -->
    <div class="form-field">
      <i class="fas fa-envelope icon-secondary"></i>
      <input type="email" name="email" placeholder="البريد الإلكتروني" required>
    </div>

    <!-- نوع المستخدم -->
    <div class="form-field">
      <i class="fas fa-user-tag icon-secondary"></i>
      <select name="user_type" required>
        <option value="" disabled selected>نوع المستخدم</option>
        <option value="مشرف">مشرف</option>
        <option value="محاسب">محاسب</option>
        <option value="مدخل">مدخل</option>
        <option value="بيان">بيان</option>
      </select>
    </div>

    <!-- كلمة المرور -->
    <div class="form-field" style="position: relative;">
      <i class="fas fa-lock icon-secondary"></i>
      <input type="password" id="password-field" name="password" placeholder="كلمة المرور الافتراضية" required style="padding-left: 30px;">
      <button type="button" id="toggle-password" 
              style="position: absolute; left: 5px; top: 50%; transform: translateY(-50%); border: none; background: transparent; cursor: pointer;" 
              aria-label="إظهار/إخفاء كلمة المرور">
        <i class="fas fa-eye" id="toggle-password-icon"></i>
      </button>
    </div>

    <!-- الحالة -->
    <div class="form-field">
      <i class="fas fa-toggle-on icon-secondary"></i>
      <select name="status" required>
        <option value="نشط" selected>نشط</option>
        <option value="موقوف">موقوف</option>
      </select>
    </div>

    <!-- ملاحظات -->
    <div class="form-field" style="grid-column: span 3;">
      <i class="fas fa-sticky-note icon-secondary"></i>
      <input type="text" name="notes" placeholder="ملاحظات">
    </div>
  
  </form>
<div id="messageBox" style="margin-top:10px; padding:10px; border-radius:5px; display:none;"></div>
</section>










<section id="users-section" class="projects-container" aria-label="قائمة المستخدمين">
  <!-- العنوان -->
  <h2 class="section-title" style="display: flex; align-items: center; gap: 8px;">
    <i class="fas fa-users" aria-hidden="true"></i>
    المستخدمين
  </h2>

  <!-- جدول المستخدمين -->
  <div style="display: flex; align-items: center; justify-content: space-between; width: 100%; margin-bottom: 10px;">
    <table class="items-table">
      <thead>
        <tr>
          <th><i class="fas fa-user icon-secondary"></i> الاسم</th>
          <th><i class="fas fa-phone icon-secondary"></i> الجوال</th>
          <th><i class="fas fa-envelope icon-secondary"></i> البريد الإلكتروني</th>
          <th><i class="fas fa-user-tag icon-secondary"></i> نوع الحساب</th>
          <th><i class="fas fa-calendar-alt icon-secondary"></i> تاريخ التسجيل</th>
          <th><i class="fas fa-cogs icon-secondary"></i> الحالة</th>
        </tr>
      </thead>
      <tbody id="users-table-body">
        <tr>
          <td colspan="6" class="no-items">جاري تحميل المستخدمين...</td>
        </tr>
      </tbody>
    </table>
  </div>
</section>



    <!-- Chart Section -->
   
  </main>

  <!-- Scroll Top Button -->
  <button id="scrollTopBtn" class="fas fa-arrow-up"
          onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>





<?php include 'footer.php'; ?>


  <!-- Scripts -->


  
<script>
  const togglePasswordBtn = document.getElementById('toggle-password');
  const passwordField = document.getElementById('password-field');
  const toggleIcon = document.getElementById('toggle-password-icon');

  togglePasswordBtn.addEventListener('click', () => {
    if (passwordField.type === 'password') {
      passwordField.type = 'text';
      toggleIcon.classList.remove('fa-eye');
      toggleIcon.classList.add('fa-eye-slash');
    } else {
      passwordField.type = 'password';
      toggleIcon.classList.remove('fa-eye-slash');
      toggleIcon.classList.add('fa-eye');
    }
  });
</script>




  <script>
    document.getElementById('currentYear').textContent = new Date().getFullYear();
  </script>

  <script>
// منع تحديد النصوص
document.addEventListener('selectstart', function (e) {
    e.preventDefault();
}, false);

// منع الكليك يمين
document.addEventListener('contextmenu', function (e) {
    e.preventDefault();
}, false);

// منع السحب
document.addEventListener('dragstart', function (e) {
    e.preventDefault();
}, false);

// منع الحفظ وأوامر المطور
window.addEventListener('keydown', function (e) {
    // اختصارات Ctrl + (S, U, P, C, X, A)
    if (e.ctrlKey && ['s', 'u', 'p', 'c', 'x', 'a'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ هذا الاختصار معطل على هذا الموقع");
    }
    // منع F12
    if (e.key === 'F12') {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
    // منع Ctrl+Shift+I و Ctrl+Shift+J
    if (e.ctrlKey && e.shiftKey && ['i', 'j'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
}, true); // capture mode
</script>




<script>
  let pageIdentifier = "users";
</script>
  <script src="UsersAjax.js"></script>
  <script src="script.js"></script>
  

 
</body>
</html>