<?php
$response = ["status" => "error", "message" => "حدث خطأ أثناء رفع الملف"];

// إعداد المجلدات
$uploadDir = __DIR__ . '/DocumentPDF/';
$tmpDir = __DIR__ . '/tmp/';

// إنشاء المجلدات إذا مش موجودة
if (!file_exists($uploadDir)) mkdir($uploadDir, 0777, true);
if (!file_exists($tmpDir)) mkdir($tmpDir, 0777, true);

// تحديد مجلد tmp في PHP لتجنب الملفات الفاضية
ini_set('upload_tmp_dir', $tmpDir);

if (isset($_FILES["pdfFile"])) {
    $file = $_FILES["pdfFile"];
    $fileName = basename($file["name"]);

    $targetPath = "DocumentPDF/" . $fileName;


    // تحقق من امتداد الملف
    $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
    if ($ext !== 'pdf') {
        $response["message"] = "❌ يُسمح فقط برفع ملفات PDF";
    } 
    // تحقق من حدوث خطأ أثناء الرفع
    elseif ($file['error'] !== 0) {
        $response["message"] = "⚠️ حدث خطأ أثناء رفع الملف (رمز الخطأ: {$file['error']})";
    } 
    // حفظ الملف فعلياً
    elseif (move_uploaded_file($file["tmp_name"], $targetPath)) {
        $response = [
            "status" => "success",
            "path" => $targetPath,
            "message" => "✅ تم رفع الملف بنجاح"
        ];
    } else {
        $response["message"] = "❌ تعذر حفظ الملف في المجلد. تحقق من صلاحيات المجلد.";
    }
}

// إرسال الرد كـ JSON
header("Content-Type: application/json");
echo json_encode($response);
