<?php
header("Content-Type: application/json; charset=UTF-8");
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once "db.php";

// استقبال البيانات
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

// تحقق من البيانات المطلوبة
if (
    !$data || 
    !isset($data['id']) || 
    !isset($data['invoice_number']) || 
    !isset($data['amount']) || 
    !isset($data['date'])
) {
    echo json_encode(["status" => "error", "message" => "❌ البيانات غير مكتملة"]);
    exit;
}

$id     = intval($data['id']);
$number = trim($data['invoice_number']);
$amount = floatval($data['amount']);
$date   = trim($data['date']);
$notes  = isset($data['notes']) ? trim($data['notes']) : "";
$attach = isset($data['AttachmentPath']) ? trim($data['AttachmentPath']) : "";

// التحقق من ID
if ($id <= 0) {
    echo json_encode(["status" => "error", "message" => "❌ رقم الإيراد غير صالح"]);
    exit;
}

// تجهيز الاستعلام
$sql = "UPDATE revenuesMH 
        SET RafranceNumber = ?, value = ?, date = ?, notes = ?, AttachmentPath = ?
        WHERE id = ?";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "❌ فشل تجهيز الاستعلام"]);
    exit;
}

$stmt->bind_param("sdsssi", $number, $amount, $date, $notes, $attach, $id);

// تنفيذ التعديل
if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        echo json_encode(["status" => "success", "message" => "✅ تم تعديل الإيراد بنجاح"]);
    } else {
        echo json_encode(["status" => "warning", "message" => "⚠️ لم يتم تعديل أي بيانات"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "❌ فشل تنفيذ عملية التعديل"]);
}

$stmt->close();
$conn->close();
?>
