<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json; charset=UTF-8");
require_once "db.php";

// 📥 استقبال البيانات بصيغة JSON
$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام البيانات"]);
    exit;
}

// 🧾 قراءة البيانات مع التحقق من وجودها
$id        = intval($data['id'] ?? 0);
$PID       = intval($data['project_id2nd'] ?? 0);
$item_name = trim($data['item_name'] ?? '');
$unit      = trim($data['unit'] ?? '');
$quantity  = floatval($data['quantity'] ?? 0);
$price     = floatval($data['price'] ?? 0);
$notes     = trim($data['notes'] ?? '');

// ✅ التحقق من وجود المعرف واسم البند
if ($id === 0 || $item_name === '') {
    echo json_encode(["status" => "error", "message" => "⚠️ البيانات غير مكتملة"]);
    exit;
}

// 🧠 تجهيز الاستعلام بدون total لأنه GENERATED
$sql = "UPDATE ProjectTermsMH 
        SET PID = ?, item_name = ?, unit = ?, quantity = ?, price = ?, notes = ?
        WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("issddsi", $PID, $item_name, $unit, $quantity, $price, $notes, $id);

// 📤 تنفيذ التعديل
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم تعديل البند بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ خطأ في التعديل: " . $stmt->error]);
}

// 🧹 تنظيف الموارد
$stmt->close();
$conn->close();
?>
