<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "db.php"; // ملف الاتصال بقاعدة البيانات

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام البيانات"]);
    exit;
}

// استخراج الحقول
$id           = intval($data['id'] ?? 0);
$data_name    = trim($data['contributor_name'] ?? '');
$start_date   = trim($data['start_date'] ?? '');
$value        = trim($data['contribution_value'] ?? '');
$percentage   = trim($data['percentage'] ?? '');
$due_date     = trim($data['due_date'] ?? '');
$profit       = trim($data['profit'] ?? '');
$notes        = trim($data['notes'] ?? '');

// تحقق من ID و الحقول المطلوبة
if ($id === 0 || $data_name === "" || $start_date === "" || $value === "" || $due_date === "") {
    echo json_encode(["status" => "error", "message" => "⚠️ كل الحقول المطلوبة يجب أن تكون ممتلئة"]);
    exit;
}

// تحويل الحقول الفارغة للاختيارات إلى NULL
$percentage = $percentage === '' ? null : $percentage;
$profit     = $profit === '' ? null : $profit;
$notes      = $notes === '' ? null : $notes;

// تحضير الاستعلام
$sql = "UPDATE financialMH 
        SET data_name = ?, start_date = ?, value = ?, percentage = ?, due_date = ?, profit = ?, notes = ?
        WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ssddsssi", $data_name, $start_date, $value, $percentage, $due_date, $profit, $notes, $id);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم تعديل البيان بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ خطأ أثناء تعديل البيان: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
