<?php
header("Content-Type: application/json; charset=UTF-8");
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once "db.php";

// استقبال البيانات من الـ AJAX
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

// ✅ تحقق من البيانات المطلوبة حسب أسماء الجافاسكريبت
if (
    !$data ||
    !isset($data['id']) || !is_numeric($data['id']) ||
    !isset($data['CDate']) ||
    !isset($data['EmpID']) ||
    !isset($data['CAmount'])
) {
    echo json_encode(["status" => "error", "message" => "❌ بيانات ناقصة أو غير صالحة"]);
    exit;
}

// ✅ استخراج البيانات
$id         = intval($data['id']);
$date       = trim($data['CDate']);
$emp        = intval($data['EmpID']);
$amount     = floatval($data['CAmount']);
$notes      = isset($data['CNotes']) ? trim($data['CNotes']) : "";
$attachment = isset($data['AttachmentPath']) ? trim($data['AttachmentPath']) : "";

// ✅ تنفيذ التعديل
$sql = "UPDATE custodyMH 
        SET 
            CDate = ?, 
            EmpID = ?, 
            CAmount = ?, 
            CNotes = ?, 
            AttachmentPath = ?
        WHERE id = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("sidssi", $date, $emp, $amount, $notes, $attachment, $id);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم تعديل العهدة بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ فشل تعديل العهدة: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
