const CACHE_NAME = "madad_holding_cache_v1";
const urlsToCache = [
  
  'Home.php',
 
];

// Install
self.addEventListener("install", (event) => {
  console.log("[ServiceWorker] Install");
  event.waitUntil(
    caches.open(CACHE_NAME).then((cache) => {
      console.log("[ServiceWorker] Caching files");
      return cache.addAll(urlsToCache);
    })
  );
});

// Activate
self.addEventListener("activate", (event) => {
  console.log("[ServiceWorker] Activate");
  event.waitUntil(
    caches.keys().then((keyList) => {
      return Promise.all(
        keyList.map((key) => {
          if (key !== CACHE_NAME) {
            console.log("[ServiceWorker] Removing old cache", key);
            return caches.delete(key);
          }
        })
      );
    }).then(() => self.clients.claim()) // التعديل هنا
  );
});

// Fetch
self.addEventListener("fetch", (event) => {
  event.respondWith(
    fetch(event.request).catch(() => {
      return new Response("<h2 style='text-align:center;color:red;'>⚠️ لا يوجد اتصال بالإنترنت</h2>", {
        headers: { "Content-Type": "text/html; charset=utf-8" }
      });
    })
  );
});
