


// Scroll to Top Button
const scrollTopBtn = document.getElementById("scrollTopBtn");

if (scrollTopBtn) {
  window.addEventListener("scroll", () => {
    if (window.scrollY > 200) {
      scrollTopBtn.classList.add("show");
    } else {
      scrollTopBtn.classList.remove("show");
    }
  });
}


// Navigation Active State
const currentPage = window.location.pathname.split("/").pop().toLowerCase();

document.querySelectorAll('.nav-icon').forEach(icon => {
  const page = icon.getAttribute('data-page');
  
  if (page && page.toLowerCase() === currentPage) {
    icon.classList.add('active');
  }

  icon.addEventListener('click', () => {
    if (page) {
      window.location.href = page;
    }
  });
});



// NavigationT Active State
const currentPageT = window.location.pathname.split("/").pop().toLowerCase();

document.querySelectorAll('.navT-icon').forEach(icon => {
  const page = icon.getAttribute('data-page');
  
  if (page && page.toLowerCase() === currentPageT) {
    icon.classList.add('active');
  }

  icon.addEventListener('click', () => {
    if (page) {
      window.location.href = page;
    }
  });
});


// Touch Effects
document.addEventListener('DOMContentLoaded', () => {
  const buttons = document.querySelectorAll('button, .nav-icon, .project-card');
  
  buttons.forEach(btn => {
    btn.addEventListener('touchstart', () => {
      btn.style.transform = 'scale(0.96)';
    });
    
    btn.addEventListener('touchend', () => {
      btn.style.transform = '';
    });
  });


  
  // Button Groups
  const chartBtns = document.querySelectorAll('.chart-btn');
  const timeBtns = document.querySelectorAll('.time-btn');
  const navIcons = document.querySelectorAll('.nav-icon');

  function handleButtonClick(buttons, activeClass) {
    buttons.forEach(btn => {
      btn.addEventListener('click', () => {
        buttons.forEach(b => b.classList.remove(activeClass));
        btn.classList.add(activeClass);
      });
    });
  }

  handleButtonClick(chartBtns, 'active');
  handleButtonClick(timeBtns, 'active');
  handleButtonClick(navIcons, 'active');

  // Aria-pressed for Chart Buttons
  chartBtns.forEach(btn => {
    btn.addEventListener('click', function() {
      chartBtns.forEach(b => b.setAttribute('aria-pressed', 'false'));
      this.setAttribute('aria-pressed', 'true');
    });
  });
});

// Project Dropdown Functions
function toggleDropdown() {
  const wrapper = document.querySelector('.custom-select');
  const options = document.querySelector('.custom-options');

  if (wrapper.classList.contains('active')) {
    wrapper.classList.remove('active');
    options.style.display = 'none';
  } else {
    wrapper.classList.add('active');
    options.style.display = 'block';
  }
}

// الدوال الخاصة بالقائمة المنسدلة للمشاريع
function toggleProjectDropdown() {
  const select = document.querySelector('.custom-select');
  const options = document.querySelector('.custom-options');
  
  if (select && options) {
    const isActive = select.classList.contains('active');
    
    if (isActive) {
      select.classList.remove('active');
      options.style.display = 'none';
    } else {
      select.classList.add('active');
      options.style.display = 'block';
    }
  }
}


// دالة مساعدة لإغلاق جميع القوائم المنسدلة
function closeAllDropdowns() {
  const select = document.querySelector('.custom-select');
  const options = document.querySelector('.custom-options');
  const dropdownOptions = document.getElementById("dropdown-options");
  
  if (select) select.classList.remove('active');
  if (options) options.style.display = 'none';
  if (dropdownOptions) dropdownOptions.style.display = 'none';
}

// إغلاق القوائم عند النقر خارجها
document.addEventListener('click', function(e) {
  const wrapper = document.querySelector('.custom-select-wrapper');
  if (!wrapper?.contains(e.target)) {
    closeAllDropdowns();
  }
});
// Close dropdown when clicking outside
document.addEventListener('click', function(e) {
  const wrapper = document.querySelector('.custom-select-wrapper');
  if (wrapper && !wrapper.contains(e.target)) {
    const select = document.querySelector('.custom-select');
    if (select) select.classList.remove('active');
    
    const options = document.querySelector('.custom-options');
    if (options) options.style.display = 'none';
    
    const dropdownOptions = document.getElementById("dropdown-options");
    if (dropdownOptions) dropdownOptions.style.display = "none";
  }
});

// Section Management Functions
function addItem() {
  const addItemSection = document.getElementById('add-item-section');
  
  if (addItemSection) {
    addItemSection.style.display = 'block';
    
    // Hide other sections
    const projectDetails = document.getElementById('project-details');
    if (projectDetails) projectDetails.style.display = 'block';
    
    const addProjectSection = document.getElementById('add-project-section');
    if (addProjectSection) addProjectSection.style.display = 'none';
    
    window.scrollBy({ top: 300, left: 0, behavior: 'smooth' });
  }
}




// Financial Sections
function toggleNewCustomSelect() {
  const section = document.getElementById('add-fund-section');
  const sectionDetails = document.getElementById('contributors-section');
 const removefund = document.getElementById('remove-fund-section');

  if (section && sectionDetails) {
    section.style.display = 'block';
    sectionDetails.style.display = 'none';
    removefund.style.display = 'none';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
  }
}



function toggleRevenueForm() {
  const section = document.getElementById('add-revenue-section');
  const sectionDetails = document.getElementById('revenues-section');

  if (section && sectionDetails) {
    section.style.display = 'block';
    sectionDetails.style.display = 'none';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
  }
}






function toggleExpenseForm() {
  const section = document.getElementById('add-expense-section');
  const sectionDetails = document.getElementById('expenses-section');

  if (section && sectionDetails) {
    section.style.display = 'block';
    sectionDetails.style.display = 'none';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
  }
}

function showExpenseList() {
  const section = document.getElementById('add-expense-section');
  const sectionDetails = document.getElementById('expenses-section');

  if (section && sectionDetails) {
    section.style.display = 'none';
    sectionDetails.style.display = 'block';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
  }
}

function showRevenueList() {
  const section = document.getElementById('add-revenue-section');
  const sectionDetails = document.getElementById('revenues-section');

  if (section && sectionDetails) {
    section.style.display = 'none';
    sectionDetails.style.display = 'block';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
  }
}






// Footer Adjustment
function adjustFooterPosition() {
  const footer = document.getElementById('site-footer');
  const content = document.getElementById('main-content');

  if (footer && content) {
    const footerHeight = footer.offsetHeight;
    content.style.paddingBottom = footerHeight + 'px';
  }
}

window.addEventListener('load', adjustFooterPosition);
window.addEventListener('resize', adjustFooterPosition);

// Navigation Helper
function setActiveNavIcon(el) {
  document.querySelectorAll('.nav-icon').forEach(icon => {
    icon.classList.remove('active');
  });
  el.classList.add('active');
}



function setActiveNavIconS(el) {
  document.querySelectorAll('.navS-icon').forEach(icon => {
    icon.classList.remove('active');
  });
  el.classList.add('active');
   // بدل السطر اللي بيعمل style.display مباشرة
// document.getElementById("BTNDeleteUser").style.display = "none";

// حط هذا الكود
const deleteBtn = document.getElementById("BTNDeleteUser");
if (deleteBtn) {
  deleteBtn.style.display = "none";
}

}



function toggleCustodyForm() {
  const section = document.getElementById('add-advance-section');
  const sectionDetails = document.getElementById('advances-section');
 const BTNDeletecustody = document.getElementById('BTNDeletecustody');

    section.style.display = 'block';
    sectionDetails.style.display = 'none';
      BTNDeletecustody.style.display = 'none';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
 
}


function showCustodyList() {
  const section = document.getElementById('add-advance-section');
  const sectionDetails = document.getElementById('advances-section');


    section.style.display = 'none';
    sectionDetails.style.display = 'block';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
 
}



function toggleAddUserForm() {
  const section = document.getElementById('add-user-section');
  const sectionDetails = document.getElementById('users-section');


    section.style.display = 'block';
    sectionDetails.style.display = 'none';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
 
}





function showUserList() {
  const section = document.getElementById('add-user-section');
  const sectionDetails = document.getElementById('users-section');


    section.style.display = 'none';
    sectionDetails.style.display = 'block';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
 
}




(function() {
  // إنشاء عناصر التحذير
  const style = document.createElement("style");
  style.innerHTML = `
  #landscape-warning {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.85);
    color: white;
    display: none;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    font-family: sans-serif;
    text-align: center;
    padding: 20px;
    z-index: 9999;
    animation: fadeIn 0.3s ease;
  }
  #landscape-warning i {
    font-size: 60px;
    margin-bottom: 15px;
  }
  #landscape-warning .rotate-icon {
    font-size: 40px;
    margin-top: 10px;
    animation: rotateAnim 2s infinite linear;
  }
  @keyframes rotateAnim {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
  }
  @keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
  }
  `;
  document.head.appendChild(style);

  const warningDiv = document.createElement("div");
  warningDiv.id = "landscape-warning";
  warningDiv.innerHTML = `
    <i class="fas fa-mobile-alt"></i>
    <i class="fas fa-sync-alt rotate-icon"></i>
    <p>يرجى تدوير الجهاز للوضع الأفقي لعرض أفضل</p>
  `;
  document.body.appendChild(warningDiv);

  // تحميل مكتبة الأيقونات مرة واحدة
  const iconLink = document.createElement("link");
  iconLink.rel = "stylesheet";
  iconLink.href = "https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css";
  document.head.appendChild(iconLink);

  function checkOrientation() {
    if (window.innerHeight > window.innerWidth) {
      warningDiv.style.display = "flex"; // عمودي
    } else {
      warningDiv.style.display = "none"; // أفقي
    }
  }

  window.addEventListener("resize", checkOrientation);
  window.addEventListener("load", checkOrientation);
})();

//Date

document.addEventListener('DOMContentLoaded', () => {
  const today = new Date().toISOString().split('T')[0];
  const exitInput = document.getElementById('exit-date');
  if (exitInput) {
    exitInput.value = today;
  }
});




function toggleAddBalance() {
  const section = document.getElementById('add-balance-section');
  const sectionEdi = document.getElementById('deduct-balance-section');
  const sectionDetails = document.getElementById('transactions-section');

    section.style.display = 'block';
    sectionEdi.style.display = 'none';
    sectionDetails.style.display = 'none';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
 
}


function toggleDeductBalance() {
  const section = document.getElementById('add-balance-section');
  const sectionEdi = document.getElementById('deduct-balance-section');
  const sectionDetails = document.getElementById('transactions-section');

    section.style.display = 'none';
    sectionEdi.style.display = 'block';
    sectionDetails.style.display = 'none';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
 
}



function toggleBalanceView() {
  const section = document.getElementById('add-balance-section');
  const sectionEdi = document.getElementById('deduct-balance-section');
  const sectionDetails = document.getElementById('transactions-section');

    section.style.display = 'none';
    sectionEdi.style.display = 'none';
    sectionDetails.style.display = 'block';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
}





let currentType = "all";
let currentMethod = "all";

function filterByType(type) {
  currentType = type;
  applyFilters();
}

function filterByMethod(method) {
  currentMethod = method;
  applyFilters();
}

function filterByUser() {
  applyFilters();
}

function applyFilters() {
  const userInput = document.getElementById("userFilter").value.toLowerCase();
  const rows = document.querySelectorAll("#transactions-table-body tr");

  rows.forEach(row => {
    const type = row.getAttribute("data-type");   // add أو deduct
    const method = row.getAttribute("data-method"); // cash أو bank
    const user = row.getAttribute("data-user")?.toLowerCase() || "";

    let show = true;

    // فلتر النوع
    if (currentType !== "all" && type !== currentType) {
      show = false;
    }

    // فلتر الطريقة
    if (currentMethod !== "all" && method !== currentMethod) {
      show = false;
    }

    // فلتر المستخدم
    if (userInput && !user.includes(userInput)) {
      show = false;
    }

    row.style.display = show ? "" : "none";
  });
}











function getParameterByName(name) {
    const url = new URL(window.location.href);
    return url.searchParams.get(name);
}

document.addEventListener("DOMContentLoaded", function() {
    const UID = getParameterByName("UID");
    const UN = getParameterByName("UN");

    if(UID && UN){
        // ملء hidden inputs في Home.php
        document.getElementById("UIDHidd").value = UID;
        document.getElementById("UsernameHidd").value = UN;

        // إذا أردت إظهار الاسم في footer
        const footerName = document.querySelector('footer input#UIDHidd');
        if(footerName) footerName.value = UID; // أو UN إذا كان الاسم
    }
});



document.addEventListener('DOMContentLoaded', () => {

    // نلاقي tbody الجدول مباشرة
    const tbody = document.getElementById('contributors-table-body');
    if (!tbody) return; // لو مفيش tbody، نتجاهل

    // إنشاء لابل للعدد والمجموع
    const countLabel = document.createElement('div');
    countLabel.id = 'contributors-count';
    countLabel.style.fontWeight = 'bold';
    const totalLabel = document.createElement('div');
    totalLabel.id = 'contributors-total';
    totalLabel.style.fontWeight = 'bold';

    // أيقونات
    const countIcon = '<i class="fas fa-hashtag dropdown-arrow icon-secondary"></i> ';
    const totalIcon = '<i class="fas fa-calculator dropdown-arrow icon-secondary"></i> ';

    // نضيف اللابل بعد الجدول مباشرة
    tbody.parentNode.insertBefore(countLabel, tbody.nextSibling);
    tbody.parentNode.insertBefore(totalLabel, countLabel.nextSibling);

    // دالة لتحديث العدد والمجموع
    function updateContributorsSummary() {
        // الشرط: حساب القيم فقط إذا الجدول موجود ومكتمل الصفوف
        if (!tbody || tbody.querySelectorAll('tr').length === 0) return;

        const rows = Array.from(tbody.querySelectorAll('tr')).filter(r => !r.classList.contains('no-items'));
        const totalRows = rows.length;
        let totalValue = 0;

        rows.forEach(row => {
            const valueCell = row.cells[2]; // عمود "قيمة البيان"
            if (valueCell) {
                const cellText = valueCell.textContent.trim().replace(/,/g, '');
                const cellValue = parseFloat(cellText) || 0;
                totalValue += cellValue;
            }
        });

        // تحديث العدد والمجموع
countLabel.innerHTML = `<br>${countIcon}العدد: ${totalRows}<br>`;
totalLabel.innerHTML = `<br>${totalIcon}المجموع: ${totalValue.toFixed(2)}<br>`;

// إضافة مسافات فوق وتحت عبر CSS
countLabel.style.marginTop = "10px";
countLabel.style.marginBottom = "10px";
totalLabel.style.marginTop = "10px";
totalLabel.style.marginBottom = "10px";

    }

    // تحديث القيم عند تحميل الصفحة
    updateContributorsSummary();

    // مراقب تغييرات الجدول: إذا اتضاف صفوف جديدة، يتم تحديث العدد والمجموع تلقائيًا
    const observer = new MutationObserver(() => {
        updateContributorsSummary();
    });
    observer.observe(tbody, { childList: true, subtree: true });
});



// دالة عرض الرسائل داخل div
function showMessage(message, type = "info") {
    const box = document.getElementById("messageBox");

    if (!box) {
        console.warn("❌ عنصر الرسائل غير موجود في الصفحة");
        return;
    }

    // ألوان حسب نوع الرسالة
    let bgColor = "#d9edf7", textColor = "#31708f"; // info
    if (type === "error") {
        bgColor = "#f2dede";
        textColor = "#a94442";
    } else if (type === "success") {
        bgColor = "#dff0d8";
        textColor = "#3c763d";
    }

    box.innerText = message;
    box.style.backgroundColor = bgColor;
    box.style.color = textColor;
    box.style.border = "1px solid " + textColor;
    box.style.display = "block";

    // إخفاء بعد 5 ثواني
    setTimeout(() => {
        box.style.display = "none";
    }, 5000);
}

// إعادة تعريف alert() ليظهر في div بدل نافذة المتصفح
window.alert = function(message) {
    showMessage(message, "info");
};


function loadFinancialMarquee() {
  fetch('getStats.php')
    .then(res => res.json())
    .then(data => {
      // تعديل السهم ليأخذ كلاس icon-secondary
      const profitsPercentage = data.profits_percentage.replace(
        "<i class='fas fa-arrow-up'></i>",
        "<i class='fas fa-arrow-up icon-secondary'></i>"
      );

      const content = `
        &nbsp;&nbsp; &nbsp;&nbsp; راس المال &nbsp;&nbsp; ${data.fund} ريال &nbsp;&nbsp; &nbsp;&nbsp; <i class="fas fa-wallet icon-secondary"></i> &nbsp;&nbsp; 
        الرصيد الحالي &nbsp;&nbsp; ${data.balance} ريال &nbsp;&nbsp;&nbsp;&nbsp; <i class="fas fa-money-bill-wave icon-secondary"></i> &nbsp;&nbsp; 
        الإيرادات &nbsp;&nbsp; ${data.revenues} ريال &nbsp;&nbsp; &nbsp;&nbsp; <i class="fas fa-receipt icon-secondary"></i> &nbsp;&nbsp; 
        المصروفات &nbsp;&nbsp; ${data.expenses} ريال &nbsp;&nbsp;&nbsp;&nbsp; <i class="fas fa-coins icon-secondary"></i> &nbsp;&nbsp; 
        الأرباح &nbsp;&nbsp; ${data.profits} ريال ${profitsPercentage} &nbsp;&nbsp; &nbsp;&nbsp; <i class="fas fa-sack-dollar icon-secondary"></i> &nbsp;&nbsp; 
        العُهدة &nbsp;&nbsp; ${data.custody} ريال &nbsp;&nbsp;&nbsp;&nbsp; <i class="fas fa-chart-line icon-secondary"></i> &nbsp;&nbsp;
      `;

      const marquee = document.getElementById("financialMarquee");
      marquee.innerHTML = content;

      // --- إضافة التحكم بالتحريك يمين/شمال ---
      let isDown = false;
      let startX;
      let scrollLeft;

      marquee.style.overflowX = "auto";      // علشان نقدر نسحب
      marquee.style.whiteSpace = "nowrap";   // يمنع النزول للسطر التالي
      marquee.style.cursor = "grab";

      marquee.addEventListener("mousedown", (e) => {
        isDown = true;
        marquee.style.cursor = "grabbing";
        startX = e.pageX - marquee.offsetLeft;
        scrollLeft = marquee.scrollLeft;
        e.preventDefault();
      });

      marquee.addEventListener("mouseleave", () => {
        isDown = false;
        marquee.style.cursor = "grab";
      });

      marquee.addEventListener("mouseup", () => {
        isDown = false;
        marquee.style.cursor = "grab";
      });

      marquee.addEventListener("mousemove", (e) => {
        if (!isDown) return;
        e.preventDefault();
        const x = e.pageX - marquee.offsetLeft;
        const walk = (x - startX) * 1; // السرعة
        marquee.scrollLeft = scrollLeft - walk;
      });
    })
    .catch(err => {
      console.error("❌ خطأ في تحميل البيانات:", err);
      document.getElementById("financialMarquee").textContent = "❌ تعذر تحميل البيانات";
    });
}

// تحميل أول مرة
loadFinancialMarquee();

// تحديث كل 5 ثواني زي باقي الصفحة
setInterval(loadFinancialMarquee, 5000);



//English num

document.addEventListener("DOMContentLoaded", function () {
  const arabicNums = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩'];
  const englishNums = ['0','1','2','3','4','5','6','7','8','9'];

  function convertToEnglishNumbers(text) {
    let result = text;
    arabicNums.forEach((num, i) => {
      const regex = new RegExp(num, 'g');
      result = result.replace(regex, englishNums[i]);
    });
    return result;
  }

  function walkAndConvert(node) {
    if (node.nodeType === 3) {
      node.nodeValue = convertToEnglishNumbers(node.nodeValue);
    } else {
      node.childNodes.forEach(walkAndConvert);
    }
  }

  walkAndConvert(document.body);
});


document.addEventListener("DOMContentLoaded", function () {
  const arabicNums = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩'];
  const englishNums = ['0','1','2','3','4','5','6','7','8','9'];

  // تحويل كل النصوص في الصفحة
  function convertTextNodes(node) {
    if (node.nodeType === 3) {
      arabicNums.forEach((num, i) => {
        const regex = new RegExp(num, 'g');
        node.nodeValue = node.nodeValue.replace(regex, englishNums[i]);
      });
    } else {
      node.childNodes.forEach(convertTextNodes);
    }
  }

  convertTextNodes(document.body);

  // تحويل أي مدخلات يكتب فيها المستخدم
  document.querySelectorAll("input, textarea").forEach(input => {
    input.addEventListener("input", function () {
      let value = input.value;
      arabicNums.forEach((num, i) => {
        const regex = new RegExp(num, 'g');
        value = value.replace(regex, englishNums[i]);
      });
      input.value = value;
    });
  });
});




//Login policy


// ✅ تعريف الصلاحيات حسب نوع المستخدم
const permissions = {
  "مشرف": {
    pages: ["projects", "fund", "Balance", "revenues", "expenses", "profits", "custody", "users"],
    elements: {
      "projects": ["إضافة بند","المشاريع والإحصائيات", "تفاصيل المشروع والبنود", "قائمة جميع المشاريع"],
      "fund": ["إضافة بيان", "تخارج بيان", "قائمة البيانات","تعديل"],
      "Balance": ["إضافة رصيد", "الحركات المالية","تعديل"],
      "revenues": ["إضافة إيراد", "قائمة الإيرادات","تعديل"],
      "expenses": ["إضافة مصروف", "قائمة المصروفات","تعديل"],
      "profits": ["قائمة الأرباح"],
      "custody": ["إضافة عهده", "قائمة العهد","تعديل"],
      "users": ["إضافة مستخدم", "قائمة المستخدمين","تعديل"]
    }
  },
  "محاسب": {
     pages: ["projects", "fund", "Balance", "revenues", "expenses", "profits", "custody", "users"],
    elements: {
      "projects": ["إضافة بند","المشاريع والإحصائيات", "تفاصيل المشروع والبنود", "قائمة جميع المشاريع"],
      "fund": ["قائمة البيانات"],
      "Balance": ["إضافة رصيد", "الحركات المالية"],
      "revenues": ["إضافة إيراد", "قائمة الإيرادات"],
      "expenses": ["إضافة مصروف", "قائمة المصروفات"],
      "profits": ["قائمة الأرباح"],
      "custody": ["إضافة عهده", "قائمة العهد"]
    }
  },
  "مدخل": {
    pages: ["expenses"],
    elements: {
      "revenues": ["إضافة إيراد", "قائمة الإيرادات"],
       "expenses": ["إضافة مصروف", "قائمة المصروفات"]
    }
  },
  "بيان": {
      pages: ["projects", "fund", "Balance", "revenues", "expenses", "profits", "custody", "users"],
    elements: {
      "projects": ["تفاصيل المشروع والبنود", "قائمة جميع المشاريع"],
      "fund": ["قائمة البيانات"],
      "Balance": ["الحركات المالية"],
      "revenues": ["قائمة الإيرادات"],
      "expenses": ["قائمة المصروفات"],
      "profits": ["قائمة الأرباح"],
      "custody": ["قائمة العهد"]
    }
  }
};// ✅ تطبيق الصلاحيات بعد تحميل الصفحة
function applyPermissions() {
  const userTypeEl = document.getElementById("FooterUserType");
  const userType = userTypeEl?.textContent.trim();

  if (!userType || !permissions[userType]) return;
  if (typeof pageIdentifier === "undefined" || !pageIdentifier) return;

  const allowedElements = permissions[userType]?.elements[pageIdentifier] || [];
  const pageElements = Object.values(permissions).flatMap(role =>
    role.elements[pageIdentifier] || []
  );

  // التحقق من أن الصفحة نفسها مسموح بها للمستخدم
  const allowedPages = permissions[userType]?.pages || [];
  if (!allowedPages.includes(pageIdentifier)) {
    alert("نوع المستخدم غير مسموح له بالدخول إلى هذه الصفحة.");
    if (document.referrer) {
      window.location.href = document.referrer;
    } else {
      window.location.href = "/";
    }
    return;
  }

  // التحقق من أن هناك على الأقل عنصر مسموح به في الصفحة الحالية
  const hasAccess = pageElements.some(el => allowedElements.includes(el));
  if (!hasAccess) {
    alert("نوع المستخدم غير مسموح له بالدخول إلى هذا القسم.");
    if (document.referrer) {
      window.location.href = document.referrer;
    } else {
      window.location.href = "/";
    }
    return;
  }

  // التعامل مع العناصر داخل الصفحة
  document.querySelectorAll("[aria-label]").forEach(el => {
    const label = el.getAttribute("aria-label")?.trim();

    // تجاهل العناصر اللي مش من عناصر الصفحة
    if (!label || !pageElements.includes(label)) return;

    // لو العنصر مش مسموح به
    if (!allowedElements.includes(label)) {
      el.title = "المحتوى غير متاح حسب صلاحيات المستخدم";

      if ("disabled" in el) {
        el.disabled = true;
      } else {
        el.style.pointerEvents = "none";
        el.style.opacity = "0.0";
        el.style.cursor = "not-allowed";
      }

      el.style.color = "transparent";
      el.style.textShadow = "0 0 8px rgba(0,0,0,0.5)";

      el.addEventListener("click", function (e) {
        e.preventDefault();
        e.stopPropagation();
        alert("نوع المستخدم غير مسموح له بالدخول إلى هذا القسم.");
      });
    }
  });
}

document.addEventListener("DOMContentLoaded", applyPermissions);


