<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "db.php"; // الاتصال بقاعدة البيانات

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام البيانات"]);
    exit;
}

// استخراج البيانات من JSON
$project_name     = trim($data['project_name'] ?? '');
$project_owner    = trim($data['project_owner'] ?? '');
$project_status   = trim($data['project_status'] ?? '');
$project_location = trim($data['project_location'] ?? '');
$project_cost     = floatval($data['project_cost'] ?? 0);
$project_duration = trim($data['project_duration'] ?? '');
$attachment_path  = trim($data['AttachmentPath'] ?? '');

// التحقق من الحقول المطلوبة
if (
    $project_name === '' ||
    $project_owner === '' ||
    $project_status === '' ||
    $project_location === '' ||
    $project_cost === 0 ||
    $project_duration === ''
) {
    echo json_encode(["status" => "error", "message" => "⚠️ الرجاء إدخال جميع بيانات المشروع"]);
    exit;
}

// تنفيذ الإدخال
$sql = "INSERT INTO PrjectsMH (project_name, project_owner, project_status, project_location, project_cost, project_duration, created_at, AttachmentPath)
        VALUES (?, ?, ?, ?, ?, ?, NOW(), ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ssssiss", $project_name, $project_owner, $project_status, $project_location, $project_cost, $project_duration, $attachment_path);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم حفظ المشروع بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ خطأ في الحفظ: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
