<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json; charset=UTF-8");
require_once "db.php";

// 📥 استقبال البيانات بصيغة JSON
$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام البيانات"]);
    exit;
}

// 🧾 قراءة البيانات مع التحقق من وجودها
$PID       = intval($data['project_id2nd'] ?? 0);
$item_name = trim($data['item_name'] ?? '');
$unit      = trim($data['unit'] ?? '');
$quantity  = floatval($data['quantity'] ?? 0);
$price     = floatval($data['price'] ?? 0);
$notes     = trim($data['notes'] ?? '');

// ✅ التحقق فقط من اسم البند
if ($item_name === '') {
    echo json_encode(["status" => "error", "message" => "⚠️ برجاء إدخال اسم البند"]);
    exit;
}

// 🧠 تجهيز الاستعلام بدون total لأنه GENERATED
$sql = "INSERT INTO ProjectTermsMH (PID, item_name, unit, quantity, price, notes, created_at)
        VALUES (?, ?, ?, ?, ?, ?, NOW())";
$stmt = $conn->prepare($sql);
$stmt->bind_param("issdds", $PID, $item_name, $unit, $quantity, $price, $notes);

// 📤 تنفيذ الحفظ
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم حفظ البند بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ خطأ في الحفظ: " . $stmt->error]);
}

// 🧹 تنظيف الموارد
$stmt->close();
$conn->close();
?>
