<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "db.php"; // ملف الاتصال بقاعدة البيانات

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام البيانات"]);
    exit;
}

// استخراج الحقول
$data_name   = trim($data['contributor_name'] ?? '');
$start_date  = trim($data['start_date'] ?? '');
$value       = trim($data['contribution_value'] ?? '');
$percentage  = trim($data['percentage'] ?? '');
$due_date    = trim($data['due_date'] ?? '');
$profit      = trim($data['profit'] ?? '');
$notes       = trim($data['notes'] ?? '');

// التحقق من الحقول المطلوبة
if ($data_name === "" || $start_date === "" || $value === "" || $due_date === "") {
    echo json_encode(["status" => "error", "message" => "⚠️ كل الحقول المطلوبة يجب أن تكون ممتلئة"]);
    exit;
}

// تحويل الحقول الفارغة للاختيارات إلى NULL
$percentage = $percentage === '' ? null : $percentage;
$profit     = $profit === '' ? null : $profit;
$notes      = $notes === '' ? null : $notes;

// تحضير الاستعلام
$sql = "INSERT INTO financialMH (data_name, start_date, value, percentage, due_date, profit, notes) 
        VALUES (?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ssddsss", $data_name, $start_date, $value, $percentage, $due_date, $profit, $notes);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم إضافة البيان بنجاح", "fund_id" => $stmt->insert_id]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ خطأ أثناء إضافة البيان: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
