<?php
session_start();
header("Content-Type: application/json; charset=UTF-8");
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once "db.php"; // الاتصال بقاعدة البيانات

// التحقق من تسجيل الدخول
$UID = isset($_SESSION['UID']) ? intval($_SESSION['UID']) : null;
if (!$UID) {
    echo json_encode(['success' => false, 'message' => 'يجب تسجيل الدخول أولاً']);
    exit;
}

// قراءة بيانات JSON
$input = json_decode(file_get_contents('php://input'), true);

// جلب البيانات من JSON مع تنظيفها
$method         = mysqli_real_escape_string($conn, $input['payment_method'] ?? '');
$date           = mysqli_real_escape_string($conn, $input['deposit_date'] ?? date('Y-m-d H:i:s'));
$value          = floatval($input['balance_value'] ?? 0);
$RefranNUM      = mysqli_real_escape_string($conn, $input['Refranreference_numberNUM'] ?? '');
$type           = mysqli_real_escape_string($conn, $input['type'] ?? '');
$user_id        = intval($input['user_id'] ?? $UID);
$user_idCST     = intval($input['user_idCST'] ?? $UID);
$AttachmentPath = mysqli_real_escape_string($conn, $input['attachment'] ?? '');
$notes          = mysqli_real_escape_string($conn, $input['notes'] ?? '');

// التحقق من البيانات الأساسية
if (!$method || !$date || !$value || !$type) {
    echo json_encode(['success' => false, 'message' => 'الرجاء إدخال جميع البيانات المطلوبة']);
    exit;
}

// ✅ ترتيب الحقول حسب الجدول
$sql = "INSERT INTO TransactionsMH 
        (method, date, value, RefranNUM, type, user_id, user_idCST, AttachmentPath, notes)
        VALUES 
        ('$method', '$date', '$value', '$RefranNUM', '$type', $user_id, $user_idCST, '$AttachmentPath', '$notes')";

if (mysqli_query($conn, $sql)) {
    echo json_encode(['success' => true, 'message' => '✅ تمت إضافة الرصيد بنجاح']);
} else {
    echo json_encode([
        'success' => false, 
        'message' => '❌ حدث خطأ أثناء حفظ البيانات: ' . mysqli_error($conn)
    ]);
}
?>
