// تحميل المشاريع من قاعدة البيانات
fetch('get_projects.php')
  .then(async res => {
    const text = await res.text();

    try {
      const data = JSON.parse(text);

      // لو السيرفر رجّع خطأ داخل JSON
      if (data.error) {
        throw new Error(data.error);
      }

      const select = document.getElementById('selected-project');
      select.innerHTML = '<option value="All" >  المشاريع </option>';

      data.forEach(project => {
        const option = document.createElement('option');
        option.value = project.id;
        option.textContent = project.name;
        select.appendChild(option);
      });
    } catch (err) {
      console.error("❌ فشل تحويل البيانات إلى JSON:", err.message);
      console.log("🔍 الرد من السيرفر كان:", text);
    }
  })
  .catch(error => {
    console.error("❌ فشل تحميل المشاريع:", error.message);
  });

// التعامل مع اختيار مشروع
handleProjectChange = (selectElement) => {
  const selectedId = selectElement.value;
  const selectedName = selectElement.options[selectElement.selectedIndex].text;

  // ✅ تحويل "All" إلى 0
  const PID = selectedId === "All" ? 0 : parseInt(selectedId);

  // ✅ تحديث النصوص والحقول
  document.getElementById('selected-project-text').textContent = selectedName;
  document.getElementById('selected-project-id').textContent = PID;
  document.getElementById('project-id-hidden').value = PID;

  console.log("✅ تم اختيار المشروع:", PID, selectedName);
  console.log("📌 القيمة النهائية في hidden input:", document.getElementById('project-id-hidden').value);

  // تحميل الإيرادات حسب المشروع
  loadRevenues();
}






//add


//find
let editingRevenueId = null; // وضع تعديل أو إضافة

// إخفاء زر الحذف في البداية
const deleteBtnRevenue = document.getElementById("BTNDeleteRevenue");
if (deleteBtnRevenue) deleteBtnRevenue.style.display = "none";

// 🔹 تحميل جدول الإيرادات
function loadRevenues() {
    const PID = parseInt(document.getElementById("project-id-hidden")?.value) || 0;
    const tableBody = document.getElementById("revenues-table-body");
    if (!tableBody) return;

    fetch("get_revenues.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ PID })
    })
    .then(res => res.json())
    .then(result => {
        if (result.status !== "success") {
            tableBody.innerHTML = '<tr><td colspan="6">❌ فشل في تحميل الإيرادات</td></tr>';
            return;
        }

        const data = Array.isArray(result.data) ? result.data : [];
        if (data.length === 0) {
            tableBody.innerHTML = '<tr><td colspan="6">لا توجد إيرادات مضافة بعد</td></tr>';
            return;
        }

        tableBody.innerHTML = "";
        data.forEach(item => {
            const cleanedAttach = (item.AttachmentPath || "").replace(/^,/, "");
            const safeAttachment = encodeURIComponent(cleanedAttach);

            const attachmentHTML = cleanedAttach
                ? `<div class="navS-icon" style="width: 50px; cursor: pointer;" aria-label="الإيراد PDF"
                     onclick="openAttachment(decodeURIComponent('${safeAttachment}'))">
                     <i class="fas fa-file-pdf"></i>
                     <span class="tooltip">الإيراد PDF</span>
                   </div>`
                : `<span class="no-attachment">—</span>`;

            const row = document.createElement("tr");
            row.innerHTML = `
                <td>${item.project_name || ""}</td>
                <td>${item.RafranceNumber || ""}</td>
                <td>${Number.parseFloat(item.value) || 0}</td>
                <td>${item.date || ""}</td>
                <td>${attachmentHTML}</td>
                <td>${item.notes || ""}</td>
            `;

            row.addEventListener("click", () => {
                document.getElementById("add-revenue-section").style.display = "block";
                document.getElementById("revenues-section").style.display = "none";
                if (deleteBtnRevenue) deleteBtnRevenue.style.display = "block";
                fillRevenueForm(item);
            });

            tableBody.appendChild(row);
        });
    })
    .catch(error => {
        console.error("❌ خطأ في تحميل الإيرادات:", error);
        tableBody.innerHTML = '<tr><td colspan="6">❌ حدث خطأ أثناء تحميل البيانات</td></tr>';
    });
}

// 🔹 تعبئة الفورم بالقيم
function fillRevenueForm(item) {
    const form = document.getElementById("add-revenue-form");
    if (!form) return;

    const setVal = (selector, val) => {
        const el = form.querySelector(selector);
        if (el) el.value = val || "";
    };

    setVal('[name="project_name"]', item.project_name);
    const projInput = form.querySelector('[name="project_name"]');
    if (projInput) projInput.readOnly = true;

    setVal('[name="invoice_number"]', item.RafranceNumber);
    setVal('[name="amount"]', item.value);
    setVal('[name="date"]', item.date);
    setVal('[name="notes"]', item.notes);

    const attachPath = document.getElementById("AttachmentPath");
    if (attachPath) attachPath.value = item.AttachmentPath || "";

    editingRevenueId = item.id;

    document.querySelector("#add-revenue-section h2").innerHTML =
        `<i class="fas fa-money-bill-wave"></i> تعديل إيراد`;

    const section = document.getElementById("add-revenue-section");
    if (section) section.setAttribute("aria-label", "تعديل");

    const saveBtn = document.getElementById("BTNSaveEdit");
    if (saveBtn) {
        const icon = saveBtn.querySelector("i");
        const tooltip = saveBtn.querySelector(".tooltip");

        saveBtn.setAttribute("aria-label", "تعديل");
        if (icon) icon.className = "fas fa-edit";
        if (tooltip) tooltip.textContent = "تعديل";
    }

    applyPermissions();
}

// 🔹 إعادة الفورم لوضع الإضافة
function resetRevenueForm() {
    const form = document.getElementById("add-revenue-form");
    if (form) form.reset();

    editingRevenueId = null;

    document.querySelector("#add-revenue-section h2").innerHTML =
        `<i class="fas fa-money-bill-wave"></i> إضافة إيراد`;

    const section = document.getElementById("add-revenue-section");
    if (section) section.setAttribute("aria-label", "إضافة إيراد");

    const saveBtn = document.getElementById("BTNSaveEdit");
    if (saveBtn) {
        const icon = saveBtn.querySelector("i");
        const tooltip = saveBtn.querySelector(".tooltip");

        saveBtn.setAttribute("aria-label", "إضافة إيراد");
        if (icon) icon.className = "fas fa-save";
        if (tooltip) tooltip.textContent = "حفظ";
    }

    if (deleteBtnRevenue) deleteBtnRevenue.style.display = "none";

    applyPermissions();
}

function openAttachment(attachmentUrl) {
  if (!attachmentUrl) return;

  attachmentUrl = attachmentUrl.trim();

  // لو الرابط نسبي، ضيفه على أصل الموقع الحالي
  if (!attachmentUrl.startsWith("http") && !attachmentUrl.startsWith("/")) {
    const baseUrl = window.location.origin + "/MMM/";
    attachmentUrl = baseUrl + attachmentUrl;
  }

  console.log("📎 فتح المرفق:", attachmentUrl);
  window.open(attachmentUrl, '_blank');
}

// 🔹 التحديث التلقائي
function startRevenuesAutoRefresh() {
    let intervalId = null;

    function checkVisibilityAndUpdate() {
        const section = document.getElementById("revenues-section");
        if (section && section.offsetParent !== null) {
            if (!intervalId) {
                loadRevenues();
                intervalId = setInterval(loadRevenues, 5000);
                console.log("✅ بدأ التحديث التلقائي للإيرادات");
            }
        } else {
            if (intervalId) {
                clearInterval(intervalId);
                intervalId = null;
                console.log("⏸️ توقف التحديث لأن القسم مخفي");
            }
        }
    }

    setInterval(checkVisibilityAndUpdate, 5000);
}

document.addEventListener("DOMContentLoaded", () => {
    loadRevenues();
    startRevenuesAutoRefresh();
});

// 🔹 التعامل مع زر الإضافة
function handleAddRevenueClick(element) {
    const selectedPID = document.getElementById("project-id-hidden").value;
    if (parseInt(selectedPID) === 0) {
        alert("❌ من فضلك اختر مشروع أولًا قبل إضافة الإيراد");
        return;
    }
    toggleRevenueForm();
    setActiveNavIconS(element);
}


//Add sum count and ammount

document.addEventListener('DOMContentLoaded', () => {
    const tbody = document.getElementById('revenues-table-body');
    if (!tbody) return;

    // إنشاء لابل للعدد والمجموع
    const countLabel = document.createElement('div');
    countLabel.id = 'revenues-count';
    countLabel.style.fontWeight = 'bold';
    const totalLabel = document.createElement('div');
    totalLabel.id = 'revenues-total';
    totalLabel.style.fontWeight = 'bold';

    // أيقونات
    const countIcon = '<i class="fas fa-hashtag dropdown-arrow icon-secondary"></i> ';
    const totalIcon = '<i class="fas fa-calculator dropdown-arrow icon-secondary"></i> ';

    // نضيف اللابل بعد الجدول مباشرة
    tbody.parentNode.insertBefore(countLabel, tbody.nextSibling);
    tbody.parentNode.insertBefore(totalLabel, countLabel.nextSibling);

    function updateRevenuesSummary() {
        if (!tbody || tbody.querySelectorAll('tr').length === 0) return;

        const rows = Array.from(tbody.querySelectorAll('tr')).filter(r => !r.classList.contains('no-items'));
        const totalRows = rows.length;
        let totalValue = 0;

        rows.forEach(row => {
            const valueCell = row.cells[2]; // عمود "القيمة"
            if (valueCell) {
                const cellText = valueCell.textContent.trim().replace(/,/g, '');
                const cellValue = parseFloat(cellText) || 0;
                totalValue += cellValue;
            }
        });

        countLabel.innerHTML = `<br>${countIcon}العدد: ${totalRows}<br>`;
        totalLabel.innerHTML = `<br>${totalIcon}المجموع: ${totalValue.toFixed(2)} ريال<br>`;

        countLabel.style.marginTop = "10px";
        countLabel.style.marginBottom = "10px";
        totalLabel.style.marginTop = "10px";
        totalLabel.style.marginBottom = "10px";
    }

    updateRevenuesSummary();

    const observer = new MutationObserver(() => {
        updateRevenuesSummary();
    });
    observer.observe(tbody, { childList: true, subtree: true });
});



//PDF
document.addEventListener("DOMContentLoaded", () => {
  const selectPdfBtn = document.getElementById("selectPdfBtn");
  const fileInput = document.getElementById("pdfFileInput");
  const attachmentField = document.getElementById("AttachmentPath");
  const msg = document.getElementById("projectMsg");

  // عند الضغط على زر اختيار الملف
  selectPdfBtn.addEventListener("click", () => {
    fileInput.click();
  });

  // عند اختيار ملف PDF
  fileInput.addEventListener("change", () => {
    const file = fileInput.files[0];
    if (!file) return;

    const formData = new FormData();
    formData.append("pdfFile", file);

    fetch("upload_pdf.php", {
      method: "POST",
      body: formData
    })
    .then(res => res.json())
    .then(data => {
      if (data.status === "success") {
        const fullPath = data.path; // مثال: DocumentPDF/contract123.pdf
        attachmentField.value = fullPath;

        msg.textContent = `✅ تم رفع الملف: ${file.name}`;
        msg.style.color = "green";
        msg.style.display = "block";

        setTimeout(() => {
          msg.style.display = "none";
        }, 5000);
      } else {
        msg.textContent = `❌ فشل رفع الملف: ${data.message}`;
        msg.style.color = "red";
        msg.style.display = "block";
      }
    })
    .catch(err => {
      console.error("❌ خطأ في رفع الملف:", err);
      alert("❌ فشل الاتصال بالسيرفر");
    });
  });
});



function openPdfFromInput() {
  const input = document.getElementById("AttachmentPath_fullDe");
  const fileName = input.value.trim();

  if (!fileName) {
    alert("⚠️ لازم تدخل اسم الملف");
    return;
  }

  const currentPath = window.location.pathname;
  const folderPath = currentPath.substring(0, currentPath.lastIndexOf("/"));
  const fullURL = `${window.location.origin}${folderPath}/${fileName}`;

  console.log("📂 الرابط النهائي:", fullURL);
  window.open(fullURL, "_blank");
}





//Delete


function deleteRevenue() {
    if (!editingRevenueId) {
        alert("⚠️ لا يوجد إيراد محدد للحذف");
        return;
    }

    if (!confirm("هل أنت متأكد أنك تريد حذف هذا الإيراد؟")) return;

    fetch("delete_revenues.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "Accept": "application/json"
        },
        body: JSON.stringify({ id: editingRevenueId })
    })
    .then(res => res.json())
    .then(response => {
        // عرض الرسالة القادمة من السيرفر
        alert(response.message);

        if (response.status === "success") {
            // إخفاء الفورم وعرض الجدول من جديد
            document.getElementById("add-revenue-section").style.display = "none";
            document.getElementById("revenues-section").style.display = "block";

            // إعادة تحميل الجدول
            loadRevenues();

            // تصفير الـ ID عشان نبدأ إضافة جديدة لو حبينا
            editingRevenueId = null;
        }
    })
    .catch(err => {
        console.error("❌ خطأ أثناء الحذف:", err);
        alert("❌ حدث خطأ أثناء عملية الحذف");
    });
}


//update
// متغيّر عام يخزن ID العنصر الجاري تعديله؛ null يعني إضافة
 editingRevenueId = null;

async function saveRevenue() {
  const form = document.getElementById("add-revenue-form");
  if (!form) return;

  // استخراج القيم المطلوبة
  const invoice_number = form.querySelector('[name="invoice_number"]').value.trim();
  const amount         = form.querySelector('[name="amount"]').value.trim();
  const date           = form.querySelector('[name="date"]').value.trim();
  const notes          = form.querySelector('[name="notes"]').value.trim();
  const AttachmentPath = document.getElementById("AttachmentPath")?.value.trim() || "";

  // تحقق من الحقول المطلوبة
  if (!invoice_number || !amount || !date) {
    alert("⚠️ يرجى إدخال الحقول المطلوبة");
    return;
  }

  // حالة التعديل
  if (editingRevenueId) {
    const payload = {
      id: editingRevenueId,
      invoice_number,
      amount,
      date,
      notes,
      AttachmentPath
    };

    try {
      const res  = await fetch("update_revenue.php", {
        method:  "POST",
        headers: {
          "Content-Type": "application/json",
          "Accept":       "application/json"
        },
        body: JSON.stringify(payload)
      });

      const json = await res.json();
      alert(json.message);

      if (json.status === "success") {
        resetRevenueForm();
        document.getElementById("add-revenue-section").style.display = "none";
        document.getElementById("revenues-section").style.display     = "block";
        loadRevenues();
        editingRevenueId = null;
      }
    } catch (err) {
      console.error("❌ خطأ أثناء التعديل:", err);
      alert("⚠️ فشل الاتصال بالسيرفر أثناء التعديل");
    }

    return;
  }

  // حالة الإضافة
  const formData = new FormData(form);
  const data     = {};
  formData.forEach((value, key) => {
    data[key] = value.trim();
  });

  data.attachment = AttachmentPath;

  try {
    const res  = await fetch("save_revenue.php", {
      method:  "POST",
      headers: { "Content-Type": "application/json" },
      body:    JSON.stringify(data)
    });

    const text = await res.text();
    let json;
    try {
      json = JSON.parse(text);
    } catch {
      alert("❌ الرد من السيرفر ليس بصيغة JSON:\n" + text);
      console.error("رد غير صالح:", text);
      return;
    }

    alert(json.message);
    if (json.status === "success") {
      resetRevenueForm();
      document.getElementById("selected-project-text").textContent = "---";
      document.getElementById("selected-project-id").textContent   = "---";
    }

  } catch (err) {
    console.error("❌ خطأ أثناء الإضافة:", err);
    alert("⚠️ فشل الاتصال بالسيرفر أثناء الإضافة");
  }
}

