<?php
session_start();
if (!isset($_SESSION['username']) || !isset($_SESSION['usertype'])) {
    header("Location: Login.php");
    exit();
}
?>


<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=1024, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <!-- ألوان شريط الحالة للـ Android -->
<meta name="theme-color" content="#ffffff">
<!-- للـ iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
  <title>MADAD HOLDING Management System</title>
  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
<link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">



</head>
<body>

  <!-- Header -->
 <?php include 'header.php'; ?>


  <!-- Main Content -->
  <main class="main-content" id="main-content" role="main">

<section class="projects-container" aria-label="المشاريع">
  <div class="section-header" style="display: flex; align-items: center; justify-content: space-between;">
    
    <!-- العنوان مع الـ combobox -->
    <div style="display: flex; align-items: center; gap: 15px;">
      <h2 class="section-title" style="display: flex; align-items: center; gap: 8px; margin: 0;">
        <i class="fas fa-city icon-secondary" aria-hidden="true"></i>
        المشاريع
      </h2>

      <!-- combobox -->
         <div class="form-field">
        <i class="fas fa-building icon-secondary"></i>
       
          <select id="selected-project" onchange="handleProjectChange(this); syncProjectIdInputs()" required>

          <option value="All" >  المشاريع </option>
        </select>
      </div>
    </div>

    <!-- الأيقونات -->
    <div style="display: flex; align-items: center; gap: 10px;">
      
      <!-- إضافة مشروع -->
      <div class="navS-icon" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="إضافة مشروع" 
           onclick="toggleAddProject(); setActiveNavIconS(this)" >
        <i class="fas fa-plus-circle"></i>
        <span class="tooltip" role="tooltip">إضافة مشروع</span>
      </div>

<div class="navS-icon ٍٍ" tabindex="1" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="إضافة بند" 
           onclick="addItem(); setActiveNavIconS(this); showProjectDetails();" >
         <i class="fas fa-file-circle-plus"></i>
        <span class="tooltip" role="tooltip">تفصيل المشروع </span>
      </div>

  
      <!-- عرض المشاريع -->
     <div class="navS-icon active" tabindex="2" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="عرض المشاريع" 
           onclick="AllProject(); setActiveNavIconS(this)" >
        <i class="fas fa-list"></i>
        <span class="tooltip" role="tooltip"> المشاريع</span>
      </div>

    </div>
  </div>


  <div id="projectMsg" style="margin-top:10px; font-weight:bold; display:none;"></div>

  <p hidden>اسم المشروع: <span id="selected-project-text">---</span></p>
<p hidden>رقم المشروع (ID): <span id="selected-project-id">---</span></p>

<!-- تجربة عرض الـ ID في input -->
<input type="hidden" value="0" id="project-id-hidden" name="project_id">
    
</section>

<br>

<section id="add-project-section" class="projects-container" aria-label="المشاريع والإحصائيات" style="display: none;" >
  <div style="display: flex; align-items: center; justify-content: space-between;">
    <!-- عنوان إضافة مشروع -->
    <h2 class="section-title" style="margin: 0; display: flex; align-items: center; gap: 8px;">
      <i class="fas fa-city icon-secondary" aria-hidden="true"></i>
      اضافه مشروع  
    </h2>

     <!-- زر حفظ المشروع -->
    <div style="display: flex; gap: 10px;">

     <div class="navS-icon" id="BTNDelete" tabindex="0" role="button" 
         style="display:none; width: 50px; cursor: pointer;" aria-label="حذف" onclick="deleteProject()">
      <i class="fas fa-trash-alt"></i>
      <span class="tooltip" role="tooltip">حذف</span>
    </div>


  <div id="save-project-btn" class="navS-icon" tabindex="0" role="button"
       style="width: 50px; cursor: pointer;"
       aria-label="حفظ"  >
    <i class="fas fa-save"></i>
    <span class="tooltip" role="tooltip">حفظ</span>
  </div>

      <!-- الزرار -->
<div class="navS-icon" id="selectPdfBtn" tabindex="0" role="button" style="width: 50px; cursor: pointer;" aria-label="العقد PDF">
  <i class="fas fa-file-pdf"></i>
  <span class="tooltip" role="tooltip">العقد PDF</span>
</div>

<!-- عنصر اختيار الملف المخفي -->
<input type="file" id="pdfFileInput" accept=".pdf" style="display: none;">

    </div>
      </div>


      <form id="add-project-form" style="margin-top: 15px;">

          <input type="hidden" value="" id="AttachmentPath" name="AttachmentPath">

  <!-- اسم المشروع -->
  <div class="form-field">
    <i class="fas fa-project-diagram icon-secondary"></i>
    <input type="text" name="project_name" placeholder="اسم المشروع" required>
  </div>

  <!-- المالك -->
  <div class="form-field">
    <i class="fas fa-user-tie icon-secondary"></i>
    <input type="text" name="project_owner" placeholder="المالك" required>
  </div>

  <!-- حالة المشروع -->
  <div class="form-field">
    <i class="fas fa-tasks icon-secondary"></i>
    <select name="project_status" required>
      <option value=""disabled selected>حالة المشروع</option>
      <option value="تحت الدراسة">تحت الدراسة</option>
      <option value="جاري العمل على العقود">جاري العمل على العقود</option>
      <option value="بدء العمل">بدء العمل</option>
      <option value="تم بنجاح">تم بنجاح</option>
    </select>
  </div>

  <!-- موقع المشروع -->
  <div class="form-field">
    <i class="fas fa-map-marker-alt icon-secondary"></i>
    <input type="text" name="project_location" placeholder="موقع المشروع" required>
  </div>

  <!-- تكلفة المشروع -->
  <div class="form-field">
    <i class="fas fa-dollar-sign icon-secondary"></i>
    <input type="number" name="project_cost" placeholder="تكلفة المشروع" required>
  </div>

  <!-- مدة المشروع -->
  <div class="form-field">
    <i class="fas fa-clock icon-secondary"></i>
    <input type="text" name="project_duration" placeholder="مدة المشروع" required>
  </div>


  <div id="projectMsg" style="margin-top:10px; font-weight:bold; display:none;"></div>

</form>


</section>


<br>



<section id="project-details" class="projects-container" aria-label="تفاصيل المشروع والبنود" style="display: none;">

  <h2 class="section-title" style="display: flex; align-items: center; gap: 8px;">
    <i class="fas fa-info-circle" aria-hidden="true"></i>
    تفاصيل المشروع
  </h2>

  <!-- معلومات المشروع -->
  <div class="project-info" style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px; margin-bottom: 30px;">
    <div class="info-item">
      <i class="fas fa-project-diagram icon-secondary"></i>
      <span class="info-text" id="project-name-display"> : مشروع </span>
    </div>
    <div class="info-item">
      <i class="fas fa-user-tie icon-secondary"></i>
      <span class="info-text" id="project-owner-display">المالك: —</span>
    </div>
    <div class="info-item">
      <i class="fas fa-tasks icon-secondary"></i>
      <span class="info-text" id="project-status-display">الحاله : —</span>
    </div>
    <div class="info-item">
      <i class="fas fa-map-marker-alt icon-secondary"></i>
      <span class="info-text" id="project-location-display">الموقع : —</span>
    </div>
    <div class="info-item">
      <i class="fas fa-dollar-sign icon-secondary"></i>
      <span class="info-text" id="project-cost-display">التكلفة: —</span>
    </div>
    <div class="info-item">
      <i class="fas fa-clock icon-secondary"></i>
      <span class="info-text" id="project-duration-display">المدة: —</span>
    </div>

   
      
  </div>

<div style="display: flex; align-items: center; justify-content: space-between; width: 100%;">

  <!-- العنوان -->
  <h3 class="section-subtitle" style="display: flex; align-items: center; gap: 8px; margin: 0;">
    <i class="fas fa-file-alt icon-secondary"></i>
    <span class="primary-text">بنود العقد</span>
  </h3>

  <!-- مجموعة الأزرار -->
  <div style="display: flex; gap: 10px;">


 <!-- الزرار اللي هيفتح الرابط -->
<div class="navS-icon" id="selectPdfBtn" onclick="openPdfFromInput()" tabindex="0" role="button" style="width: 50px; cursor: pointer;" aria-label="العقد PDF">
  <i class="fas fa-file-pdf"></i>
  <span class="tooltip" role="tooltip">العقد PDF</span>
</div>


<!-- حقل الرابط -->
<input type="hidden" value="" id="AttachmentPath_fullDe" name="AttachmentPath_fullDe">



    <div class="navS-icon" tabindex="0" role="button" style="width: 50px; cursor: pointer;" aria-label="إضافة بند" onclick="Add_item_Anim()">
      <i class="fas fa-file-circle-plus"></i>
      <span class="tooltip" role="tooltip">إضافة بند</span>
    </div>

  </div>

</div>

<br>
<table class="items-table">
<thead>
  <tr>
    <th><i class="fas fa-tag icon-secondary"></i> اسم البند</th>
    <th><i class="fas fa-info-circle icon-secondary"></i> حالة البند</th>
    <th><i class="fas fa-ruler-combined icon-secondary"></i> وحدة القياس</th>
    <th><i class="fas fa-sort-numeric-up icon-secondary"></i> الكمية</th>
    <th><i class="fas fa-dollar-sign icon-secondary"></i> السعر</th>
    <th><i class="fas fa-calculator icon-secondary"></i> الإجمالي</th>
    <th><i class="fas fa-sticky-note icon-secondary"></i> ملاحظات</th>
  </tr>
</thead>

  <tbody id="items-table-body">
    <tr>
      <td colspan="7" class="no-items">لا توجد بنود مضافة بعد</td>
    </tr>
  </tbody>
</table>

</section>






<br>

<section id="all-projects" class="projects-container" aria-label="قائمة جميع المشاريع">
  <h2 class="section-title" style="display: flex; align-items: center; gap: 8px;">
    <i class="fas fa-city icon-secondary" aria-hidden="true"></i>
    المشاريع
  </h2>

  <!-- نفس تنسيق عرض البيانات -->
  <div style="display: flex; align-items: center; justify-content: space-between; width: 100%; margin-bottom: 10px;">
    
    <table class="items-table">
      <thead>
        <tr>
          <th><i class="fas fa-building icon-secondary"></i> اسم المشروع</th>
          <th><i class="fas fa-user-tie icon-secondary"></i> المالك</th>
          <th><i class="fas fa-map-marker-alt icon-secondary"></i> الموقع</th>
          <th><i class="fas fa-tasks icon-secondary"></i> الحالة</th>
          <th><i class="fas fa-dollar-sign icon-secondary"></i> التكلفة</th>
          <th><i class="fas fa-clock icon-secondary"></i> المدة</th>
        </tr>
      </thead>
      <tbody id="projects-table-body">
        <tr>
          <td colspan="6" class="no-items">جارٍ تحميل المشاريع...</td>
        </tr>
      </tbody>
    </table>

  </div>
</section>


<br>


<section id="add-item-section"  class="projects-container" aria-label="إضافة بند في العقد" style="display: none;">
  <div id="add-item-section"  style="display: flex; align-items: center; justify-content: space-between;">
    <!-- عنوان إضافة بند -->
    <h2 class="section-title" style="margin: 0; display: flex; align-items: center; gap: 8px;">
      <i class="fas fa-file-circle-plus" aria-hidden="true"></i>
      إضافة بند  
    </h2>

   <div style="display: flex; gap: 10px;">
     <div class="navS-icon" id="BTNDeleteItem" tabindex="0" role="button" 
         style="display:none; width: 50px; cursor: pointer;" aria-label="حذف" onclick="deleteItem()">
      <i class="fas fa-trash-alt"></i>
      <span class="tooltip" role="tooltip">حذف</span>
    </div>

  <div id="btnSaveItem" class="navS-icon" tabindex="0" role="button"
       style="width: 50px; cursor: pointer;"
       aria-label="حفظ البند" >
    <i class="fas fa-save"></i>
    <span class="tooltip" role="tooltip">حفظ</span>
  </div>
</div>

  </div>

 <form id="add-item-form" style="margin-top: 15px;">
<input type="hidden" value="0" id="project-id-hidden2nd" name="project_id2nd">
<input type="hidden" value="0" id="item-id-hidden" name="item-id-hidden">

  <!-- اسم البند -->
  <div class="form-field">
    <i class="fas fa-tag icon-secondary"></i>
    <input type="text" name="item_name" placeholder="اسم البند" required>
  </div>

  <!-- وحدة القياس -->
 <div class="form-field">
      <i class="fas fa-ruler-combined icon-secondary"></i>
     <select name="unit" required>
  <option value="" disabled selected>اختر وحدة القياس</option>
  <option value="طن">طن</option>
  <option value="كجم">كجم</option>
  <option value="جم">جم</option>
  <option value="متر">متر</option>
  <option value="سم">سم</option>
  <option value="متر مربع">م² (متر مربع)</option>
  <option value="متر مكعب">م³ (متر مكعب)</option>
  <option value="قطعة">قطعة</option>
  <option value="دستة">دستة</option>
  <option value="كيس">كيس</option>
  <option value="علبة">علبة</option>
  <option value="كرتونة">كرتونة</option>
  <option value="باكت">باكت</option>
  <option value="رول">رول</option>
  <option value="زجاجة">زجاجة</option>
  <option value="عبوة">عبوة</option>
  <option value="أنبوب">أنبوب</option>
  <option value="برميل">برميل</option>
  <option value="جالون">جالون</option>
  <option value="لتر">لتر</option>
  <option value="مل">مل</option>
  <option value="وحدة">وحدة</option>
  <option value="جهاز">جهاز</option>
  <option value="بطارية">بطارية</option>
  <option value="لمبة">لمبة</option>
  <option value="طوبة">طوبة</option>
  <option value="شكاير">شكاير</option>
  <option value="أخرى">أخرى</option>
</select>

    </div>


  <!-- الكمية -->
  <div class="form-field">
    <i class="fas fa-sort-numeric-up icon-secondary"></i>
    <input type="number" name="quantity" placeholder="الكمية" >
  </div>

  <!-- السعر -->
  <div class="form-field">
    <i class="fas fa-dollar-sign icon-secondary"></i>
    <input type="number" name="price" placeholder="السعر" >
  </div>

  <!-- الإجمالي (readonly) -->
  <div class="form-field">
    <i class="fas fa-calculator icon-secondary"></i>
    <input type="number" name="total" placeholder="الإجمالي" >
  </div>

  <!-- ملاحظات -->
  <div class="form-field">
    <i class="fas fa-sticky-note icon-secondary"></i>
    <input type="text" name="notes" placeholder="ملاحظات">
  </div>


</form>

<div id="responseMsg" style="margin-top:10px; font-weight:bold;"></div>

</section>



<div id="messageBox" style="display: none; padding: 10px; margin: 10px 0; border-radius: 5px; font-weight: bold;"></div>



    <!-- Chart Section -->
    
  </main>

  <!-- Scroll Top Button -->
  <button id="scrollTopBtn" class="fas fa-arrow-up"
          onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>

   <!-- Footer -->




<?php include 'footer.php'; ?>



  <!-- Scripts -->


  
<script>

  function syncProjectIdInputs() {
  const input1 = document.getElementById("project-id-hidden");
  const input2 = document.getElementById("project-id-hidden2nd");

  if (!input1 || !input2) return;

  // مزامنة أولية
  input2.value = input1.value;

  // مزامنة عند التغيير
  input1.addEventListener("input", () => {
    input2.value = input1.value;
  });
}


  </script>



  <script>





    document.getElementById('currentYear').textContent = new Date().getFullYear();

// منع تحديد النصوص
document.addEventListener('selectstart', function (e) {
    e.preventDefault();
}, false);

// منع الكليك يمين
document.addEventListener('contextmenu', function (e) {
    e.preventDefault();
}, false);

// منع السحب
document.addEventListener('dragstart', function (e) {
    e.preventDefault();
}, false);

// منع الحفظ وأوامر المطور
window.addEventListener('keydown', function (e) {
    // اختصارات Ctrl + (S, U, P, C, X, A)
    if (e.ctrlKey && ['s', 'u', 'p', 'c', 'x', 'a'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ هذا الاختصار معطل على هذا الموقع");
    }
    // منع F12
    if (e.key === 'F12') {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
    // منع Ctrl+Shift+I و Ctrl+Shift+J
    if (e.ctrlKey && e.shiftKey && ['i', 'j'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
}, true); // capture mode
</script>



<script>
  let pageIdentifier = "projects";
</script>
  <script src="script.js"></script>

  <script src="ProjectAJAX.js" defer></script>
</body>
</html>