// تحميل المشاريع من قاعدة البيانات
fetch('get_projects.php')
  .then(async res => {
    const text = await res.text();

    try {
      const data = JSON.parse(text);

      // لو السيرفر رجّع خطأ داخل JSON
      if (data.error) {
        throw new Error(data.error);
      }

      const select = document.getElementById('selected-project');
      select.innerHTML = '<option value="All" >  المشاريع </option>';

      data.forEach(project => {
        const option = document.createElement('option');
        option.value = project.id;
        option.textContent = project.name;
        select.appendChild(option);
      });
    } catch (err) {
      console.error("❌ فشل تحويل البيانات إلى JSON:", err.message);
      console.log("🔍 الرد من السيرفر كان:", text);
    }
  })
  .catch(error => {
    console.error("❌ فشل تحميل المشاريع:", error.message);
  });

// التعامل مع اختيار مشروع
handleProjectChange = (selectElement) => {
  const selectedId = selectElement.value;
  const selectedName = selectElement.options[selectElement.selectedIndex].text;

  // ✅ تحويل "All" إلى 0
  const PID = selectedId === "All" ? 0 : parseInt(selectedId);

  // ✅ تحديث النصوص والحقول
  document.getElementById('selected-project-text').textContent = selectedName;
  document.getElementById('selected-project-id').textContent = PID;
  document.getElementById('project-id-hidden').value = PID;

  console.log("✅ تم اختيار المشروع:", PID, selectedName);
  console.log("📌 القيمة النهائية في hidden input:", document.getElementById('project-id-hidden').value);

  // تحميل الإيرادات حسب المشروع

loadProfits();
}


//Find


function loadProfits() {
  const PID = parseInt(document.getElementById("project-id-hidden").value) || 0;
  const tableBody = document.getElementById("profits-table-body");

  fetch("get_profits.php", {
    method: "POST",
    headers: {
      "Content-Type": "application/json"
    },
    body: JSON.stringify({ PID: PID })
  })
    .then(response => response.json())
    .then(result => {
      if (result.status !== "success") {
        tableBody.innerHTML = `
          <tr>
            <td colspan="6" class="error-row">❌ ${result.message}</td>
          </tr>
        `;
        return;
      }

      const data = result.data;

      if (data.length === 0) {
        tableBody.innerHTML = `
          <tr>
            <td colspan="6" class="no-items">لا توجد بيانات أرباح مضافة بعد</td>
          </tr>
        `;
        return;
      }

      // بناء الصفوف
      tableBody.innerHTML = "";
      data.forEach(item => {
        const row = document.createElement("tr");

        row.innerHTML = `
          <td>${item.project_name}</td>
          <td>${item.total_expense.toLocaleString()} ﷼</td>
          <td>${item.total_revenue.toLocaleString()} ﷼</td>
          <td>${item.profit.toLocaleString()} ﷼</td>
          <td>${item.percentage}%</td>
          <td>${item.notes || "-"}</td>
        `;

        tableBody.appendChild(row);
      });
    })
    .catch(error => {
      console.error("خطأ في جلب الأرباح:", error);
      tableBody.innerHTML = `
        <tr>
          <td colspan="6" class="error-row">❌ حدث خطأ أثناء تحميل البيانات</td>
        </tr>
      `;
    });
}


document.addEventListener("DOMContentLoaded", function () {
  // تشغيل أول مرة
  loadProfits();

  // تحديث كل 5 ثواني
  setInterval(loadProfits, 5000);
});


document.addEventListener('DOMContentLoaded', () => {
    const tbody = document.getElementById('profits-table-body');
    if (!tbody) return;

    // إنشاء لابل للعدد والمجموع
    const countLabel = document.createElement('div');
    countLabel.id = 'profits-count';
    countLabel.style.fontWeight = 'bold';
    const totalLabel = document.createElement('div');
    totalLabel.id = 'profits-total';
    totalLabel.style.fontWeight = 'bold';

    // أيقونات
    const countIcon = '<i class="fas fa-hashtag dropdown-arrow icon-secondary"></i> ';
    const totalIcon = '<i class="fas fa-coins dropdown-arrow icon-secondary"></i> ';

    // نضيف اللابل بعد الجدول مباشرة
    tbody.parentNode.insertBefore(countLabel, tbody.nextSibling);
    tbody.parentNode.insertBefore(totalLabel, countLabel.nextSibling);

    function updateProfitsSummary() {
        if (!tbody || tbody.querySelectorAll('tr').length === 0) return;

        const rows = Array.from(tbody.querySelectorAll('tr')).filter(r => !r.classList.contains('no-items'));
        const totalRows = rows.length;
        let totalProfit = 0;

        rows.forEach(row => {
            const profitCell = row.cells[3]; // عمود "الأرباح"
            if (profitCell) {
                const cellText = profitCell.textContent.trim().replace(/,/g, '').replace(/ج\.م/g, '');
                const cellValue = parseFloat(cellText) || 0;
                totalProfit += cellValue;
            }
        });

        countLabel.innerHTML = `<br>${countIcon}عدد المشاريع: ${totalRows}<br>`;
        totalLabel.innerHTML = `<br>${totalIcon}إجمالي الأرباح: ${totalProfit.toFixed(2)} ﷼<br>`;

        countLabel.style.marginTop = "10px";
        countLabel.style.marginBottom = "10px";
        totalLabel.style.marginTop = "10px";
        totalLabel.style.marginBottom = "10px";
    }

    updateProfitsSummary();

    const observer = new MutationObserver(() => {
        updateProfitsSummary();
    });
    observer.observe(tbody, { childList: true, subtree: true });
});
