<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
    <meta name="viewport" content="width=1024, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <!-- ألوان شريط الحالة للـ Android -->
<meta name="theme-color" content="#ffffff">
<!-- للـ iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
<title>MADAD HOLDING Management System</title>
  
  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
 <link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">
  <!-- Chart.js with 3D plugin -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-3d@latest/dist/chartjs-plugin-3d.min.js"></script>








</head>
<body>

 <!-- Header -->
<?php include 'header.php'; ?>

  <!-- Main Content -->
  <main class="main-content" role="main">
   



<section class="projects-container" aria-label="الأرباح">
  <div class="section-header" style="display: flex; align-items: center; justify-content: space-between;">

    <!-- العنوان مع اختيار المشروع -->
    <div style="display: flex; align-items: center; gap: 15px;">
      <h2 class="section-title" style="display: flex; align-items: center; gap: 8px; margin: 0;">
        <i class="fas fa-coins" aria-hidden="true"></i>
        الأرباح
      </h2>

      <!-- اختيار المشروع -->
       <div class="form-field">
        <i class="fas fa-building icon-secondary"></i>
       
          <select id="selected-project" onchange="handleProjectChange(this)" required>

          <option value="All" >  المشاريع </option>
        </select>
      </div>
    </div>

        <input type="hidden" id="selected-project" name="selected-project">
      </div>
    </div>

  </div>
</section>



<br>


<section id="profits-section" class="projects-container" aria-label="قائمة الأرباح">


   <p hidden>اسم المشروع: <span id="selected-project-text">---</span></p>
<p hidden>رقم المشروع (ID): <span id="selected-project-id">---</span></p>

<!-- تجربة عرض الـ ID في input -->
<input type="hidden" value="0" id="project-id-hidden" name="project_id">


  <!-- العنوان -->
  <h2 class="section-title" style="display: flex; align-items: center; gap: 8px;">
    <i class="fas fa-coins" aria-hidden="true"></i>
    الأرباح
  </h2>

  <!-- جدول الأرباح -->
  <div style="display: flex; width: 100%; margin-bottom: 10px;">
    <table class="items-table">
      <thead>
        <tr>
           <th><i class="fas fa-building icon-secondary"></i>  المشروع   </th>
          <th><i class="fas fa-receipt icon-secondary"></i> المصروفات</th>
          <th><i class="fas fa-money-bill-wave icon-secondary"></i> الإيرادات</th>
         
          <th><i class="fas fa-coins icon-secondary"></i> الأرباح</th>
          <th><i class="fas fa-percentage icon-secondary"></i> نسبة الربح</th>
          <th><i class="fas fa-sticky-note icon-secondary"></i> ملاحظات</th>
        </tr>
      </thead>
      <tbody id="profits-table-body">
        <tr>
          <td colspan="7" class="no-items">لا توجد بيانات أرباح مضافة بعد</td>
        </tr>
      </tbody>
    </table>
  </div>

</section>
<br>


    <!-- Chart Section -->
   
<section id="chart-section" class="chart-container" aria-label="قسم الرسم البياني" dir="rtl" style="display: none;">
  <div class="chart-header">
    <h3 class="chart-title">
      <i class="fas fa-chart-line icon-primary"></i>
      تحليل الأداء المالي
    </h3>

    <!-- Chart Controls -->
    <div class="chart-controls">
      <!-- Chart Type -->
    

      <!-- Time Filter -->
      <div class="time-btn-group" role="group" aria-label="اختيار الفترة الزمنية">
        <button class="time-btn"><i class="fas fa-calendar-week"></i> <span>أسبوع</span></button>
        <button class="time-btn active"><i class="fas fa-calendar-alt"></i> <span>شهر</span></button>
        <button class="time-btn"><i class="fas fa-calendar"></i> <span>سنة</span></button>
        <button class="time-btn"><i class="fas fa-infinity"></i> <span>الكل</span></button>
      </div>
    </div>
  </div>

  <!-- Chart -->
  <div class="chart-placeholder">
    <canvas id="financialChart"></canvas>
  </div>
</section>
  </main>

  <!-- Scroll Top Button -->
  <button id="scrollTopBtn" class="fas fa-arrow-up"
          onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>


          
 <!-- Footer -->
<?php include 'footer.php'; ?>

  <!-- Scripts -->
  <script>
    document.getElementById('currentYear').textContent = new Date().getFullYear();
  </script>

  <script>
// منع تحديد النصوص
document.addEventListener('selectstart', function (e) {
    e.preventDefault();
}, false);

// منع الكليك يمين
document.addEventListener('contextmenu', function (e) {
    e.preventDefault();
}, false);

// منع السحب
document.addEventListener('dragstart', function (e) {
    e.preventDefault();
}, false);

// منع الحفظ وأوامر المطور
window.addEventListener('keydown', function (e) {
    // اختصارات Ctrl + (S, U, P, C, X, A)
    if (e.ctrlKey && ['s', 'u', 'p', 'c', 'x', 'a'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ هذا الاختصار معطل على هذا الموقع");
    }
    // منع F12
    if (e.key === 'F12') {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
    // منع Ctrl+Shift+I و Ctrl+Shift+J
    if (e.ctrlKey && e.shiftKey && ['i', 'j'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
}, true); // capture mode
</script>




<script>
  let pageIdentifier = "profits";
</script>
  <script src="script.js"></script>
 
   <script src="profitsAjax.js"></script>
</body>
</html>