<?php
header("Content-Type: application/json; charset=UTF-8");
ini_set('display_errors', 1);
error_reporting(E_ALL);
require_once "db.php";

// ✅ جلب البيانات من قاعدة البيانات مع ترتيب الأعمدة حسب العرض
$sql = "SELECT 
    t.`method`, 
    DATE(t.`date`) AS date,
    t.`value`, 
    t.`RefranNUM`, 
    t.`type`, 
    t.`AttachmentPath`,
    t.`notes`, 
    u.`username` AS user_name,
    t.`id`
FROM `TransactionsMH` t
LEFT JOIN `USEUSERSMH` u ON u.`id` = t.`user_id`
ORDER BY t.`date` DESC";

$result = mysqli_query($conn, $sql);
$transactions = [];

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $transactions[] = $row;
    }
    echo json_encode(['success' => true, 'data' => $transactions], JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode([
        'success' => false,
        'message' => '❌ فشل في تنفيذ الاستعلام',
        'error' => mysqli_error($conn)
    ], JSON_UNESCAPED_UNICODE);
}
?>
