<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=UTF-8');
date_default_timezone_set('Africa/Cairo');

// استدعاء ملف الاتصال
require_once "db.php";

// ✅ عدّل اسم الجدول والعمود حسب الموجود فعليًا
$sql = "SELECT id, project_name FROM PrjectsMH";
$result = mysqli_query($conn, $sql);

if (!$result) {
    echo json_encode(["error" => "❌ خطأ في الاستعلام: " . mysqli_error($conn)]);
    exit;
}

$projects = [];
while ($row = mysqli_fetch_assoc($result)) {
    $projects[] = [
        'id'   => $row['id'],
        'name' => $row['project_name']
    ];
}

echo json_encode($projects, JSON_UNESCAPED_UNICODE);
mysqli_close($conn);
?>
