
function FindtoggleNewCustomSelect() {
  const section = document.getElementById('add-fund-section');
  const sectionDetails = document.getElementById('contributors-section');
  const removefund = document.getElementById('remove-fund-section');

  if (section && sectionDetails) {
    section.style.display = 'none';
     removefund.style.display = 'none';
    sectionDetails.style.display = 'block';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
  }
}



function toggleRemoveF() {
  const section = document.getElementById('add-fund-section');
  const sectionDetails = document.getElementById('contributors-section');
 const removefund = document.getElementById('remove-fund-section');

  if (section && sectionDetails) {
    section.style.display = 'none';
    sectionDetails.style.display = 'none';
    removefund.style.display = 'block';
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
  }
}




//Get All DateName

function loadFinancialNames() {
  fetch("get_financial_names.php")
    .then(res => res.json())
    .then(result => {
      const select = document.getElementById("Date_Name");
      const hiddenInput = document.getElementById("Date_Name-hidden");

      if (!result.success || !Array.isArray(result.data)) return;

      result.data.forEach(item => {
        const option = document.createElement("option");
        option.value = item.id;
        option.textContent = item.data_name;
        select.appendChild(option);
      });

      // عند تغيير الاختيار، احفظ الـ id في الحقل المخفي
      select.addEventListener("change", () => {
        hiddenInput.value = select.value !== "All" ? select.value : "0";
      });
    })
    .catch(err => {
      console.error("❌ خطأ في تحميل البيانات:", err);
    });
}

document.addEventListener("DOMContentLoaded", loadFinancialNames);


//fund
let editingFundId = null; // وضع تعديل أو إضافة

const deleteBtnFund = document.getElementById("deleteBtnFund");
if (deleteBtnFund) deleteBtnFund.style.display = "none";

// 🔹 تحميل جدول رأس المال
function loadFundsTable() {
    const tbody = document.getElementById("contributors-table-body");
    if (!tbody) return;

    fetch("get_funds.php")
    .then(r => r.json())
    .then(data => {
        if (!data || data.length === 0) {
            tbody.innerHTML = `<tr><td colspan="7" class="no-items">لا توجد بيانات مضافة بعد</td></tr>`;
            return;
        }

        tbody.innerHTML = "";
        data.forEach(row => {
            const tr = document.createElement("tr");
            tr.innerHTML = `
                <td>${row.data_name}</td>
                <td>${row.start_date}</td>
                <td>${row.value}</td>
                <td>${row.percentage} %</td>
                <td>${row.due_date}</td>
                <td>${row.profit || ''}</td>
                <td>${row.notes || ''}</td>
            `;

            // 📌 عند الضغط على الصف → إدخال البيانات في الفورم وتفعيل وضع التعديل
            tr.addEventListener("click", () => {
                document.getElementById("add-fund-section").style.display = "block";
                document.getElementById("contributors-section").style.display = "none";
                if (deleteBtnFund) deleteBtnFund.style.display = "block";
                fillFundForm(row);
            });

            tbody.appendChild(tr);
        });
    })
    .catch(err => {
        console.error(err);
        tbody.innerHTML = `<tr><td colspan="7" class="no-items">❌ حدث خطأ أثناء تحميل البيانات</td></tr>`;
    });
}

// 🔹 تعبئة النموذج بالقيم
function fillFundForm(item) {
    const form = document.getElementById("add-fund-form");
    if (!form) return;

    // 🔹 دالة لتنظيف الأرقام المنسقة وتحويلها لرقم صالح
    const cleanNumber = (val) => parseFloat(String(val).replace(/,/g, '')) || 0;

    const setVal = (selector, val) => {
        const el = form.querySelector(selector);
        if (el) el.value = val || "";
    };

    setVal('[name="contributor_name"]', item.data_name);
    setVal('[name="start_date"]', item.start_date);
    setVal('[name="contribution_value"]', cleanNumber(item.value)); // ✅ معالجة الفواصل
    setVal('[name="percentage"]', item.percentage);
    setVal('[name="due_date"]', item.due_date);
    setVal('[name="profit"]', item.profit);
    setVal('[name="notes"]', item.notes);

    editingFundId = item.id;

    document.querySelector("#add-fund-section h2").innerHTML =
        `<i class="fas fa-hand-holding-usd"></i> تعديل بيان رأس مال`;

    const section = document.getElementById("add-fund-section");
    if (section) section.setAttribute("aria-label", "تعديل");

    const saveBtn = document.getElementById("BTNSaveFund");
    if (saveBtn) {
        const icon = saveBtn.querySelector("i");
        const tooltip = saveBtn.querySelector(".tooltip");

        saveBtn.setAttribute("aria-label", "تعديل");
        if (icon) icon.className = "fas fa-edit";
        if (tooltip) tooltip.textContent = "تعديل";
    }

    applyPermissions();
}

// 🔹 إعادة النموذج لوضع الإضافة
function resetFundForm() {
    const form = document.getElementById("add-fund-form");
    if (form) form.reset();

    editingFundId = null;

    document.querySelector("#add-fund-section h2").innerHTML =
        `<i class="fas fa-hand-holding-usd"></i> إضافة بيان رأس مال`;

    const section = document.getElementById("add-fund-section");
    if (section) section.setAttribute("aria-label", "إضافة");

    const saveBtn = document.getElementById("BTNSaveFund");
    if (saveBtn) {
        const icon = saveBtn.querySelector("i");
        const tooltip = saveBtn.querySelector(".tooltip");

        saveBtn.setAttribute("aria-label", "إضافة");
        if (icon) icon.className = "fas fa-save";
        if (tooltip) tooltip.textContent = "حفظ";
    }

    if (deleteBtnFund) deleteBtnFund.style.display = "none";

    applyPermissions();
}




//add

// 🔹 حفظ البيان

// 🔹 التحديث التلقائي
function startFundsAutoRefresh() {
    let intervalId = null;

    function checkVisibilityAndUpdate() {
        const section = document.getElementById("contributors-section");
        if (section && section.offsetParent !== null) {
            if (!intervalId) {
                loadFundsTable();
                intervalId = setInterval(loadFundsTable, 5000);
                console.log("✅ بدأ التحديث التلقائي لرأس المال");
            }
        } else {
            if (intervalId) {
                clearInterval(intervalId);
                intervalId = null;
                console.log("⏸️ توقف التحديث لأن القسم مخفي");
            }
        }
    }

    setInterval(checkVisibilityAndUpdate, 5000);
}



// 🔹 زر الإضافة
function handleAddFundClick(element) {
    const selectedPID = document.getElementById("project-id-hidden").value;

    if (parseInt(selectedPID) === 0) {
        alert("❌ من فضلك اختر مشروع أولًا قبل إضافة البيان");
        return;
    }

    toggleFundForm();
    setActiveNavIconS(element);
}




// ✅ تشغيل التحديث التلقائي عند ظهور القسم
document.addEventListener("DOMContentLoaded", () => {
    loadFundsTable();
    startFundsAutoRefresh();

    const saveBtn = document.getElementById("BTNSaveFund");
    if (saveBtn) saveBtn.addEventListener("click", saveFund);
});
// 🔹 حساب العدد والمجموع
document.addEventListener('DOMContentLoaded', () => {
    const tbody = document.getElementById('contributors-table-body');
    if (!tbody) return;

    const countLabel = document.createElement('div');
    countLabel.id = 'funds-count';
    countLabel.style.fontWeight = 'bold';
    const totalLabel = document.createElement('div');
    totalLabel.id = 'funds-total';
    totalLabel.style.fontWeight = 'bold';

    const countIcon = '<i class="fas fa-hashtag dropdown-arrow icon-secondary"></i> ';
    const totalIcon = '<i class="fas fa-calculator dropdown-arrow icon-secondary"></i> ';

    tbody.parentNode.insertBefore(countLabel, tbody.nextSibling);
    tbody.parentNode.insertBefore(totalLabel, countLabel.nextSibling);

    function updateFundsSummary() {
        if (!tbody || tbody.querySelectorAll('tr').length === 0) return;

        const rows = Array.from(tbody.querySelectorAll('tr')).filter(r => !r.classList.contains('no-items'));
        const totalRows = rows.length;
        let totalValue = 0;

        rows.forEach(row => {
            const valueCell = row.cells[2]; // عمود "القيمة"
            if (valueCell) {
                const cellText = valueCell.textContent.trim().replace(/,/g, '');
                const cellValue = parseFloat(cellText) || 0;
                totalValue += cellValue;
            }
        });

       

        countLabel.style.marginTop = "10px";
        countLabel.style.marginBottom = "10px";
        totalLabel.style.marginTop = "10px";
        totalLabel.style.marginBottom = "10px";
    }

    updateFundsSummary();

    const observer = new MutationObserver(() => {
        updateFundsSummary();
    });
    observer.observe(tbody, { childList: true, subtree: true });
});


//Remove Fund

function removeFund() {
  const id = document.getElementById("Date_Name-hidden").value;
  const exitDate = document.getElementById("exit-date").value;
  const notesInput = document.querySelector("input[name='notes']").value;

  if (id === "0" || !exitDate) {
    alert("يرجى اختيار البيان وتحديد تاريخ التخارج");
    return;
  }

  const formData = new FormData();
  formData.append("id", id);
  formData.append("due_date", exitDate);
  formData.append("notes", "تخارج بيان - " + notesInput);

  fetch("update_financial_exit.php", {
    method: "POST",
    body: formData
  })
  .then(res => res.json())
  .then(result => {
    if (result.success) {
      alert("✅ تم تحديث البيان بنجاح");
      // ممكن تخفي الفورم أو تعيد تحميل البيانات حسب ما تحب
    } else {
      alert("❌ فشل التحديث: " + result.message);
    }
  })
  .catch(err => {
    console.error("خطأ في الاتصال:", err);
    alert("❌ حدث خطأ أثناء الاتصال بالسيرفر");
  });
}



//delete

function deleteFund() {
    if (!editingFundId) {
        alert("⚠️ لا يوجد بيان رأس مال محدد للحذف");
        return;
    }

    if (!confirm("هل أنت متأكد أنك تريد حذف هذا البيان؟")) return;

    fetch("delete_fund.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "Accept": "application/json"
        },
        body: JSON.stringify({ id: editingFundId })
    })
    .then(res => res.json())
    .then(result => {
        alert(result.message);
        if (result.status === "success") {
            resetFundForm();
            document.getElementById("add-fund-section").style.display = "none";
            document.getElementById("contributors-section").style.display = "block";
            loadFundsTable();
        }
    })
    .catch(err => {
        console.error("❌ خطأ أثناء حذف البيان:", err);
        alert("❌ حدث خطأ أثناء عملية الحذف");
    });
}



//update

 editingFundId = null; // null يعني إضافة

async function saveFund() {
  const fundForm = document.getElementById("add-fund-form");
  if (!fundForm) return;

  const formDataObj = {};
  new FormData(fundForm).forEach((val, key) => formDataObj[key] = val);

  // التحقق من الحقول المطلوبة
  const required = ["contributor_name", "start_date", "contribution_value", "due_date"];
  for (const k of required) {
    if (!formDataObj[k]) {
      alert("⚠️ برجاء استكمال بيانات البيان.");
      return;
    }
  }

  // تحديد المسار: تعديل أو إضافة
  const url = editingFundId ? "update_fund.php" : "save_fund.php";

  // إضافة ID في حالة التعديل
  if (editingFundId) {
    formDataObj.id = editingFundId;
  }

  try {
    const res = await fetch(url, {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify(formDataObj)
    });

    const json = await res.json();
    alert(json.message || '');

    if (json.status === "success") {
      // إعادة ضبط النموذج والواجهة
      editingFundId = null;
      fundForm.reset();
      resetFundForm();
      document.getElementById("add-fund-section").style.display = "none";
      document.getElementById("contributors-section").style.display = "block";
      loadFundsTable();
    }

  } catch (err) {
    console.error("❌ خطأ أثناء حفظ البيان:", err);
    alert("❌ فشل الاتصال بالسيرفر أثناء حفظ البيان");
  }
}
