<?php
session_start();
if (!isset($_SESSION['username']) || !isset($_SESSION['usertype'])) {
    header("Location: Login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=1024, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <!-- ألوان شريط الحالة للـ Android -->
<meta name="theme-color" content="#ffffff">
<!-- للـ iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
  <title>MADAD HOLDING Management System</title>
  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
<link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">

   

</head>
<body>

  <!-- Header -->
 <!-- Header -->
<?php include 'header.php'; ?>



  <!-- Main Content -->
   <main class="main-content" id="main-content" role="main">
<section class="projects-container" aria-label="راس المال">
  <div class="section-header" style="display: flex; align-items: center; justify-content: space-between;">
    
    <!-- العنوان -->
    <h2 class="section-title" style="display: flex; align-items: center; gap: 8px; margin: 0;">
      <i class="fas fa-chart-line" aria-hidden="true"></i>
      راس المال
    </h2>

    <!-- الأيقونات -->
   <div style="display: flex; align-items: center; gap: 10px;">
   <div class="navS-icon" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;"
       aria-label="اضافه بيان" 
       onclick="toggleNewCustomSelect(); setActiveNavIconS(this)">
    <i class="fas fa-user-plus"></i>
    <span class="tooltip" role="tooltip">اضافه بيان</span>
  </div>

    <div class="navS-icon" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;"
       aria-label="تخاج بيان" 
       onclick="toggleRemoveF(); setActiveNavIconS(this)">
    <i class="fas fa-user-minus"></i>
    <span class="tooltip" role="tooltip">تخارج بيان</span>
  </div>



  <div class="navS-icon active" id="toggle-fund-btn" tabindex="0" role="button" 
       style="width: 50px; cursor: pointer;" 
       aria-label="البيانات" 
       onclick="FindtoggleNewCustomSelect(); setActiveNavIconS(this)">
    <i class="fas fa-user-friends"></i>
    <span class="tooltip" role="tooltip">البيانات</span>
  </div>
</div>
  </div>

</section>




<br>

<section id="add-fund-section" class="projects-container" aria-label="إضافة بيان" style="display: none;">

  <div style="display: flex; align-items: center; justify-content: space-between;">
    <!-- العنوان -->
    <h2 class="section-title" style="margin: 0; display: flex; align-items: center; gap: 8px;">
      <i class="fas fa-chart-line" aria-hidden="true"></i>
      اضافه بيان  
    </h2>

    <!-- الأزرار -->

     <div style="display: flex; gap: 10px;">
    <!-- زر الحذف -->
    <div class="navS-icon" id="deleteBtnFund" tabindex="0" role="button" 
         style="display:none; width: 50px; cursor: pointer;" aria-label="حذف"  onclick="deleteFund()">
      <i class="fas fa-trash-alt"></i>
      <span class="tooltip" role="tooltip">حذف</span>
    </div>
   <div class="navS-icon" id="BTNSaveFund" tabindex="0" role="button" stconst currentUserID = <?php echo $UID ? $UID : 'null'; ?>yle="width: 50px; cursor: pointer;" aria-label="حفظ">
  <i class="fas fa-save"></i>
  <span class="tooltip" role="tooltip">حفظ</span>
</div>
</div>
  </div>
  
  <form id="add-fund-form" style="margin-top: 15px; display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px;">

    <!-- البيان -->
    <div class="form-field">
      <i class="fas fa-user icon-secondary"></i>
      <input type="text" name="contributor_name" placeholder="البيان" required>
    </div>

    <!-- تاريخ البدء -->
    <div class="form-field">
      <i class="fas fa-calendar-alt icon-secondary"></i>
      <input type="date" name="start_date"  id="start_date" placeholder="تاريخ البدء" required>
    </div>

    <!-- قيمة البيان -->
    <div class="form-field">
      <i class="fas fa-dollar-sign icon-secondary"></i>
      <input type="number" name="contribution_value" placeholder="قيمة البيان" required>
    </div>

  
    <!-- تاريخ الاستحقاق -->
    <div class="form-field">
      <i class="fas fa-calendar-check icon-secondary"></i>
      <input type="date" name="due_date" placeholder="تاريخ الاستحقاق" required>
    </div>

    

    <!-- ملاحظات -->
    <div class="form-field" style="grid-column: span 3;">
      <i class="fas fa-sticky-note icon-secondary"></i>
      <input type="text" name="notes" placeholder="ملاحظات">
    </div>
    
  </form>


  <div id="fund-message" style="margin-top:10px; padding:10px; border-radius:5px; display:none;"></div>
</section>


<section id="remove-fund-section" class="projects-container" aria-label="تخارج بيان" style="display: none;">
  <div style="display: flex; align-items: center; justify-content: space-between;">
    <!-- العنوان -->
    <h2 class="section-title" style="margin: 0; display: flex; align-items: center; gap: 8px;">
      <i class="fas fa-chart-line" aria-hidden="true"></i>
      تخارج بيان
    </h2>

    <!-- الأزرار -->
    <div style="display: flex; gap: 10px;">
      <div class="nav-icon" tabindex="0" role="button" style="z-index: 9999;width: 50px; cursor: pointer;" aria-label="حفظ" onclick="removeFund()">
        <i class="fas fa-save"></i>
        <span class="tooltip" role="tooltip">حفظ</span>
      </div>
    </div>
  </div>
  
   <form id="remove-fund-form" style="margin-top: 15px; display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px;">
    <!-- اسم المساهم -->



<div class="form-field">
  <i class="fas fa-user icon-secondary"></i>
  <select id="Date_Name" required>
    <option value="All">اختر البيان</option>
  </select>
</div>

<input type="hidden" value="0" id="Date_Name-hidden" name="Date_Name" >


    <!-- تاريخ التخارج -->
<div class="form-field" style="position: relative;">
  <i class="fas fa-calendar-alt icon-secondary"></i>
  <input type="date" name="exit_date" id="exit-date" required>
  <span class="tooltip-text">تاريخ التخارج</span>
</div>


    <!-- ملاحظات -->
    <div class="form-field" style="grid-column: span 3;">
      <i class="fas fa-sticky-note icon-secondary"></i>
      <input type="text" name="notes" placeholder="ملاحظات">
    </div>


   

  </form>
   <div id="messageBox" style="margin-top: 10px; color: green; font-weight: bold;"></div>
</section>


<section id="contributors-section" class="projects-container" aria-label="قائمة البيانات">
  <!-- العنوان -->
  <h2 class="section-title" style="display: flex; align-items: center; gap: 8px;">
    <i class="fas fa-users" aria-hidden="true"></i>
    البيانات
  
  </h2>

  <!-- جدول البيانات -->
  <div   style="display: flex; align-items: center; justify-content: space-between; width: 100%; margin-bottom: 10px;">
   
  <table class="items-table">
    <thead>
      <tr>
        <th><i class="fas fa-user icon-secondary"></i>  البيانات</th>
        <th><i class="fas fa-calendar-alt icon-secondary"></i> تاريخ البدء</th>
        <th><i class="fas fa-dollar-sign icon-secondary"></i> قيمة البيان</th>
        <th><i class="fas fa-percentage icon-secondary"></i> نسبة البيان</th>
        <th><i class="fas fa-calendar-check icon-secondary"></i> تاريخ الاستحقاق</th>
        <th><i class="fas fa-coins icon-secondary"></i> الربح</th>
        <th><i class="fas fa-sticky-note icon-secondary"></i> ملاحظات</th>
      </tr>
    </thead>
    <tbody id="contributors-table-body">
      <tr>
        <td colspan="7" class="no-items">لا توجد بيانات مضافة بعد</td>
      </tr>
    </tbody>
  </table>

</section>


  </main>




  <!-- Scroll Top Button -->
  <button id="scrollTopBtn" class="fas fa-arrow-up"
          onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>

  <!-- Footer -->
<?php include 'footer.php'; ?>
  

 <script>
const today1 = new Date().toISOString().split('T')[0];
document.getElementById('exit-date').value = today1;
document.getElementById('start_date').value = today1;

const today = new Date();
today.setFullYear(today.getFullYear() + 1); // نضيف سنة واحدة
const nextYear = today.toISOString().split('T')[0];

// تأكد أن العناصر موجودة قبل التعيين
const dueDateInput = document.getElementById('due_date');
if (dueDateInput) dueDateInput.value = nextYear;

const startDateInput = document.getElementById('start_date');
if (startDateInput) startDateInput.value = nextYear;

</script>





  <!-- Scripts -->
  <script>
    document.getElementById('currentYear').textContent = new Date().getFullYear();
  </script>

  <script>
// منع تحديد النصوص
document.addEventListener('selectstart', function (e) {
    e.preventDefault();
}, false);

// منع الكليك يمين
document.addEventListener('contextmenu', function (e) {
    e.preventDefault();
}, false);

// منع السحب
document.addEventListener('dragstart', function (e) {
    e.preventDefault();
}, false);

// منع الحفظ وأوامر المطور
window.addEventListener('keydown', function (e) {
    // اختصارات Ctrl + (S, U, P, C, X, A)
    if (e.ctrlKey && ['s', 'u', 'p', 'c', 'x', 'a'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ هذا الاختصار معطل على هذا الموقع");
    }
    // منع F12
    if (e.key === 'F12') {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
    // منع Ctrl+Shift+I و Ctrl+Shift+J
    if (e.ctrlKey && e.shiftKey && ['i', 'j'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
}, true); // capture mode
</script>



<script>
  let pageIdentifier = "fund";
</script>
  <script src="script.js"></script>

  
 <script src="fundAjax.js"></script>










</body>
</html>