// تحميل المشاريع من قاعدة البيانات
fetch('get_projects.php')
  .then(async res => {
    const text = await res.text();

    try {
      const data = JSON.parse(text);

      // لو السيرفر رجّع خطأ داخل JSON
      if (data.error) {
        throw new Error(data.error);
      }

      const select = document.getElementById('selected-project');
      select.innerHTML = '<option value="All" >  المشاريع </option>';

      data.forEach(project => {
        const option = document.createElement('option');
        option.value = project.id;
        option.textContent = project.name;
        select.appendChild(option);
      });
    } catch (err) {
      console.error("❌ فشل تحويل البيانات إلى JSON:", err.message);
      console.log("🔍 الرد من السيرفر كان:", text);
    }
  })
  .catch(error => {
    console.error("❌ فشل تحميل المشاريع:", error.message);
  });

// التعامل مع اختيار مشروع
handleProjectChange = (selectElement) => {
  const selectedId = selectElement.value;
  const selectedName = selectElement.options[selectElement.selectedIndex].text;

  // ✅ تحويل "All" إلى 0
  const PID = selectedId === "All" ? 0 : parseInt(selectedId);

  // ✅ تحديث النصوص والحقول
  document.getElementById('selected-project-text').textContent = selectedName;
  document.getElementById('selected-project-id').textContent = PID;
  document.getElementById('project-id-hidden').value = PID;

  console.log("✅ تم اختيار المشروع:", PID, selectedName);
  console.log("📌 القيمة النهائية في hidden input:", document.getElementById('project-id-hidden').value);

  // تحميل الإيرادات حسب المشروع

loadExpenses();
}


//add


//find


function openAttachment(attachmentUrl) {
  if (!attachmentUrl) return;

  attachmentUrl = attachmentUrl.trim();

  // لو الرابط نسبي، ضيفه على أصل الموقع الحالي
  if (!attachmentUrl.startsWith("http") && !attachmentUrl.startsWith("/")) {
    const baseUrl = window.location.origin + "/MMM/";
    attachmentUrl = baseUrl + attachmentUrl;
  }

  console.log("📎 فتح المرفق:", attachmentUrl);
  window.open(attachmentUrl, '_blank');
}


let editingExpenseId = null; // وضع تعديل أو إضافة

// إخفاء زر الحذف في البداية
const deleteBtnExpense = document.getElementById("BTNDeleteExpense");
if (deleteBtnExpense) deleteBtnExpense.style.display = "none";

// 🔹 تحميل جدول المصروفات
setInterval(loadExpenses, 5000);
function loadExpenses() {
    const PID = parseInt(document.getElementById("selected-project").value) || 0;
    const tableBody = document.getElementById("expenses-table-body");
    if (!tableBody) return;

    fetch("get_expenses.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "Accept": "application/json"
        },
        body: JSON.stringify({ PID })
    })
    .then(res => res.json())
    .then(result => {
        if (result.status !== "success") {
            tableBody.innerHTML = `<tr><td colspan="13">❌ ${result.message}</td></tr>`;
            return;
        }

        const data = result.data;
        if (!Array.isArray(data) || data.length === 0) {
            tableBody.innerHTML = `<tr><td colspan="13">لا توجد مصروفات لهذا المشروع</td></tr>`;
            return;
        }

        tableBody.innerHTML = "";
        data.forEach(item => {
            const safeAttachment = encodeURIComponent(item.AttachmentPath || "");
            const row = document.createElement("tr");

            row.innerHTML = `
                <td>${item.project_name || ""}</td>
                <td>${item.invoice_number || ""}</td>
                <td>${item.date || ""}</td>
                <td>${item.item_price || ""}</td>
                <td>${item.unit || ""}</td>
                <td>${item.quantity || ""}</td>
                <td>${item.total_price || ""}</td>
                <td>${item.supplier || ""}</td>
                <td>${item.payment_method || ""}</td>
                <td>${item.employee_name || "غير محدد"}</td>
                <td>
                    ${item.AttachmentPath ? `
                        <div class="navS-icon" style="width: 50px; cursor: pointer;"
                             aria-label="المرفق PDF"
                             onclick="openAttachment(decodeURIComponent('${safeAttachment.replace(/^,/, '')}'))">
                            <i class="fas fa-file-pdf"></i>
                            <span class="tooltip">المرفق PDF</span>
                        </div>
                    ` : `<span class="no-attachment">—</span>`}
                </td>
                <td>${item.notes || ""}</td>
            `;

            // 📌 عند الضغط على الصف → إدخال البيانات في الفورم وتفعيل وضع التعديل
            row.addEventListener("click", () => {
                document.getElementById("add-expense-section").style.display = "block";
                document.getElementById("expenses-section").style.display = "none";
                if (deleteBtnExpense) deleteBtnExpense.style.display = "block";
                fillExpenseForm(item);
            });

            tableBody.appendChild(row);
        });
    })
    .catch(error => {
        console.error("❌ خطأ في تحميل المصروفات:", error);
        tableBody.innerHTML = `<tr><td colspan="13">❌ حدث خطأ أثناء تحميل البيانات</td></tr>`;
    });
}


// 🔹 تعبئة الفورم بالقيم
function fillExpenseForm(item) {
    const form = document.getElementById("add-expense-form");
    if (!form) return;

    // تعبئة بيانات المصروف في الفورم
    const setVal = (selector, val) => {
        const el = form.querySelector(selector);
        if (el) el.value = val || "";
    };

    setVal('[name="item"]', item.invoice_number);
    setVal('[name="item_price"]', item.item_price);
    setVal('[name="dateAddRe"]', item.date);
    setVal('[name="unit"]', item.unit);
    setVal('[name="quantity"]', item.quantity);
    setVal('[name="total_price"]', item.total_price);
    setVal('[name="contractor"]', item.supplier);
    setVal('[name="deduct_reason"]', item.payment_method);

    const empSelect = document.getElementById("employee-select");
    if (empSelect) empSelect.value = item.employee_name || "";

    setVal('[name="notes"]', item.notes);

    const attachPath = document.getElementById("AttachmentPath");
    if (attachPath) attachPath.value = item.AttachmentPath || "";

    editingExpenseId = item.id;

    // تغيير العنوان
    document.querySelector("#add-expense-section h2").innerHTML =
        `<i class="fas fa-receipt"></i> تعديل مصروف`;

    // تغيير aria-label للسيكشن
    const section = document.getElementById("add-expense-section");
    if (section) section.setAttribute("aria-label", "تعديل");

    // تغيير الزرار
    const saveBtn = document.getElementById("BTNSaveEdit");
    if (saveBtn) {
        const icon = saveBtn.querySelector("i");
        const tooltip = saveBtn.querySelector(".tooltip");

        saveBtn.setAttribute("aria-label", "تعديل");
        if (icon) icon.className = "fas fa-edit";
        if (tooltip) tooltip.textContent = "تعديل";
    }

    // إعادة تطبيق الصلاحيات بعد التغيير
    applyPermissions();
}

function resetExpenseForm() {
    const form = document.getElementById("add-expense-form");
    if (form) form.reset();

    editingExpenseId = null;

    // إعادة العنوان
    document.querySelector("#add-expense-section h2").innerHTML =
        `<i class="fas fa-receipt"></i> إضافة مصروف`;

    // إعادة aria-label للسيكشن
    const section = document.getElementById("add-expense-section");
    if (section) section.setAttribute("aria-label", "إضافة مصروف");

    // إعادة الزرار
    const saveBtn = document.getElementById("BTNSaveEdit");
    if (saveBtn) {
        const icon = saveBtn.querySelector("i");
        const tooltip = saveBtn.querySelector(".tooltip");

        saveBtn.setAttribute("aria-label", "إضافة مصروف");
        if (icon) icon.className = "fas fa-save";
        if (tooltip) tooltip.textContent = "حفظ";
    }

    // إخفاء زر الحذف
    const deleteBtn = document.getElementById("BTNDeleteExpense");
    if (deleteBtn) deleteBtn.style.display = "none";

    // إعادة تطبيق الصلاحيات بعد الرجوع
    applyPermissions();
}


// 🔹 تشغيل التحديث التلقائي
function startExpensesAutoRefresh() {
    let intervalId = null;

    function checkVisibilityAndUpdate() {
        const section = document.getElementById("expenses-section");
        if (section && section.offsetParent !== null) {
            if (!intervalId) {
                loadExpenses();
                intervalId = setInterval(loadExpenses, 5000);
                console.log("✅ بدأ التحديث التلقائي للمصروفات");
            }
        } else {
            if (intervalId) {
                clearInterval(intervalId);
                intervalId = null;
                console.log("⏸️ توقف التحديث لأن القسم مخفي");
            }
        }
    }

    setInterval(checkVisibilityAndUpdate, 3000);
}


// ✅ تشغيل التحديث التلقائي عند ظهور القسم
function startExpensesAutoRefresh() {
    let intervalId = null;

    function checkVisibilityAndUpdate() {
        const section = document.getElementById("expenses-section");
        if (section && section.offsetParent !== null) {
            if (!intervalId) {
                loadExpenses();
                intervalId = setInterval(loadExpenses, 5000);
                console.log("✅ بدأ التحديث التلقائي للمصروفات");
            }
        } else {
            if (intervalId) {
                clearInterval(intervalId);
                intervalId = null;
                console.log("⏸️ توقف التحديث لأن القسم مخفي");
            }
        }
    }

    setInterval(checkVisibilityAndUpdate, 5000);
}


document.addEventListener("DOMContentLoaded", function () {
  loadExpenses();
});


function handleAddRevenueClick(element) {
    const selectedPID = document.getElementById("project-id-hidden").value;

    if (parseInt(selectedPID) === 0) {
        alert("❌ من فضلك اختر مشروع أولًا قبل إضافة الإيراد");
        return;
    }

    // لو المشروع مختار فعلاً، نفذ باقي الأكشنات
    toggleExpenseForm();
    setActiveNavIconS(element);

 
}





//sum

document.addEventListener('DOMContentLoaded', () => {
    const tbody = document.getElementById('expenses-table-body');
    if (!tbody) return;

    // عنصر واحد يحتوي العدد والمجموع
    const summaryContainer = document.createElement('div');
    summaryContainer.id = 'expenses-summary';
    summaryContainer.style.fontWeight = 'bold';
    summaryContainer.style.marginTop = '10px';
    summaryContainer.style.marginBottom = '10px';

    // نضيفه بعد الجدول مباشرة
    tbody.parentNode.insertBefore(summaryContainer, tbody.nextSibling);

    function updateExpensesSummary() {
        if (!tbody || tbody.querySelectorAll('tr').length === 0) return;

        const rows = Array.from(tbody.querySelectorAll('tr')).filter(r => !r.classList.contains('no-items'));
        const totalRows = rows.length;
        let totalValue = 0;

        rows.forEach(row => {
            const valueCell = row.cells[6]; // عمود "السعر الإجمالي"
            if (valueCell) {
                const cellText = valueCell.textContent.trim().replace(/,/g, '');
                const cellValue = parseFloat(cellText) || 0;
                totalValue += cellValue;
            }
        });

      

     summaryContainer.innerHTML = `
    <div style="white-space: nowrap;">
        <span><i class="fas fa-hashtag dropdown-arrow icon-secondary"></i> العدد: ${totalRows}</span>
    </div>
    <div style="white-space: nowrap;">
        <span><i class="fas fa-calculator dropdown-arrow icon-secondary"></i> المجموع: ${totalValue.toFixed(2)} ريال</span>
    </div>
`;


    }

    updateExpensesSummary();

    const observer = new MutationObserver(() => {
        updateExpensesSummary();
    });
    observer.observe(tbody, { childList: true, subtree: true });
});



//الموظف

function toggleEmpName() {
  const paymentMethod = document.getElementById("deduct_reason").value;
  const empField = document.getElementById("EmpName");

  if (paymentMethod === "عهده") {
    empField.style.display = "block";
  } else {
    empField.style.display = "none";
  }
}





  //get emp


  window.addEventListener('DOMContentLoaded', () => {
  // تحميل الموظفين من قاعدة البيانات
  fetch('get_employees.php')
    .then(async res => {
      const text = await res.text();

      try {
        const data = JSON.parse(text);

        if (data.error) {
          throw new Error(data.error);
        }

        const select = document.getElementById('employee-select');
        if (!select) throw new Error("عنصر select الخاص بالموظفين غير موجود");

        select.innerHTML = '<option value="" disabled selected>اختر الموظف</option>';

        data.forEach(emp => {
          const option = document.createElement('option');
          option.value = emp.id;
          option.textContent = emp.name;
          select.appendChild(option);
        });
      } catch (err) {
        console.error("❌ فشل تحويل بيانات الموظفين إلى JSON:", err.message);
        console.log("🔍 الرد من السيرفر كان:", text);
      }
    })
    .catch(error => {
      console.error("❌ فشل تحميل الموظفين:", error.message);
    });
});





handleEmployeeChange = (selectElement) => {
  const selectedId = selectElement.value;
  const selectedName = selectElement.options[selectElement.selectedIndex].text;

  const EID = selectedId === "" ? 0 : parseInt(selectedId);

  // تحديث العناصر المخفية
  document.getElementById('selected-employee-text').textContent = selectedName;
  document.getElementById('selected-employee-id').textContent = EID;
  document.getElementById('employee-id-hidden').value = EID;

  console.log("✅ تم اختيار الموظف:", EID, selectedName);
  console.log("📌 القيمة النهائية في hidden input:", document.getElementById('employee-id-hidden').value);
}







//PDF
document.addEventListener("DOMContentLoaded", () => {
  const selectPdfBtn = document.getElementById("selectPdfBtn");
  const fileInput = document.getElementById("pdfFileInput");
  const attachmentField = document.getElementById("AttachmentPath");
  const msg = document.getElementById("projectMsg");

  // عند الضغط على زر اختيار الملف
  selectPdfBtn.addEventListener("click", () => {
    fileInput.click();
  });

  // عند اختيار ملف PDF
  fileInput.addEventListener("change", () => {
    const file = fileInput.files[0];
    if (!file) return;

    const formData = new FormData();
    formData.append("pdfFile", file);

    fetch("upload_pdf.php", {
      method: "POST",
      body: formData
    })
    .then(res => res.json())
    .then(data => {
      if (data.status === "success") {
        const fullPath = data.path; // مثال: DocumentPDF/contract123.pdf
        attachmentField.value = fullPath;

        msg.textContent = `✅ تم رفع الملف: ${file.name}`;
        msg.style.color = "green";
        msg.style.display = "block";

        setTimeout(() => {
          msg.style.display = "none";
        }, 5000);
      } else {
        msg.textContent = `❌ فشل رفع الملف: ${data.message}`;
        msg.style.color = "red";
        msg.style.display = "block";
      }
    })
    .catch(err => {
      console.error("❌ خطأ في رفع الملف:", err);
      alert("");
    });
  });
});



function openPdfFromInput() {
  const input = document.getElementById("AttachmentPath_fullDe");
  const fileName = input.value.trim();

  if (!fileName) {
    alert("⚠️ لازم تدخل اسم الملف");
    return;
  }

  const currentPath = window.location.pathname;
  const folderPath = currentPath.substring(0, currentPath.lastIndexOf("/"));
  const fullURL = `${window.location.origin}${folderPath}/${fileName}`;

  console.log("📂 الرابط النهائي:", fullURL);
  window.open(fullURL, "_blank");
}



//update

// متغيّر عام يخزن ID العنصر الجاري تعديله؛ null يعني إضافة
 editingExpenseId = null;

async function saveExpense() {
  const form = document.getElementById("add-expense-form");
  if (!form) return;

  // 1) مسار التعديل (إذا كانت قيمة editingExpenseId موجودة)
  if (editingExpenseId) {
    // تجميع حقول التعديل تماماً كما في دالتك الأولى
    const data = {
      id: editingExpenseId,  
      invoice_number: form.querySelector('[name="item"]').value.trim(),
      item_price:     form.querySelector('[name="item_price"]').value.trim(),
      date:           form.querySelector('[name="dateAddRe"]').value.trim(),
      unit:           form.querySelector('[name="unit"]').value.trim(),
      quantity:       form.querySelector('[name="quantity"]').value.trim(),
      total_price:    form.querySelector('[name="total_price"]').value.trim(),
      supplier:       form.querySelector('[name="contractor"]').value.trim(),
      payment_method: form.querySelector('[name="deduct_reason"]').value.trim(),
      employee_name:  document.getElementById("employee-select")?.value || "",
      notes:          form.querySelector('[name="notes"]').value.trim(),
      AttachmentPath: document.getElementById("AttachmentPath").value.trim()
    };

    try {
      const res = await fetch("update_expense.php", {
        method:  "POST",
        headers: {
          "Content-Type": "application/json",
          "Accept":       "application/json"
        },
        body: JSON.stringify(data)
      });
      const json = await res.json();
      alert(json.message);
      if (json.status === "success") {
        // إعادة ضبط الواجهة بعد التعديل
        editingExpenseId = null;
        form.reset();
        document.getElementById("add-expense-section").style.display = "none";
        document.getElementById("expenses-section").style.display    = "block";
        loadExpenses();
        resetExpenseForm();
      }
    } catch (err) {
      console.error("❌ خطأ في التعديل:", err);
      alert("⚠️ فشل الاتصال بالسيرفر أثناء التعديل");
    }

    return;
  }

  // 2) مسار الإضافة (editingExpenseId === null)
  // تجميع البيانات من الفورم عبر FormData
  const formData = new FormData(form);
  const data = {};
  formData.forEach((value, key) => {
    data[key] = value;
  });

  // التحقق من العُهدة قبل الإضافة
  if (data.payment_method === "عهده") {
    const projectId        = parseInt(data.project_id, 10);
    const empId            = parseInt(data.EmpID, 10);
    const newExpenseAmount = parseFloat(data.total_price);

    const check = await checkCustodyBeforeExpense(
      projectId, empId, newExpenseAmount
    );
    if (!check.allowed) {
      return alert("❌ لا يمكن إضافة المصروف: " + check.message);
    }
  }

  // إرسال طلب الإضافة
  try {
    const res = await fetch("add_expense.php", {
      method:  "POST",
      headers: { "Content-Type": "application/json" },
      body:    JSON.stringify(data)
    });

    const text = await res.text();
    let json;
    try {
      json = JSON.parse(text);
    } catch {
      alert("❌ الرد من السيرفر ليس بصيغة JSON:\n" + text);
      console.error("رد غير صالح:", text);
      return;
    }

    alert(json.message);
    if (json.status === "success") {
      // إعادة ضبط الواجهة بعد الإضافة
      form.reset();
      document.getElementById("selected-project-text").textContent = "---";
      document.getElementById("selected-project-id").textContent   = "---";
      document.getElementById("project-id-hidden").value         = "0";
    }

  } catch (err) {
    console.error("❌ خطأ في الاتصال أثناء الإضافة:", err);
    alert("⚠️ فشل الاتصال بالسيرفر أثناء الإضافة");
  }
}



//Delete

function deleteExpense() {
    if (!editingExpenseId) {
        alert("⚠️ لا يوجد مصروف محدد للحذف");
        return;
    }

    if (!confirm("هل أنت متأكد أنك تريد حذف هذا المصروف؟")) return;

    fetch("delete_expense.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
            "Accept": "application/json"
        },
        body: JSON.stringify({ id: editingExpenseId })
    })
    .then(res => res.json())
    .then(result => {
        alert(result.message);
        if (result.status === "success") {
            resetExpenseForm();
            document.getElementById("add-expense-section").style.display = "none";
            document.getElementById("expenses-section").style.display = "block";
            loadExpenses();
        }
    })
    .catch(err => {
        console.error("❌ خطأ أثناء حذف المصروف:", err);
        alert("❌ حدث خطأ أثناء عملية الحذف");
    });
}



//Get Tatal


document.addEventListener('DOMContentLoaded', () => {
  const priceInput = document.querySelector('input[name="item_price"]');
  const quantityInput = document.querySelector('input[name="quantity"]');
  const totalInput = document.querySelector('input[name="total_price"]');

  function calculateTotal() {
    const price = parseFloat(priceInput.value);
    const quantity = parseFloat(quantityInput.value);

    // شرط التحقق من وجود قيم صحيحة
    if (!isNaN(price) && !isNaN(quantity)) {
      const total = price * quantity;
      totalInput.value = total.toFixed(2); // نعرضه برقمين بعد الفاصلة
    }
  }

  // نربط الحدثين
  priceInput.addEventListener('input', calculateTotal);
  quantityInput.addEventListener('input', calculateTotal);
});

