<?php
session_start();
if (!isset($_SESSION['username']) || !isset($_SESSION['usertype'])) {
    header("Location: Login.php");
    exit();
}
?>


<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=1024, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <!-- ألوان شريط الحالة للـ Android -->
<meta name="theme-color" content="#ffffff">
<!-- للـ iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
<title>MADAD HOLDING Management System</title>
  
  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
 <link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">
  <!-- Chart.js with 3D plugin -->

</head>
<body>

 <!-- Header -->
<?php include 'header.php'; ?>

  <!-- Main Content -->
 <main class="main-content" role="main">
  <section class="projects-container" aria-label="المصروفات">
  <div class="section-header" style="display: flex; align-items: center; justify-content: space-between;">

    <!-- العنوان مع اختيار المشروع -->
    <div style="display: flex; align-items: center; gap: 15px;">
      <h2 class="section-title" style="display: flex; align-items: center; gap: 8px; margin: 0;">
        <i class="fas fa-receipt" aria-hidden="true"></i>
        المصروفات
      </h2>

      <!-- اختيار المشروع -->
  <div class="form-field">
        <i class="fas fa-building icon-secondary"></i>
       
          <select id="selected-project" onchange="handleProjectChange(this)" required>

          <option value="All" >  المشاريع </option>
        </select>
      </div>
    </div>


    <!-- الأيقونات -->
    <div style="display: flex; align-items: center; gap: 10px;">
      
      <!-- إضافة مصروف -->
      <div class="navS-icon" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="إضافة مصروف" 
           
           onclick="handleAddRevenueClick(this)">

           
        <i class="fas fa-plus-circle"></i>
        <span class="tooltip" role="tooltip">إضافة مصروف</span>
      </div>

      <!-- عرض المصروفات -->
      <div class="navS-icon active" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="عرض المصروفات" 
           onclick="showExpenseList(); setActiveNavIconS(this)">
        <i class="fas fa-list"></i>
        <span class="tooltip" role="tooltip">المصروفات</span>
      </div>

    </div>
  </div>
</section>


<br>



<!-- ✅ قسم إضافة مصروف -->
<section id="add-expense-section" class="projects-container" aria-label="إضافة مصروف" style="display: none;">

  <div style="display: flex; align-items: center; justify-content: space-between;">
    <!-- العنوان -->
    <h2 class="section-title" style="margin: 0; display: flex; align-items: center; gap: 8px;">
      <i class="fas fa-receipt" aria-hidden="true"></i>
      إضافة مصروف
    </h2>

   <div style="display: flex; gap: 10px;">
    <!-- زر الحذف -->
    <div class="navS-icon" id="BTNDeleteExpense" tabindex="0" role="button" 
         style="display:none; width: 50px; cursor: pointer;" aria-label="حذف" onclick="deleteExpense()">
      <i class="fas fa-trash-alt"></i>
      <span class="tooltip" role="tooltip">حذف</span>
    </div>
      <div class="navS-icon" tabindex="0" id="BTNSaveEdit" role="button" style="width: 50px; cursor: pointer;" aria-label="حفظ" onclick="saveExpense()">
        <i class="fas fa-save"></i>
        <span class="tooltip" role="tooltip">حفظ</span>
      </div>

        <div class="navS-icon" id="selectPdfBtn" tabindex="0" role="button" style="width: 50px; cursor: pointer;" aria-label="العقد PDF">
  <i class="fas fa-file-pdf"></i>
  <span class="tooltip" role="tooltip"> PDF</span>
</div>
</div>
<!-- عنصر اختيار الملف المخفي -->
<input type="file" id="pdfFileInput" accept=".pdf" style="display: none;">
    </div>
  </div>
  
  <form id="add-expense-form" style="margin-top: 15px; display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px;">


   <p hidden>اسم المشروع: <span id="selected-project-text">---</span></p>
<p hidden>رقم المشروع (ID): <span id="selected-project-id">---</span></p>

<!-- تجربة عرض الـ ID في input -->
<input type="hidden" value="0" id="project-id-hidden" name="project_id">


  <p hidden>اسم المشروع: <span id="selected-employee-text">---</span></p>
<p hidden>رقم المشروع (ID): <span id="selected-employee-id">---</span></p>

<!-- تجربة عرض الـ ID في input -->
<input type="hidden" value="0" id="employee-id-hidden" name="employee-id">



    <!-- ✅ خانة المشروع (مخفية في الأول) -->
    <div class="form-field" id="project-name-field" style="display:none;">
      <i class="fas fa-building icon-secondary"></i>
      <input type="text" name="projectName" id="projectNameInput" placeholder="المشروع" readonly>
    </div>

    <!-- رقم الفاتورة -->
    <div class="form-field">
      <i class="fas fa-list icon-secondary"></i>
      <input type="text" name="item" placeholder="رقم الفاتوره" required>
    </div>

    <!-- التاريخ -->
    <div class="form-field">
      <i class="fas fa-calendar-alt icon-secondary"></i>
      <input type="date" name="dateAddRe" id="dateAddRe" placeholder="التاريخ" required>
    </div>

    <!-- سعر الصنف -->
    <div class="form-field">
      <i class="fas fa-tag icon-secondary"></i>
      <input type="number" name="item_price" placeholder="سعر الصنف" required>
    </div>

    <!-- وحدة القياس -->
    <div class="form-field">
      <i class="fas fa-ruler icon-secondary"></i>
     <select name="unit" required>
  <option value="" disabled selected>اختر وحدة القياس</option>
  <option value="طن">طن</option>
  <option value="كجم">كجم</option>
  <option value="جم">جم</option>
  <option value="متر">متر</option>
  <option value="سم">سم</option>
  <option value="متر مربع">م² (متر مربع)</option>
  <option value="متر مكعب">م³ (متر مكعب)</option>
  <option value="قطعة">قطعة</option>
  <option value="دستة">دستة</option>
  <option value="كيس">كيس</option>
  <option value="علبة">علبة</option>
  <option value="كرتونة">كرتونة</option>
  <option value="باكت">باكت</option>
  <option value="رول">رول</option>
  <option value="زجاجة">زجاجة</option>
  <option value="عبوة">عبوة</option>
  <option value="أنبوب">أنبوب</option>
  <option value="برميل">برميل</option>
  <option value="جالون">جالون</option>
  <option value="لتر">لتر</option>
  <option value="مل">مل</option>
  <option value="وحدة">وحدة</option>
  <option value="جهاز">جهاز</option>
  <option value="بطارية">بطارية</option>
  <option value="لمبة">لمبة</option>
  <option value="طوبة">طوبة</option>
  <option value="شكاير">شكاير</option>
  <option value="أخرى">أخرى</option>
</select>

    </div>

    <!-- الكمية -->
    <div class="form-field">
      <i class="fas fa-cubes icon-secondary"></i>
      <input type="number" name="quantity" placeholder="الكمية" required>
    </div>

    <!-- السعر الإجمالي -->
    <div class="form-field">
      <i class="fas fa-dollar-sign icon-secondary"></i>
      <input type="number" name="total_price" placeholder="السعر الإجمالي" required>
    </div>

    <!-- المورد -->
    <div class="form-field">
      <i class="fas fa-user-tie icon-secondary"></i>
      <input type="text" name="contractor" placeholder="المورد" required>
    </div>

    <!-- طريقة الدفع -->
    <div class="form-field">
      <i class="fas fa-credit-card icon-secondary"></i>
      <select name="deduct_reason" id="deduct_reason" required onchange="toggleEmpName()">
        <option value="" disabled selected>اختر طريقة الدفع</option>
        <option value="حساب بنكي">حساب بنكي</option>
        <option value="كاش">كاش</option>
        <option value="عهده">عهده</option>
     
      </select>
    </div>

    <!-- الموظف (يظهر لو عهده) -->
   


    <div class="form-field"   id="EmpName" style="display: none;">
        <i class="fas fa-user icon-secondary"></i>
          <select id="employee-select"  required onchange="handleEmployeeChange(this)">
          <option value="All" >  الموظفين </option>
        </select>
      </div>
    </div>


 
 <input type="hidden" value="" id="AttachmentPath" name="AttachmentPath">



    <!-- ملاحظات -->
    <div class="form-field" style="grid-column: span 3;">
      <i class="fas fa-sticky-note icon-secondary"></i>
      <input type="text" name="notes" placeholder="ملاحظات">
    </div>

  </form>
</section>





<section id="expenses-section" class="projects-container" aria-label="قائمة المصروفات">

  <!-- العنوان -->
  <h2 class="section-title" style="display: flex; align-items: center; gap: 8px;">
    <i class="fas fa-receipt" aria-hidden="true"></i>
    المصروفات
  </h2>

  <!-- جدول البيانات -->
  <div style="display: flex; align-items: center; justify-content: space-between; width: 100%; margin-bottom: 10px;">
   
    <table class="items-table">
      <thead>
        <tr>
          <th><i class="fas fa-building icon-secondary"></i>  المشروع   </th>
          <th><i class="fas fa-list icon-secondary"></i> رقم الفاتورة</th>
          <th><i class="fas fa-calendar-alt icon-secondary"></i> التاريخ</th>
          <th><i class="fas fa-tag icon-secondary"></i> سعر الصنف</th>
          <th><i class="fas fa-ruler icon-secondary"></i> وحدة القياس</th>
          <th><i class="fas fa-cubes icon-secondary"></i> الكمية</th>
          <th><i class="fas fa-dollar-sign icon-secondary"></i> السعر الإجمالي</th>
          <th><i class="fas fa-user-tie icon-secondary"></i> المورد</th>
          <th><i class="fas fa-credit-card icon-secondary"></i> طريقة الدفع</th>
            <th><i class="fas fa-user icon-secondary"></i> الموظف</th>
            <th><i class="fas fa-file-pdf icon-secondary"></i> المستند</th>
          <th><i class="fas fa-sticky-note icon-secondary"></i> ملاحظات</th>
        </tr>
      </thead>
      <tbody id="expenses-table-body">
        <tr>
          <td colspan="12" class="no-items">لا توجد مصروفات مضافة بعد</td>
        </tr>
      </tbody>
    </table>

  </div>
</section>



<div id="messageBox" style="display: none; padding: 10px; margin: 10px 0; border-radius: 5px; font-weight: bold;"></div>

</main>


  <!-- Scroll Top Button -->
  <button id="scrollTopBtn" class="fas fa-arrow-up"
          onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>

  <!-- Footer -->
<?php include 'footer.php'; ?>



<script>
const today = new Date().toISOString().split('T')[0];
document.getElementById('dateAddRe').value = today;
</script>




  <!-- Scripts -->
  <script>
    document.getElementById('currentYear').textContent = new Date().getFullYear();
  </script>

  <script>
// منع تحديد النصوص
document.addEventListener('selectstart', function (e) {
    e.preventDefault();
}, false);

// منع الكليك يمين
document.addEventListener('contextmenu', function (e) {
    e.preventDefault();
}, false);

// منع السحب
document.addEventListener('dragstart', function (e) {
    e.preventDefault();
}, false);

// منع الحفظ وأوامر المطور
window.addEventListener('keydown', function (e) {
    // اختصارات Ctrl + (S, U, P, C, X, A)
    if (e.ctrlKey && ['s', 'u', 'p', 'c', 'x', 'a'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ هذا الاختصار معطل على هذا الموقع");
    }
    // منع F12
    if (e.key === 'F12') {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
    // منع Ctrl+Shift+I و Ctrl+Shift+J
    if (e.ctrlKey && e.shiftKey && ['i', 'j'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
}, true); // capture mode
</script>




  <script>
  let pageIdentifier = "expenses";
</script>
  <script src="script.js"></script>
  <script src="expensesAjax.js"></script>
</body>
</html>