<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "db.php";

// استلام البيانات بصيغة JSON
$data = json_decode(file_get_contents("php://input"), true);

// استخراج الـ ID وتأكيد أنه رقم صحيح
$id = intval($data['id'] ?? 0);

if ($id === 0) {
    echo json_encode(["status" => "error", "message" => "⚠️ رقم المستخدم غير صالح"]);
    exit;
}

// تنفيذ الحذف
$sql = "DELETE FROM USEUSERSMH WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "🗑️ تم حذف المستخدم بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ فشل في الحذف: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
