<?php
header("Content-Type: application/json; charset=UTF-8");
ini_set('display_errors', 1);
error_reporting(E_ALL);
require_once "db.php";

// ✅ استقبال البيانات بصيغة JSON
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

// ✅ التحقق من وجود ID للحذف
$id = isset($data['id']) ? intval($data['id']) : 0;
if ($id <= 0) {
    echo json_encode([
        "status" => "error",
        "message" => "❌ رقم المعاملة غير صالح"
    ]);
    exit;
}

// ✅ تنفيذ الحذف
$sql = "DELETE FROM `TransactionsMH` WHERE `id` = ?";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode([
        "status" => "error",
        "message" => "❌ فشل تجهيز الاستعلام"
    ]);
    exit;
}

$stmt->bind_param("i", $id);
$success = $stmt->execute();

if ($success && $stmt->affected_rows > 0) {
    echo json_encode([
        "status" => "success",
        "message" => "✅ تم حذف المعاملة بنجاح"
    ], JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "❌ لم يتم العثور على المعاملة أو فشل الحذف"
    ], JSON_UNESCAPED_UNICODE);
}

$stmt->close();
$conn->close();
?>
