<?php
header("Content-Type: application/json; charset=UTF-8");
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once "db.php";

// استلام البيانات من الطلب
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

// التحقق من وصول id
if (!$data || !isset($data['id'])) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام رقم الإيراد"]);
    exit;
}

$revenueId = intval($data['id']);
if ($revenueId <= 0) {
    echo json_encode(["status" => "error", "message" => "❌ رقم الإيراد غير صالح"]);
    exit;
}

// حذف الإيراد
$sql = "DELETE FROM revenuesMH WHERE id = ?";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(["status" => "error", "message" => "❌ فشل تجهيز الاستعلام"]);
    exit;
}

$stmt->bind_param("i", $revenueId);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        echo json_encode(["status" => "success", "message" => "✅ تم حذف الإيراد بنجاح"]);
    } else {
        echo json_encode(["status" => "error", "message" => "⚠️ لم يتم العثور على الإيراد"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "❌ فشل تنفيذ عملية الحذف"]);
}

$stmt->close();
$conn->close();
?>
