<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "db.php";

$data = json_decode(file_get_contents("php://input"), true);
$PID = intval($data['id'] ?? 0);

if ($PID === 0) {
    echo json_encode(["status" => "error", "message" => "معرّف المشروع غير صالح"]);
    exit;
}

$sql = "DELETE FROM PrjectsMH WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $PID);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "تم حذف المشروع بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "فشل في حذف المشروع"]);
}

$stmt->close();
$conn->close();
?>
