<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: application/json; charset=UTF-8");
require_once "db.php";

// 📥 استقبال البيانات بصيغة JSON
$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام البيانات"]);
    exit;
}

// 🧾 قراءة معرف البند
$id = intval($data['id'] ?? 0);

if ($id === 0) {
    echo json_encode(["status" => "error", "message" => "⚠️ معرف البند غير صالح"]);
    exit;
}

// 🧠 تجهيز استعلام الحذف
$sql = "DELETE FROM ProjectTermsMH WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);

// 📤 تنفيذ الحذف
if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم حذف البند بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ خطأ أثناء الحذف: " . $stmt->error]);
}

// 🧹 تنظيف الموارد
$stmt->close();
$conn->close();
?>
