<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "db.php"; // الاتصال بقاعدة البيانات

$data = json_decode(file_get_contents("php://input"), true);

if (!$data || !isset($data['id'])) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام رقم البيان"]);
    exit;
}

$id = intval($data['id']);
if ($id === 0) {
    echo json_encode(["status" => "error", "message" => "⚠️ رقم البيان غير صالح"]);
    exit;
}

$sql = "DELETE FROM financialMH WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم حذف البيان بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ فشل في حذف البيان: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
