<?php
header("Content-Type: application/json; charset=UTF-8");
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once "db.php";

// استقبال البيانات
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

if (!$data || !isset($data['id']) || !is_numeric($data['id'])) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام رقم المصروف"]);
    exit;
}

$id = intval($data['id']);

// تنفيذ الحذف
$sql = "DELETE FROM expensesMH WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        echo json_encode(["status" => "success", "message" => "✅ تم حذف المصروف بنجاح"]);
    } else {
        echo json_encode(["status" => "warning", "message" => "⚠️ لم يتم العثور على المصروف"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "❌ فشل حذف المصروف"]);
}

$stmt->close();
$conn->close();
?>
