<?php
header("Content-Type: application/json; charset=UTF-8");
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once "db.php";

// استقبال البيانات من الـ AJAX
$data = json_decode(file_get_contents("php://input"), true);

// التحقق من البيانات
if (!$data || !isset($data['id']) || !is_numeric($data['id'])) {
    echo json_encode(["status" => "error", "message" => "❌ رقم العهدة غير صالح"]);
    exit;
}

$id = intval($data['id']);

// تنفيذ الحذف
$sql = "DELETE FROM custodyMH WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم حذف العهدة بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ فشل حذف العهدة: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
