// تحميل المشاريع من قاعدة البيانات
fetch('get_projects.php')
  .then(async res => {
    const text = await res.text();

    try {
      const data = JSON.parse(text);

      // لو السيرفر رجّع خطأ داخل JSON
      if (data.error) {
        throw new Error(data.error);
      }

      const select = document.getElementById('selected-project');
      select.innerHTML = '<option value="All" >  المشاريع </option>';

      data.forEach(project => {
        const option = document.createElement('option');
        option.value = project.id;
        option.textContent = project.name;
        select.appendChild(option);
      });
    } catch (err) {
      console.error("❌ فشل تحويل البيانات إلى JSON:", err.message);
      console.log("🔍 الرد من السيرفر كان:", text);
    }
  })
  .catch(error => {
    console.error("❌ فشل تحميل المشاريع:", error.message);
  });


// التعامل مع اختيار مشروع
handleProjectChange = (selectElement) => {
  const selectedId = selectElement.value;
  const selectedName = selectElement.options[selectElement.selectedIndex].text;

  // ✅ تحويل "All" إلى 0
  const PID = selectedId === "All" ? 0 : parseInt(selectedId);

  // ✅ تحديث النصوص والحقول
  document.getElementById('selected-project-text').textContent = selectedName;
  document.getElementById('selected-project-id').textContent = PID;
  document.getElementById('project-id-hidden').value = PID;

  console.log("✅ تم اختيار المشروع:", PID, selectedName);
  console.log("📌 القيمة النهائية في hidden input:", document.getElementById('project-id-hidden').value);

  // تحميل الإيرادات حسب المشروع

loadCustodies();
}





//Emop

  //get emp


  window.addEventListener('DOMContentLoaded', () => {
  // تحميل الموظفين من قاعدة البيانات
  fetch('get_employees.php')
    .then(async res => {
      const text = await res.text();

      try {
        const data = JSON.parse(text);

        if (data.error) {
          throw new Error(data.error);
        }

        const select = document.getElementById('employee-select');
        if (!select) throw new Error("عنصر select الخاص بالموظفين غير موجود");

        select.innerHTML = '<option value="" disabled selected>اختر الموظف</option>';

        data.forEach(emp => {
          const option = document.createElement('option');
          option.value = emp.id;
          option.textContent = emp.name;
          select.appendChild(option);
        });
      } catch (err) {
        console.error("❌ فشل تحويل بيانات الموظفين إلى JSON:", err.message);
        console.log("🔍 الرد من السيرفر كان:", text);
      }
    })
    .catch(error => {
      console.error("❌ فشل تحميل الموظفين:", error.message);
    });
});





handleEmployeeChange = (selectElement) => {
  const selectedId = selectElement.value;
  const selectedName = selectElement.options[selectElement.selectedIndex].text;

  const EID = selectedId === "" ? 0 : parseInt(selectedId);

  // تحديث العناصر المخفية
  document.getElementById('selected-employee-text').textContent = selectedName;
  document.getElementById('selected-employee-id').textContent = EID;
  document.getElementById('employee-id-hidden').value = EID;

  console.log("✅ تم اختيار الموظف:", EID, selectedName);
  console.log("📌 القيمة النهائية في hidden input:", document.getElementById('employee-id-hidden').value);
}









function showMessage(msg, type = "info", targetId = "fund-message") {
  const msgDiv = document.getElementById(targetId);
  if (!msgDiv) return;

  msgDiv.textContent = msg;
  msgDiv.style.display = "block";
  msgDiv.style.backgroundColor = type === "success" ? "#d4edda" :
                                 type === "error"   ? "#f8d7da" : "#fff3cd";
  msgDiv.style.color = type === "success" ? "#155724" :
                       type === "error"   ? "#721c24" : "#856404";

  setTimeout(() => {
    msgDiv.style.display = "none";
  }, 5000);
}






//Find

function openAttachment(attachmentUrl) {
  if (!attachmentUrl) return;

  attachmentUrl = attachmentUrl.trim();

  // لو الرابط نسبي، ضيفه على أصل الموقع الحالي
  if (!attachmentUrl.startsWith("http") && !attachmentUrl.startsWith("/")) {
    const baseUrl = window.location.origin + "/MMM/";
    attachmentUrl = baseUrl + attachmentUrl;
  }

  console.log("📎 فتح المرفق:", attachmentUrl);
  window.open(attachmentUrl, '_blank');
}

let editingCustodyId = null;
let firstLoadCustody = true;

function loadCustodies(PID = 0) {
  const tableBody = document.getElementById("advances-table-body");
  if (!tableBody) return;

  if (firstLoadCustody) {
    tableBody.innerHTML = `<tr><td colspan="8" style="padding: 20px; text-align: center;">جارٍ تحميل العهد...</td></tr>`;
  }

  fetch("get_custody.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ PID })
  })
    .then(response => response.json())
    .then(res => {
      firstLoadCustody = false;

      if (res.status !== "success" || !Array.isArray(res.data)) {
        tableBody.innerHTML = `<tr><td colspan="8" style="padding: 20px; text-align: center;">❌ فشل في تحميل العهد</td></tr>`;
        return;
      }

      const custodies = res.data;
      if (custodies.length === 0) {
        tableBody.innerHTML = `<tr><td colspan="8" style="padding: 20px; text-align: center;">لا توجد عهد مسجلة</td></tr>`;
        return;
      }

      tableBody.innerHTML = "";
      custodies.forEach(item => {
        const safeAttachment = encodeURIComponent(item.attachments || "");

        const row = document.createElement("tr");
        row.innerHTML = `
          <td>${item.project_name || "---"}</td>
          <td>${item.date || "---"}</td>
          <td>${item.employee || "---"}</td>
          <td>${item.amount || "0"}</td>
          <td>${item.balance || "0"}</td>
          <td>${item.expense || "0"}</td>
          
          <td>
            ${item.attachments ? `
              <div class="navS-icon" id="CustodyPdfBtn_${item.id}" tabindex="0" role="button"
                  style="width: 50px; cursor: pointer;" aria-label="العقد PDF"
                  onclick="openAttachment(decodeURIComponent('${safeAttachment}'))">
                <i class="fas fa-file-pdf"></i>
                <span class="tooltip" role="tooltip">العهده PDF</span>
              </div>
            ` : `<span class="no-attachment">—</span>`}
          </td>
          <td>${item.notes || "---"}</td>
        `;
        row.addEventListener("click", () => {
          document.getElementById("add-advance-section").style.display = "block";
          document.getElementById("advances-section").style.display = "none";

          const deleteBtn = document.getElementById("BTNDeletecustody");
          if (deleteBtn) deleteBtn.style.display = "block";

          fillCustodyForm(item);
        });

        tableBody.appendChild(row);
      });
    })
    .catch(err => {
      console.error("❌ خطأ في الاتصال:", err);
      tableBody.innerHTML = `<tr><td colspan="8" style="padding: 20px; text-align: center;">❌ فشل الاتصال بالسيرفر</td></tr>`;
    });
}

function fillCustodyForm(item) {
  const form = document.getElementById("add-advance-form");
  if (!form) return;

  const setVal = (selector, val) => {
    const el = form.querySelector(selector);
    if (el) el.value = val || "";
  };

  setVal('[name="advance_amount"]', item.amount);
  setVal('[name="notes"]', item.notes);
  setVal('[name="AttachmentPath"]', item.attachments);
  setVal('[name="dateAddCstody"]', item.date);

  const employeeSelect = document.getElementById("employee-select");
  if (employeeSelect) employeeSelect.value = item.employee_id || "";

  const employeeHidden = document.getElementById("employee-id-hidden");
  if (employeeHidden) employeeHidden.value = item.employee_id || "";

  const projectHidden = document.getElementById("project-id-hidden");
  if (projectHidden) projectHidden.value = item.project_id || "0";

  const itemIdInput = document.getElementById("item-id-hidden");
  if (itemIdInput) itemIdInput.value = item.id || "0";

  const projectSelect = document.getElementById("selected-project");
  if (projectSelect) {
    const option = [...projectSelect.options].find(opt => opt.textContent === item.project_name);
    if (option) projectSelect.value = option.value;
  }

  const projectText = document.getElementById("selected-project-text");
  if (projectText) projectText.textContent = item.project_name || "---";

  const projectIdText = document.getElementById("selected-project-id");
  if (projectIdText) projectIdText.textContent = item.project_id || "---";

  editingCustodyId = item.id;

  const section = document.getElementById("add-advance-section");
  if (section) section.setAttribute("aria-label", "تعديل عهدة");

  const saveBtn = document.getElementById("BTNSaveEdit");
  if (saveBtn) {
    const icon = saveBtn.querySelector("i");
    const tooltip = saveBtn.querySelector(".tooltip");
    saveBtn.setAttribute("aria-label", "تعديل");
    if (icon) icon.className = "fas fa-edit";
    if (tooltip) tooltip.textContent = "تعديل";
  }

  applyPermissions();
}

function resetCustodyForm() {
  const form = document.getElementById("add-advance-form");
  if (form) form.reset();

  editingCustodyId = null;

  const employeeHidden = document.getElementById("employee-id-hidden");
  if (employeeHidden) employeeHidden.value = "0";

  const projectHidden = document.getElementById("project-id-hidden");
  if (projectHidden) projectHidden.value = "0";

  const itemIdInput = document.getElementById("item-id-hidden");
  if (itemIdInput) itemIdInput.value = "0";

  const projectText = document.getElementById("selected-project-text");
  if (projectText) projectText.textContent = "---";

  const projectIdText = document.getElementById("selected-project-id");
  if (projectIdText) projectIdText.textContent = "---";

  const section = document.getElementById("add-advance-section");
  if (section) section.setAttribute("aria-label", "إضافة عهدة");

  const saveBtn = document.getElementById("BTNSaveEdit");
  if (saveBtn) {
    const icon = saveBtn.querySelector("i");
    const tooltip = saveBtn.querySelector(".tooltip");
    saveBtn.setAttribute("aria-label", "حفظ");
    if (icon) icon.className = "fas fa-save";
    if (tooltip) tooltip.textContent = "حفظ";
  }

  const deleteBtn = document.getElementById("BTNDeletecustody");
  if (deleteBtn) deleteBtn.style.display = "none";

  applyPermissions();
}
function startCustodyAutoRefresh() {
  let intervalId = null;

  function checkVisibilityAndUpdate() {
    const section = document.getElementById("advances-section");
    const projectSelect = document.getElementById("selected-project");
    const PID = projectSelect ? parseInt(projectSelect.value) || 0 : 0;

    if (section && section.offsetParent !== null) {
      if (!intervalId) {
        loadCustodies(PID);
        intervalId = setInterval(() => {
          const currentPID = projectSelect ? parseInt(projectSelect.value) || 0 : 0;
          loadCustodies(currentPID);
        }, 5000);
        console.log("✅ بدأ التحديث التلقائي للعهد");
      }
    } else {
      if (intervalId) {
        clearInterval(intervalId);
        intervalId = null;
        console.log("⏸️ توقف التحديث لأن القسم مخفي");
      }
    }
  }

  setInterval(checkVisibilityAndUpdate, 5000);
}


document.addEventListener("DOMContentLoaded", () => {
  const projectSelect = document.getElementById("selected-project");
  const PID = projectSelect ? parseInt(projectSelect.value) || 0 : 0;

  loadCustodies(PID);
  startCustodyAutoRefresh();

  if (projectSelect) {
    projectSelect.addEventListener("change", function () {
      handleProjectChange(this);
      const selectedPID = parseInt(this.value) || 0;
      loadCustodies(selectedPID);
    });
  } else {
    console.warn("⚠️ عنصر selected-project غير موجود في الصفحة.");
  }
});


//PDF
document.addEventListener("DOMContentLoaded", () => {
  const selectPdfBtn = document.getElementById("selectPdfBtn");
  const fileInput = document.getElementById("pdfFileInput");
  const attachmentField = document.getElementById("AttachmentPath");
  const msg = document.getElementById("projectMsg");

  // عند الضغط على زر اختيار الملف
  selectPdfBtn.addEventListener("click", () => {
    fileInput.click();
  });

  // عند اختيار ملف PDF
  fileInput.addEventListener("change", () => {
    const file = fileInput.files[0];
    if (!file) return;

    const formData = new FormData();
    formData.append("pdfFile", file);

    fetch("upload_pdf.php", {
      method: "POST",
      body: formData
    })
    .then(res => res.json())
    .then(data => {
      if (data.status === "success") {
        const fullPath = data.path; // مثال: DocumentPDF/contract123.pdf
        attachmentField.value = fullPath;

        msg.textContent = `✅ تم رفع الملف: ${file.name}`;
        msg.style.color = "green";
        msg.style.display = "block";

        setTimeout(() => {
          msg.style.display = "none";
        }, 5000);
      } else {
        msg.textContent = `❌ فشل رفع الملف: ${data.message}`;
        msg.style.color = "red";
        msg.style.display = "block";
      }
    })
    .catch(err => {
      console.error("❌ خطأ في رفع الملف:", err);
      alert("❌ فشل الاتصال بالسيرفر");
    });
  });
});



function openPdfFromInput() {
  const input = document.getElementById("AttachmentPath_fullDe");
  const fileName = input.value.trim();

  if (!fileName) {
    alert("⚠️ لازم تدخل اسم الملف");
    return;
  }

  const currentPath = window.location.pathname;
  const folderPath = currentPath.substring(0, currentPath.lastIndexOf("/"));
  const fullURL = `${window.location.origin}${folderPath}/${fileName}`;

  console.log("📂 الرابط النهائي:", fullURL);
  window.open(fullURL, "_blank");
}



//update & add
async function handleAdvanceSave() {
  console.log("✅ بدأ تنفيذ دالة handleAdvanceSave");

  const form = document.getElementById("add-advance-form");
  if (!form) {
    console.warn("❌ النموذج غير موجود");
    return;
  }

  const formData = new FormData(form);
  const data = {};
  formData.forEach((val, key) => data[key] = val);

  const PID = parseInt(document.getElementById("project-id-hidden")?.value || 0);
  const EmpID = parseInt(document.getElementById("employee-select")?.value || 0);
  const CAmount = parseFloat(data["advance_amount"] || 0);
  const CDate = data["dateAddCstody"] || "";
  const CNotes = data["notes"] || "";
  const AttachmentPath = data["AttachmentPath"] || "";

  const CID = parseInt(document.getElementById("item-id-hidden")?.value || 0);
  const isEditMode = CID > 0;

  console.log(isEditMode ? "✏️ وضع التعديل - ID:" + CID : "🆕 وضع الإضافة");

  // تحقق من البيانات فقط في حالة الإضافة
  if (!isEditMode && (PID === 0 || EmpID === 0 || CAmount <= 0 || CDate === "")) {
    alert("⚠️ برجاء استكمال بيانات العهدة بشكل صحيح");
    console.warn("❌ بيانات ناقصة:", { PID, EmpID, CAmount, CDate });
    return;
  }

  // ✅ تعديل أسماء الحقول لتتوافق مع السيرفر
  const payload = {
    PID: PID,
    EmpID: EmpID,
    CAmount: CAmount,
    CDate: CDate,
    CNotes: CNotes,
    AttachmentPath: AttachmentPath
  };

  let endpoint = "add_custody.php";
  if (isEditMode) {
    payload.id = CID;
    endpoint = "update_custody.php";
    console.log("✏️ تعديل فقط للموظف أو التاريخ أو القيمة أو الملاحظات");
  } else {
    console.log("🆕 إضافة جديدة - سيتم حفظ مشروع جديد");
  }

  console.log("📤 إرسال البيانات إلى:", endpoint);
  console.table(payload);

  try {
    const response = await fetch(endpoint, {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify(payload)
    });

    const text = await response.text();
    let result = {};
    try {
      result = JSON.parse(text);
    } catch (e) {
      console.error("❌ الاستجابة ليست بصيغة JSON:", text);
      alert("❌ فشل في قراءة استجابة السيرفر");
      return;
    }

    console.log("📥 رد السيرفر:", result);

    if (result.status === "success") {
      alert(result.message || "✅ تم حفظ العهدة بنجاح");

      form.reset();
      document.getElementById("item-id-hidden").value = "0";
      document.getElementById("selected-project-text").innerText = "---";
      document.getElementById("selected-project-id").innerText = "---";
      document.getElementById("employee-id-hidden").value = "0";
      document.getElementById("project-id-hidden").value = "0";

      const deleteBtn = document.getElementById("BTNDeletecustody");
      if (deleteBtn) deleteBtn.style.display = "none";

      const saveBtn = document.getElementById("BTNSaveEdit");
      if (saveBtn) {
        const icon = saveBtn.querySelector("i");
        const tooltip = saveBtn.querySelector(".tooltip");
        saveBtn.setAttribute("aria-label", "حفظ");
        if (icon) icon.className = "fas fa-save";
        if (tooltip) tooltip.textContent = "حفظ";
      }

      document.getElementById("add-advance-section").style.display = "none";
      document.getElementById("advances-section").style.display = "block";

      if (typeof loadCustodies === "function") loadCustodies();
    } else {
      alert("❌ فشل في حفظ العهدة: " + (result.message || "خطأ غير معروف"));
    }

  } catch (error) {
    console.error("❌ خطأ في الحفظ:", error);
    alert("❌ حدث خطأ أثناء حفظ العهدة");
  }
}

document.addEventListener("DOMContentLoaded", () => {
  const saveBtn = document.getElementById("BTNSaveEdit");
  if (saveBtn) {
    console.log("🔗 تم ربط زر الحفظ بالدالة handleAdvanceSave");
    saveBtn.addEventListener("click", handleAdvanceSave);
  } else {
    console.warn("❌ زر الحفظ BTNSaveEdit غير موجود في الصفحة");
  }
});



//Delete
function deleteCustody() {
  const custodyId = parseInt(document.getElementById("item-id-hidden")?.value || "0");

  if (!custodyId) {
    alert("⚠️ لا يوجد عهدة محددة للحذف");
    return;
  }

  if (!confirm("هل أنت متأكد أنك تريد حذف هذه العهدة؟")) return;

  fetch("delete_custody.php", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      "Accept": "application/json"
    },
    body: JSON.stringify({ id: custodyId })
  })
  .then(res => res.json())
  .then(result => {
    alert(result.message);
    if (result.status === "success") {
      document.getElementById("add-advance-form").reset();
      document.getElementById("item-id-hidden").value = "0";
      document.getElementById("selected-project-text").innerText = "---";
      document.getElementById("selected-project-id").innerText = "---";
      document.getElementById("employee-id-hidden").value = "0";
      document.getElementById("project-id-hidden").value = "0";
      document.getElementById("BTNDeletecustody").style.display = "none";
      document.getElementById("add-advance-section").style.display = "none";
      document.getElementById("advances-section").style.display = "block";
      if (typeof loadCustodies === "function") loadCustodies();
    }
  })
  .catch(err => {
    console.error("❌ خطأ أثناء حذف العهدة:", err);
    alert("❌ حدث خطأ أثناء عملية الحذف");
  });
}

// ربط الزر بالدالة بعد تحميل الصفحة
document.addEventListener("DOMContentLoaded", () => {
  const deleteBtn = document.getElementById("BTNDeletecustody");
  if (deleteBtn) deleteBtn.addEventListener("click", deleteCustody);
});
