
<?php
session_start();
if (!isset($_SESSION['username']) || !isset($_SESSION['usertype'])) {
    header("Location: Login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=1024, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <!-- ألوان شريط الحالة للـ Android -->
<meta name="theme-color" content="#ffffff">
<!-- للـ iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
<title>MADAD HOLDING Management System</title>
  
  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
 <link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">

</head>
<body>

 <!-- Header -->
<?php include 'header.php'; ?>


  <!-- Main Content -->
  <main class="main-content" role="main">
    <section class="projects-container" aria-label="العهدة">
  <div class="section-header" style="display: flex; align-items: center; justify-content: space-between;">

    <!-- العنوان مع اختيار المشروع -->
    <div style="display: flex; align-items: center; gap: 15px;">
      <h2 class="section-title" style="display: flex; align-items: center; gap: 8px; margin: 0;">
        <i class="fas fa-sack-dollar" aria-hidden="true"></i>
        العهدة
      </h2>

      <!-- اختيار المشروع -->
       <div class="form-field">
        <i class="fas fa-building icon-secondary"></i>
       
          <select id="selected-project"  required>

          <option value="All" >  المشاريع </option>
        </select>
      </div>
    </div>


    <!-- الأيقونات -->
    <div style="display: flex; align-items: center; gap: 10px;">
      
      <!-- إضافة عهدة -->
      <div class="navS-icon" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="إضافة عهدة" 
           onclick="toggleCustodyForm(); setActiveNavIconS(this)">
        <i class="fas fa-plus-circle"></i>
        <span class="tooltip" role="tooltip">إضافة عهدة</span>
      </div>

      <!-- عرض العهدة -->
      <div class="navS-icon active" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="عرض العهدة" 
           onclick="showCustodyList(); setActiveNavIconS(this)">
        <i class="fas fa-list"></i>
        <span class="tooltip" role="tooltip">العهدة</span>
      </div>

    </div>
  </div>
</section>


<br>

<section id="add-advance-section" class="projects-container" aria-label="إضافة عهده" style="display: none;">

 <div id="projectMsg" style="margin-top:10px; font-weight:bold; display:none;"></div>
   <p hidden>اسم المشروع: <span id="selected-project-text">---</span></p>
<p hidden>رقم المشروع (ID): <span id="selected-project-id">---</span></p>

<!-- تجربة عرض الـ ID في input -->
<input type="hidden" value="0" id="project-id-hidden" name="project_id">

  <div style="display: flex; align-items: center; justify-content: space-between;">
    <!-- العنوان -->
    <h2 class="section-title" style="margin: 0; display: flex; align-items: center; gap: 8px;">
      <i class="fas fa-sack-dollar" aria-hidden="true"></i>
      إضافة عهده  
    </h2>

    <!-- الأزرار -->
  <div style="display: flex; gap: 10px;">
    <!-- زر الحذف -->
    <div class="navS-icon" id="BTNDeletecustody" tabindex="0" role="button" 
         style="display:none; width: 50px; cursor: pointer;" aria-label="حذف" >
      <i class="fas fa-trash-alt"></i>
      <span class="tooltip" role="tooltip">حذف</span>
    </div>
      <div class="navS-icon" id="BTNSaveEdit" tabindex="0" role="button" style="width: 50px; cursor: pointer;" aria-label="حفظ">
        <i class="fas fa-save"></i>
        <span class="tooltip" role="tooltip">حفظ</span>
      </div>

      
  <div class="navS-icon" tabindex="0" role="button" id="BTNDeleteUser" style="display:none; width: 50px; cursor: pointer;">
      <i class="fas fa-trash-alt"></i>
      <span class="tooltip" role="tooltip">حذف</span>
    </div>

      <div class="navS-icon" id="selectPdfBtn" tabindex="0" role="button" style="width: 50px; cursor: pointer;" aria-label="العقد PDF">
  <i class="fas fa-file-pdf"></i>
  <span class="tooltip" role="tooltip">العهده PDF</span>
</div>

<!-- عنصر اختيار الملف المخفي -->
<input type="file" id="pdfFileInput" accept=".pdf" style="display: none;">

    </div>
      </div>
  
  <form id="add-advance-form" style="margin-top: 15px; display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px;">

    <!-- التاريخ -->
    <div class="form-field">
      <i class="fas fa-calendar-alt icon-secondary"></i>
      <input type="date" name="dateAddCstody"  id="dateAddCstody"  placeholder="التاريخ" required>
    </div>


   

    <!-- الموظف -->
 <!-- عرض اسم الموظف و ID بشكل مخفي -->

     <div class="form-field">
        <i class="fas fa-user icon-secondary"></i>
          <select id="employee-select"  required onchange="handleEmployeeChange(this)">
          <option value="All" >  الموظفين </option>
        </select>
      </div>
    </div>


     <input type="hidden" value="" id="selected-employee-text" name="selected-employee-text">
     <input type="hidden" value="" id="selected-employee-id" name="selected-employee-id">
     <input type="hidden" value="" id="employee-id-hidden" name="employee-id-hidden">
      <input type="hidden" value="" id="item-id-hidden" name="item-id-hidden">
    <!-- قيمة العهده -->
    <div class="form-field">
      <i class="fas fa-dollar-sign icon-secondary"></i>
      <input type="number" name="advance_amount" placeholder="قيمة العهده" required>
    </div>

    <!-- ملاحظات -->
    <div class="form-field" style="grid-column: span 3;">
      <i class="fas fa-sticky-note icon-secondary"></i>
      <input type="text" name="notes" placeholder="ملاحظات">
    </div>


  <input type="hidden" value="" id="AttachmentPath" name="AttachmentPath">
  </form>
</section>


<section id="advances-section" class="projects-container" aria-label="قائمة العهد" >

  <!-- العنوان -->
  <h2 class="section-title" style="display: flex; align-items: center; gap: 8px;">
    <i class="fas fa-sack-dollar" aria-hidden="true"></i>
    العهد
  </h2>

  <!-- جدول العهد -->
  <div style="display: flex; align-items: center; justify-content: space-between; width: 100%; margin-bottom: 10px;">
   
    <table class="items-table">
      <thead>
        <tr>
           <th><i class="fas fa-building icon-secondary"></i> المشروع</th>
          <th><i class="fas fa-calendar-alt icon-secondary"></i> التاريخ</th>
          <th><i class="fas fa-user icon-secondary"></i> الموظف</th>
          <th><i class="fas fa-sack-dollar icon-secondary"></i> قيمة العهده</th>
          <th><i class="fas fa-wallet icon-secondary"></i> الرصيد</th>
          <th><i class="fas fa-receipt icon-secondary"></i> المصروفات</th>
            <th><i class="fas fa-file-pdf icon-secondary"></i> المستند</th>
          <th><i class="fas fa-sticky-note icon-secondary"></i> ملاحظات</th>
        </tr>
      </thead>
      <tbody id="advances-table-body">
        <tr>
          <td colspan="8" class="no-items">لا توجد بيانات عهده مضافة بعد</td>
        </tr>
      </tbody>
    </table>

  </div>

</section>



    <!-- Chart Section -->
   
  </main>

  <!-- Scroll Top Button -->
  <button id="scrollTopBtn" class="fas fa-arrow-up"
          onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>

  <!-- Footer -->
<?php include 'footer.php'; ?>

  <!-- Scripts -->
  <script>
    document.getElementById('currentYear').textContent = new Date().getFullYear();
  </script>

  <script>
// منع تحديد النصوص
document.addEventListener('selectstart', function (e) {
    e.preventDefault();
}, false);

// منع الكليك يمين
document.addEventListener('contextmenu', function (e) {
    e.preventDefault();
}, false);

// منع السحب
document.addEventListener('dragstart', function (e) {
    e.preventDefault();
}, false);

// منع الحفظ وأوامر المطور
window.addEventListener('keydown', function (e) {
    // اختصارات Ctrl + (S, U, P, C, X, A)
    if (e.ctrlKey && ['s', 'u', 'p', 'c', 'x', 'a'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ هذا الاختصار معطل على هذا الموقع");
    }
    // منع F12
    if (e.key === 'F12') {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
    // منع Ctrl+Shift+I و Ctrl+Shift+J
    if (e.ctrlKey && e.shiftKey && ['i', 'j'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
}, true); // capture mode
</script>


 <script>
const today = new Date().toISOString().split('T')[0];
document.getElementById('dateAddCstody').value = today;
</script>




<script>
  let pageIdentifier = "custody";
</script>



     <script src="script.js"></script>

      <script src="custodyAjax.js" defer></script>
</body>
</html>