<?php
// إعداد المجلدات
$uploadDir = __DIR__ . '/DocumentPDF/';
$tmpDir = __DIR__ . '/tmp/';

// إنشاء المجلدات إذا مش موجودة
if (!file_exists($uploadDir)) mkdir($uploadDir, 0777, true);
if (!file_exists($tmpDir)) mkdir($tmpDir, 0777, true);

// ضمان أن PHP يستخدم المجلد المؤقت المحلي
ini_set('upload_tmp_dir', $tmpDir);

$message = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['pdfFile'])) {
    $file = $_FILES['pdfFile'];
    $fileName = basename($file['name']);
    $targetPath = $uploadDir . $fileName;
    $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    if ($ext !== 'pdf') {
        $message = "❌ يُسمح فقط برفع ملفات PDF.";
    } elseif ($file['error'] !== 0) {
        $message = "⚠️ حدث خطأ أثناء رفع الملف (رمز الخطأ: {$file['error']}).";
    } elseif (move_uploaded_file($file['tmp_name'], $targetPath)) {
        $message = "✅ تم رفع الملف بنجاح إلى المجلد: uploads/";
    } else {
        $message = "❌ فشل رفع الملف. تأكد من صلاحيات المجلد.";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>اختبار رفع ملف PDF</title>
<style>
body {
  font-family: "Cairo", sans-serif;
  background: linear-gradient(135deg, #f0f0f0, #dfe9f3);
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  margin: 0;
}
.container {
  background: #fff;
  padding: 30px 40px;
  border-radius: 20px;
  box-shadow: 0 5px 25px rgba(0,0,0,0.1);
  text-align: center;
  width: 400px;
}
h2 {
  margin-bottom: 20px;
  color: #333;
}
input[type="file"] {
  border: 2px dashed #007BFF;
  padding: 15px;
  width: 100%;
  border-radius: 10px;
  background: #f9f9f9;
  cursor: pointer;
}
button {
  background: #007BFF;
  color: #fff;
  border: none;
  padding: 10px 25px;
  border-radius: 10px;
  margin-top: 15px;
  cursor: pointer;
  transition: 0.3s;
}
button:hover {
  background: #0056b3;
}
.message {
  margin-top: 15px;
  font-size: 16px;
  font-weight: bold;
}
</style>
</head>
<body>
<div class="container">
  <h2>اختبار رفع ملف PDF</h2>
  <form action="" method="post" enctype="multipart/form-data">
      <input type="file" name="pdfFile" accept=".pdf" required><br>
      <button type="submit">رفع الملف</button>
  </form>
  <?php if ($message): ?>
  <div class="message"><?= htmlspecialchars($message) ?></div>
  <?php endif; ?>
</div>
</body>
</html>
