<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "db.php";

// استقبال البيانات من الطلب
$data = json_decode(file_get_contents("php://input"), true);
$PID = intval($data['PID'] ?? 0); // رقم المشروع
$EmpID = intval($data['EmpID'] ?? 0); // رقم الموظف
$totalPrice = floatval($data['total_price'] ?? 0); // السعر الإجمالي من النموذج

// تحقق من صحة البيانات
if ($PID === 0 || $EmpID === 0 || $totalPrice <= 0) {
    echo json_encode([
        "allowed" => false,
        "message" => "❌ بيانات غير مكتملة للتحقق"
    ]);
    exit;
}

// حساب إجمالي العهدة للموظف داخل المشروع المحدد فقط
$stmt = $conn->prepare("SELECT SUM(CAmount) AS total_custody FROM custodyMH WHERE PID = ? AND EmpID = ?");
$stmt->bind_param("ii", $PID, $EmpID);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();
$totalCustody = floatval($result['total_custody'] ?? 0);
$stmt->close();

// لو مفيش عهدة خالص في المشروع ده
if ($totalCustody === 0) {
    echo json_encode([
        "allowed" => false,
        "message" => "❌ لا توجد عهدة لهذا الموظف في هذا المشروع"
    ]);
    exit;
}

// المقارنة بين العهدة والسعر الإجمالي
if ($totalPrice > $totalCustody) {
    echo json_encode([
        "allowed" => false,
        "message" => "❌ السعر الإجمالي أكبر من رصيد العهدة المتاح. العهدة: $totalCustody"
    ]);
    exit;
}

// ✅ الرصيد يكفي
echo json_encode([
    "allowed" => true,
    "message" => "✅ المصروف مسموح",
    "custodyAmount" => $totalCustody
]);

$conn->close();
?>
