<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "db.php"; // ملف الاتصال بقاعدة البيانات

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام البيانات"]);
    exit;
}

$username  = trim($data['username'] ?? '');
$mobile    = trim($data['mobile'] ?? '');
$email     = trim($data['email'] ?? '');
$user_type = trim($data['user_type'] ?? '');
$password  = trim($data['password'] ?? '');
$status    = trim($data['status'] ?? 'نشط');
$notes     = trim($data['notes'] ?? '');

// التحقق من الحقول
if ($username === "" || $mobile === "" || $email === "" || $user_type === "" || $password === "") {
    echo json_encode(["status" => "error", "message" => "⚠️ كل الحقول مطلوبة"]);
    exit;
}

// تشفير كلمة المرور
$hashed_password = password_hash($password, PASSWORD_DEFAULT);

$sql = "INSERT INTO USEUSERSMH (username, mobile, email, user_type, password, status, notes) 
        VALUES (?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sssssss", $username, $mobile, $email, $user_type, $hashed_password, $status, $notes);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم إضافة المستخدم بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ خطأ: " . $stmt->error]);
}
$stmt->close();
$conn->close();
?>
