<?php
header("Content-Type: application/json; charset=UTF-8");
require_once "db.php"; // الاتصال بقاعدة البيانات

$data = json_decode(file_get_contents("php://input"), true);

if (!$data) {
    echo json_encode(["status" => "error", "message" => "❌ لم يتم استلام البيانات"]);
    exit;
}

// استخراج البيانات بنفس أسماء الحقول المرسلة من الجافاسكريبت
$PID            = intval($data['PID'] ?? 0);
$EmpID          = intval($data['EmpID'] ?? 0);
$CAmount        = floatval($data['CAmount'] ?? 0);
$CDate          = trim($data['CDate'] ?? '');
$CNotes         = trim($data['CNotes'] ?? '');
$AttachmentPath = trim($data['AttachmentPath'] ?? '');

// التحقق من الحقول الأساسية
if ($PID === 0 || $EmpID === 0 || $CAmount <= 0 || $CDate === '') {
    echo json_encode(["status" => "error", "message" => "⚠️ برجاء استكمال البيانات المطلوبة"]);
    exit;
}

// تنفيذ الإدخال
$sql = "INSERT INTO custodyMH (PID, EmpID, CAmount, CDate, CNotes, AttachmentPath) 
        VALUES (?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("iidsss", $PID, $EmpID, $CAmount, $CDate, $CNotes, $AttachmentPath);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "✅ تم حفظ العهدة بنجاح"]);
} else {
    echo json_encode(["status" => "error", "message" => "❌ خطأ: " . $stmt->error]);
}

$stmt->close();
$conn->close();
?>
