

function saveUser() {
  const saveBtn = document.getElementById("BTNSaveandEdit");
if (saveBtn.querySelector(".tooltip")?.textContent.trim() === "حفظ") {
  // هنا تكتب اللي عاوز تنفذه لما يكون الزر في وضع حفظ
  
  const form = document.getElementById("add-user-form");
  const formData = new FormData(form);
  let data = {};
  formData.forEach((value, key) => data[key] = value);

  fetch("add_user.php", {
    method: "POST",
    body: JSON.stringify(data)
  })
  .then(res => res.json())
  .then(response => {
    alert(response.message);
    if (response.status === "success") {
      form.reset();
    }
  })
  .catch(err => {
    alert("❌ خطأ في الاتصال بالسيرفر");
    console.error(err);
  });
}
else 

{

   {

  const form = document.getElementById("add-user-form");
  const formData = new FormData(form);
  const saveBtn = document.getElementById("BTNSaveandEdit");
if (saveBtn.querySelector(".tooltip")?.textContent.trim() === "تعديل") {
  let data = {};
  formData.forEach((value, key) => data[key] = value);

  // 🟢 لو في تعديل نضيف الـ ID
  if (editingUserId) {
    data["id"] = editingUserId;
  }

  fetch(editingUserId ? "update_user.php" : "add_user.php", {
    method: "POST",
    body: JSON.stringify(data)
  })
  .then(res => res.json())
  .then(response => {
    alert(response.message);
    if (response.status === "success") {
      form.reset();
      editingUserId = null;
      resetFormTitle(); // رجع الفورم لوضع الإضافة
      loadUsers();
    }
  })
  .catch(err => {
    alert("❌ خطأ في الاتصال بالسيرفر");
    console.error(err);
  });
}
}
function resetFormTitle() {
  // 🟢 يرجع الفورم لوضع "إضافة"
  document.querySelector("#add-user-section h2").innerHTML = `
    <i class="fas fa-user-plus"></i> إضافة مستخدم
  `;
 saveBtn.setAttribute("aria-label", "حفظ");

   const icon = saveBtn.querySelector("i");
  const tooltip = saveBtn.querySelector(".tooltip");
    if (icon) icon.className = "fas fa-save";
    if (tooltip) tooltip.textContent = "حفظ";
}
}

}


//Show User



let editingUserId = null; // لمعرفة وضع تعديل أم إضافة
 document.getElementById("BTNDeleteUser").style.display = "none";
function loadUsers() {
  fetch("get_users.php")
    .then(res => res.json())
    .then(response => {
      const tbody = document.getElementById("users-table-body");
      tbody.innerHTML = "";

      if (response.status === "success" && response.data.length > 0) {
        response.data.forEach(user => {
          const tr = document.createElement("tr");

          tr.innerHTML = `
            <td>${user.username}</td>
            <td>${user.mobile}</td>
            <td>${user.email}</td>
            <td>${user.user_type}</td>
            <td>${user.created_at}</td>
            <td>
              <span style="color:${user.status === "نشط" ? "green" : "red"}; font-weight:bold;">
                ${user.status}
              </span>
            </td>
          `;

          // عند الضغط على الصف → يتم ملء بياناته في الفورم
          tr.addEventListener("click", () => {
            
              document.getElementById("add-user-section").style.display = "block";
                document.getElementById("users-section").style.display = "none";
           

               document.getElementById("BTNDeleteUser").style.display = "block";
            fillUserForm(user);
          

          });

          tbody.appendChild(tr);
        });
      } else {
        tbody.innerHTML = `<tr><td colspan="6" class="no-items">لا يوجد مستخدمين</td></tr>`;
      }
    })
    .catch(err => {
      console.error("❌ خطأ:", err);
      const tbody = document.getElementById("users-table-body");
      tbody.innerHTML = `<tr><td colspan="6" class="no-items">تعذر تحميل البيانات</td></tr>`;
    });
}

function fillUserForm(user) {
  const form = document.getElementById("add-user-form");

  form.username.value   = user.username;
  form.mobile.value     = user.mobile;
  form.email.value      = user.email;
  form.user_type.value  = user.user_type;
  form.password.value   = ""; // ما نعرضش الباسورد
  form.status.value     = user.status;
  form.notes.value      = user.notes ?? "";

  editingUserId = user.id;

  document.querySelector("#add-user-section h2").innerHTML =
    `<i class="fas fa-user-edit"></i> تعديل مستخدم`;

const isEditMode = true; // أو false حسب الحالة

const saveBtn = document.getElementById("BTNSaveandEdit");
if (saveBtn) {
  const icon = saveBtn.querySelector("i");
  const tooltip = saveBtn.querySelector(".tooltip");

  if (isEditMode) {
    saveBtn.setAttribute("aria-label", "تعديل");
    if (icon) icon.className = "fas fa-edit";
    if (tooltip) tooltip.textContent = "تعديل";
     document.getElementById("BTNDeleteUser").style.display = "block";
  } else {
    saveBtn.setAttribute("aria-label", "حفظ");
    if (icon) icon.className = "fas fa-save";
    if (tooltip) tooltip.textContent = "حفظ";
    document.getElementById("BTNDeleteUser").style.display = "none";
  }
}

}

document.addEventListener("DOMContentLoaded", function() {
  loadUsers();
});

document.addEventListener("DOMContentLoaded", function() {
  loadUsers(); // أول تحميل

  // ✅ تحديث تلقائي كل 5 ثواني
  setInterval(loadUsers, 5000);
});



//Delete

const deleteBtn = document.getElementById("BTNDeleteUser");
if (deleteBtn) {
  deleteBtn.style.display = "inline-block"; // ✅ إظهار الزر
  deleteBtn.onclick = function () {
    if (confirm("هل أنت متأكد أنك تريد حذف هذا المستخدم؟")) {
      fetch("delete_user.php", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ id: editingUserId })
      })
      .then(res => res.json())
      .then(response => {
        if (response.status === "success") {
          alert("✅ تم حذف المستخدم بنجاح");
          editingUserId = null;
          document.getElementById("add-user-section").style.display = "none";
          document.getElementById("users-section").style.display = "block";
          loadUsers();
        } else {
          alert("❌ فشل في حذف المستخدم");
        }
      })
      .catch(err => {
        console.error("❌ خطأ في الحذف:", err);
        alert("❌ حدث خطأ أثناء محاولة الحذف");
      });
    }
  };
}
