<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
   <meta name="viewport" content="width=1024, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <!-- ألوان شريط الحالة للـ Android -->
<meta name="theme-color" content="#ffffff">
<!-- للـ iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
<title>MADAD HOLDING Management System</title>
  
  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
 <link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">
  <!-- Chart.js with 3D plugin -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-3d@latest/dist/chartjs-plugin-3d.min.js"></script>
</head>
<body>

 <!-- Header -->
<?php include 'header.php'; ?>

  <!-- Marquee -->
  <div class="header-marquee">
   
       <marquee direction="right" scrollamount="5" onmouseover="this.stop();" onmouseout="this.start();">
   
      &nbsp;&nbsp; &nbsp;&nbsp; الصندوق &nbsp;&nbsp; 8,250,000 ريال &nbsp;&nbsp; &nbsp;&nbsp; <i class="fas fa-wallet"></i> &nbsp;&nbsp; 
      الرصيد الحالي &nbsp;&nbsp; 5,250,000 ريال &nbsp;&nbsp;&nbsp;&nbsp; <i class="fas fa-money-bill-wave"></i> &nbsp;&nbsp; 
      الإيرادات &nbsp;&nbsp; 3,250,000 ريال &nbsp;&nbsp; &nbsp;&nbsp; <i class="fas fa-receipt"></i> &nbsp;&nbsp; 
      المصروفات &nbsp;&nbsp; 2,250,000 ريال &nbsp;&nbsp;&nbsp;&nbsp; <i class="fas fa-coins"></i> &nbsp;&nbsp; 
      الأرباح &nbsp;&nbsp; 1,250,000 ريال &nbsp;&nbsp; &nbsp;&nbsp; <i class="fas fa-sack-dollar"></i> &nbsp;&nbsp; 
      العُهدة &nbsp;&nbsp; 8,250,000 ريال &nbsp;&nbsp;&nbsp;&nbsp; <i class="fas fa-chart-line"></i> &nbsp;&nbsp;
    </marquee>
  </div>

  <!-- Main Content -->
  <main class="main-content" role="main">
    <section class="projects-stats-section" aria-label="قسم المشاريع والإحصائيات">
      
    </section>

    <!-- Chart Section -->
    <section class="chart-container" aria-label="قسم الرسم البياني" dir="rtl">
      <div class="chart-header">
        <h3 class="chart-title">
          <i class="fas fa-chart-line icon-primary"></i>
          تحليل الأداء المالي
        </h3>

        <!-- Project Selector -->
        <div class="project-selector">
          <div class="custom-select-wrapper">
            <div class="custom-select" onclick="toggleDropdown()" aria-haspopup="listbox" aria-expanded="false">
              <i class="fas fa-list icon-secondary"></i>
              <span id="selected-project-text">اختر المشروع...</span>
              <i class="fas fa-chevron-down dropdown-arrow icon-secondary"></i>
            </div>
            <div class="custom-options" id="dropdown-options" role="listbox">
              <div class="option" onclick="selectOption('project1', 'مشروع جيزان')" role="option">
                <i class="fas fa-building icon-secondary"></i>
                <span>مشروع جيزان</span>
              </div>
            </div>
            <input type="hidden" id="selected-project" name="selected-project">
          </div>
        </div>

        <!-- Chart Controls -->
        <div class="chart-controls">
          <!-- Chart Type -->
          <div class="chart-btn-group" role="group" aria-label="اختيار الرسم البياني">
            <button class="chart-btn active">
              <i class="fas fa-receipt"></i>
              <span class="btn-text">المصروفات</span>
              <i class="fas fa-exchange-alt"></i>&nbsp;&nbsp; 
              <span class="btn-text"><i class="fas fa-coins">&nbsp;&nbsp; </i>الأرباح</span>
            </button>
            <button class="chart-btn">
              <i class="fas fa-bullseye"></i>
              <span class="btn-text">المطلوب</span>
              <i class="fas fa-exchange-alt"></i>
              <span class="btn-text"><i class="fas fa-check-circle">&nbsp;&nbsp; </i>الإنجاز</span>
            </button>
          </div>

          <!-- Time Filter -->
          <div class="time-btn-group" role="group" aria-label="اختيار الفترة الزمنية">
            <button class="time-btn"><i class="fas fa-calendar-week"></i> <span>أسبوع</span></button>
            <button class="time-btn active"><i class="fas fa-calendar-alt"></i> <span>شهر</span></button>
            <button class="time-btn"><i class="fas fa-calendar"></i> <span>سنة</span></button>
            <button class="time-btn"><i class="fas fa-infinity"></i> <span>الكل</span></button>
          </div>
        </div>
      </div>

      <!-- Chart -->
      <div class="chart-placeholder" style="display: none;">
        <div class="chart-loader">
          <div class="loader"></div>
          <p>جاري تحميل البيانات...</p>
        </div>
        <canvas id="financialChart"></canvas>
      </div>
    </section>
  </main>

  <!-- Scroll Top Button -->
  <button id="scrollTopBtn" class="fas fa-arrow-up"
          onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>

 <!-- Footer -->
<?php include 'footer.php'; ?>

  <!-- Scripts -->
  <script>
    document.getElementById('currentYear').textContent = new Date().getFullYear();
  </script>

  <script>
// منع تحديد النصوص
document.addEventListener('selectstart', function (e) {
    e.preventDefault();
}, false);

// منع الكليك يمين
document.addEventListener('contextmenu', function (e) {
    e.preventDefault();
}, false);

// منع السحب
document.addEventListener('dragstart', function (e) {
    e.preventDefault();
}, false);

// منع الحفظ وأوامر المطور
window.addEventListener('keydown', function (e) {
    // اختصارات Ctrl + (S, U, P, C, X, A)
    if (e.ctrlKey && ['s', 'u', 'p', 'c', 'x', 'a'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ هذا الاختصار معطل على هذا الموقع");
    }
    // منع F12
    if (e.key === 'F12') {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
    // منع Ctrl+Shift+I و Ctrl+Shift+J
    if (e.ctrlKey && e.shiftKey && ['i', 'j'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
}, true); // capture mode
</script>




  <script src="https://cdn.jsdelivr.net/npm/vanilla-tilt@1.7.0/dist/vanilla-tilt.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
  <script src="script.js"></script>
  <script src="Chartscript.js"></script>
</body>
</html>