// تحميل المشاريع من قاعدة البيانات
fetch('get_projects.php')
  .then(async res => {
    const text = await res.text();

    try {
      const data = JSON.parse(text);

      // لو السيرفر رجّع خطأ داخل JSON
      if (data.error) {
        throw new Error(data.error);
      }

      const select = document.getElementById('selected-project');
      select.innerHTML = '<option value="All" >  المشاريع </option>';

      data.forEach(project => {
        const option = document.createElement('option');
        option.value = project.id;
        option.textContent = project.name;
        select.appendChild(option);
      });
    } catch (err) {
      console.error("❌ فشل تحويل البيانات إلى JSON:", err.message);
      console.log("🔍 الرد من السيرفر كان:", text);
    }
  })
  .catch(error => {
    console.error("❌ فشل تحميل المشاريع:", error.message);
  });

// التعامل مع اختيار مشروع
handleProjectChange = (selectElement) => {
  const selectedId = selectElement.value;
  const selectedName = selectElement.options[selectElement.selectedIndex].text;

  // ✅ تحويل "All" إلى 0
  const PID = selectedId === "All" ? 0 : parseInt(selectedId);

  // ✅ تحديث النصوص والحقول
  document.getElementById('selected-project-text').textContent = selectedName;
  document.getElementById('selected-project-id').textContent = PID;
  document.getElementById('project-id-hidden').value = PID;

  console.log("✅ تم اختيار المشروع:", PID, selectedName);
  console.log("📌 القيمة النهائية في hidden input:", document.getElementById('project-id-hidden').value);

  // تحميل الإيرادات حسب المشروع

loadProjects();
}












/****************************
 *  🏗️ PROJECTS & ITEMS
 ****************************/


// إظهار فورم البند

function addItem() {
  const selectedProject = document.getElementById("selected-project");
  const selectedValue = selectedProject?.value;

  if (selectedValue === "All") {
    const msgBox = document.getElementById("projectMsg");
    if (msgBox) {
      msgBox.textContent = "⚠️ يرجى اختيار المشروع أولاً";
      msgBox.style.color = "red";
      msgBox.style.display = "block";

      setTimeout(() => {
        msgBox.style.opacity = "0";
      }, 4500);

      setTimeout(() => {
        msgBox.style.display = "none";
        msgBox.style.opacity = "1";
      }, 5000);
    }
    return; // ❌ إيقاف تنفيذ الدالة
  }

  // ✅ تنفيذ عرض الأقسام فقط إذا تم اختيار مشروع
  const AllProject = document.getElementById('all-projects');
  const addItemSection = document.getElementById('add-project-section');
  const OneProject = document.getElementById('project-details');
  const AddItem = document.getElementById('add-item-section');

  AllProject.style.display = 'none';
  addItemSection.style.display = 'none';
  OneProject.style.display = 'block';
  AddItem.style.display = 'block';

  window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
}

function Add_item_Anim()
{
 
   const AddItemF = document.getElementById('add-item-section');
   AddItemF.style.display = 'block';
window.scrollBy({ top: 300, left: 0, behavior: 'smooth' });

}

function AllProject()
{
    const AllProject = document.getElementById('all-projects');
  const OneProject = document.getElementById('project-details');
   const addProjecSection = document.getElementById('add-project-section');

const addItemSection = document.getElementById('add-item-section')

   

  closeAllDropdowns();
    window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
AllProject.style.display = 'block';
OneProject.style.display = 'none';
addProjecSection.style.display = 'none';
addItemSection.style.display = 'none';


}
function selectProject(id, name) {
  // تحديث النص والقيمة المختارة
  const selectedText = document.getElementById('selected-project-text');
  const selectedValue = document.getElementById('selected-project');
    const AllProject = document.getElementById('all-projects');
  AllProject.style.display = 'none';

  if (selectedText) selectedText.textContent = name;
  if (selectedValue) selectedValue.value = id;

  // تغيير الأيقونة حسب المشروع
  let iconClass;
  switch(id) {
    case 'AllProject': iconClass = 'fa-city'; break;
    case 'project1': iconClass = 'fa-building'; break;
    case 'project2': iconClass = 'fa-city'; break;
    case 'project3': iconClass = 'fa-industry'; break;
    default: iconClass = 'fa-list';
  }
  
  const icon = document.querySelector('.custom-select i:first-child');
  if (icon) icon.className = `fas ${iconClass} icon-secondary`;

  // إغلاق القائمة المنسدلة
  closeAllDropdowns();

  // إظهار تفاصيل المشروع
  const projectDetails = document.getElementById('project-details');
  if (projectDetails) projectDetails.style.display = 'block';

  // إخفاء الأقسام الأخرى
  const addItemSection = document.getElementById('add-item-section');
  if (addItemSection) addItemSection.style.display = 'none';
  
  const addProjectSection = document.getElementById('add-project-section');
  if (addProjectSection) addProjectSection.style.display = 'none';

  // التمرير بسلاسة
  window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
}



//Load all projects details
let editingProjectId = null; // وضع تعديل أو إضافة
let firstLoad = true;        // ✅ لتحديد أول تحميل فقط

function loadProjects(PID = 0) {
  const tableBody = document.getElementById("projects-table-body");
  if (!tableBody) return;

  // ✅ عرض رسالة "جارٍ التحميل" فقط أول مرة
  if (firstLoad) {
    tableBody.innerHTML = `<tr><td colspan="6" style="padding: 20px; text-align: center;">جارٍ تحميل المشاريع...</td></tr>`;
  }

  fetch("get_projectsDetials.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ PID })
  })
    .then(response => response.json())
    .then(res => {
      firstLoad = false; // ✅ بعد أول تحميل، نوقف عرض الرسالة

      if (res.status !== "success" || !Array.isArray(res.data)) {
        tableBody.innerHTML = `<tr><td colspan="6" style="padding: 20px; text-align: center;">❌ فشل في تحميل المشاريع</td></tr>`;
        return;
      }

      const projects = res.data;
      if (projects.length === 0) {
        tableBody.innerHTML = `<tr><td colspan="6" style="padding: 20px; text-align: center;">لا توجد مشاريع مسجلة</td></tr>`;
        return;
      }

      tableBody.innerHTML = "";
      projects.forEach(proj => {
        const row = document.createElement("tr");
        row.innerHTML = `
          <td>${proj.project_name}</td>
          <td>${proj.project_owner}</td>
          <td>${proj.project_location}</td>
          <td>${proj.project_status}</td>
          <td>${formatCurrency(proj.project_cost)}</td>
          <td>${proj.project_duration}</td>
        `;

        // 📌 عند الضغط على الصف → تعبئة النموذج وتفعيل وضع التعديل
        row.addEventListener("click", () => {
          document.getElementById("add-project-section").style.display = "block";
          document.getElementById("all-projects").style.display = "none";
          const deleteBtn = document.getElementById("BTNDelete");
          if (deleteBtn) deleteBtn.style.display = "block";
          fillProjectForm(proj);
        });

        tableBody.appendChild(row);
      });
    })
    .catch(err => {
      console.error("❌ خطأ في الاتصال:", err);
      tableBody.innerHTML = `<tr><td colspan="6" style="padding: 20px; text-align: center;">❌ فشل الاتصال بالسيرفر</td></tr>`;
    });
}


function fillProjectForm(proj) {
  const form = document.getElementById("add-project-form");
  if (!form) return;

  const setVal = (selector, val) => {
    const el = form.querySelector(selector);
    if (el) el.value = val || "";
  };

  setVal('[name="project_name"]', proj.project_name);
  setVal('[name="project_owner"]', proj.project_owner);
  setVal('[name="project_location"]', proj.project_location);
  setVal('[name="project_status"]', proj.project_status);
  setVal('[name="project_cost"]', proj.project_cost);
  setVal('[name="project_duration"]', proj.project_duration);

  const attachPath = document.getElementById("AttachmentPath");
  if (attachPath) attachPath.value = proj.AttachmentPath || "";

  editingProjectId = proj.id;

  // ✅ إضافة الـ ID في العنصر المخفي
  const hiddenId = document.getElementById("project-id-hidden");
  if (hiddenId) hiddenId.value = proj.id;

  // ✅ إضافة الـ item-id-hidden لو موجود
  const itemIdInput = document.getElementById("item-id-hidden");
  if (itemIdInput) itemIdInput.value = proj.id;

  // ✅ إضافة اسم المشروع في الـ select
  const projectSelect = document.getElementById("selected-project");
  if (projectSelect) {
    const option = [...projectSelect.options].find(opt => opt.textContent === proj.project_name);
    if (option) projectSelect.value = option.value;
  }

  // تغيير العنوان
  document.querySelector("#add-project-section h2").innerHTML =
    `<i class="fas fa-city icon-secondary"></i> تعديل مشروع`;

  // تغيير aria-label
  const section = document.getElementById("add-project-section");
  if (section) section.setAttribute("aria-label", "تعديل مشروع");

  // تغيير الزرار
  const saveBtn = document.getElementById("save-project-btn");
  if (saveBtn) {
    const icon = saveBtn.querySelector("i");
    const tooltip = saveBtn.querySelector(".tooltip");

    saveBtn.setAttribute("aria-label", "تعديل");
    if (icon) icon.className = "fas fa-edit";
    if (tooltip) tooltip.textContent = "تعديل";
  }

  applyPermissions(); // لو عندك صلاحيات
}


function resetProjectForm() {
  const form = document.getElementById("add-project-form");
  if (form) form.reset();

  editingProjectId = null;

  // ✅ إعادة الـ ID إلى صفر
  const hiddenId = document.getElementById("project-id-hidden");
  if (hiddenId) hiddenId.value = "0";

  // ✅ إعادة الـ item-id-hidden إلى صفر لو موجود
  const itemIdInput = document.getElementById("item-id-hidden");
  if (itemIdInput) itemIdInput.value = "0";

  // ✅ إعادة اسم المشروع في الـ select إلى "All"
  const projectSelect = document.getElementById("selected-project");
  if (projectSelect) projectSelect.value = "All";

  document.querySelector("#add-project-section h2").innerHTML =
    `<i class="fas fa-city icon-secondary"></i> اضافه مشروع`;

  const section = document.getElementById("add-project-section");
  if (section) section.setAttribute("aria-label", "المشاريع والإحصائيات");

  const saveBtn = document.getElementById("save-project-btn");
  if (saveBtn) {
    const icon = saveBtn.querySelector("i");
    const tooltip = saveBtn.querySelector(".tooltip");

    saveBtn.setAttribute("aria-label", "حفظ");
    if (icon) icon.className = "fas fa-save";
    if (tooltip) tooltip.textContent = "حفظ";
  }

  const deleteBtn = document.getElementById("BTNDelete");
  if (deleteBtn) deleteBtn.style.display = "none";

  applyPermissions(); // لو عندك صلاحيات
}


function startProjectsAutoRefresh() {
  let intervalId = null;

  function checkVisibilityAndUpdate() {
    const section = document.getElementById("all-projects");
    if (section && section.offsetParent !== null) {
      if (!intervalId) {
        loadProjects();
        intervalId = setInterval(loadProjects, 5000);
        console.log("✅ بدأ التحديث التلقائي للمشاريع");
      }
    } else {
      if (intervalId) {
        clearInterval(intervalId);
        intervalId = null;
        console.log("⏸️ توقف التحديث لأن القسم مخفي");
      }
    }
  }

  setInterval(checkVisibilityAndUpdate, 5000);
}


document.addEventListener("DOMContentLoaded", () => {
  loadProjects();
  startProjectsAutoRefresh();
});



// ✅ ترجمة حالة المشروع


// ✅ تنسيق التكلفة




//Sum
document.addEventListener("DOMContentLoaded", () => {
  const tbody = document.getElementById("projects-table-body");
  if (!tbody) return;

  // إنشاء عناصر العرض
  const countLabel = document.createElement("div");
  countLabel.id = "projects-count";
  countLabel.style.fontWeight = "bold";

  const totalLabel = document.createElement("div");
  totalLabel.id = "projects-total";
  totalLabel.style.fontWeight = "bold";

  // أيقونات


 const countIcon = '<i class="fas fa-hashtag dropdown-arrow icon-secondary"></i> ';
    const totalIcon = '<i class="fas fa-calculator dropdown-arrow icon-secondary"></i> ';



  // إدراجهم بعد الجدول
  tbody.parentNode.insertBefore(countLabel, tbody.nextSibling);
  tbody.parentNode.insertBefore(totalLabel, countLabel.nextSibling);

  // دالة لتحويل الأرقام العربية إلى إنجليزية
  function convertArabicToEnglishNumbers(str) {
    const arabicNumbers = ['٠','١','٢','٣','٤','٥','٦','٧','٨','٩'];
    return str.replace(/[٠-٩]/g, d => arabicNumbers.indexOf(d));
  }

  function updateProjectsSummary() {
    if (!tbody || tbody.querySelectorAll("tr").length === 0) return;

    const rows = Array.from(tbody.querySelectorAll("tr")).filter(r => !r.classList.contains("no-projects"));
    const totalRows = rows.length;
    let totalCost = 0;

    rows.forEach(row => {
      const costCell = row.cells[4]; // عمود "التكلفة"
      if (costCell && costCell.textContent.trim() !== '') {
        const rawText = costCell.textContent.trim();
        const cleanedText = convertArabicToEnglishNumbers(rawText).replace(/[^\d.-]/g, '');
        const cellValue = parseFloat(cleanedText) || 0;
        totalCost += cellValue;
      }
    });

    countLabel.innerHTML = `<br>${countIcon}عدد المشاريع: ${totalRows}<br>`;
    const formattedTotal = parseFloat(totalCost).toLocaleString("en-US", {
  minimumFractionDigits: 2,
  maximumFractionDigits: 2
});

totalLabel.innerHTML = `<br>${totalIcon}إجمالي التكلفة: ${formattedTotal} ريال<br>`;

    countLabel.style.marginTop = "10px";  
    countLabel.style.marginBottom = "10px";
    totalLabel.style.marginTop = "10px";
    totalLabel.style.marginBottom = "10px";
  }

  // تحديث أولي
  updateProjectsSummary();

  // مراقبة التغييرات في الجدول
  const observer = new MutationObserver(() => {
    updateProjectsSummary();
  });

  observer.observe(tbody, { childList: true, subtree: true });
});



handleProjectSelectChange = (selectElement) => {
  const selectedId = selectElement.value;
  const selectedName = selectElement.options[selectElement.selectedIndex].text;

  // ✅ تحويل "All" إلى 0
  const PID = selectedId === "All" ? 0 : parseInt(selectedId);

  // ✅ تحديث النصوص والحقول حسب الصفحة الجديدة
  document.getElementById('project-name-display').textContent = selectedName;
  document.getElementById('project-id-display').textContent = PID;
  document.getElementById('project-id-hidden-input').value = PID;

  console.log("✅ تم اختيار المشروع:", PID, selectedName);
  console.log("📌 القيمة النهائية في hidden input:", document.getElementById('project-id-hidden-input').value);

  // ✅ تحميل البيانات الخاصة بالمشروع الجديد (مصروفات، تفاصيل، إلخ)
  loadProjects(PID); // ← غير اسم الدالة حسب المطلوب في الصفحة
}



//Full detials
let editingItemId = null;
let firstItemLoad = true;

function showProjectDetails() {
  const PID = parseInt(document.getElementById("project-id-hidden").value || 0);
  if (PID === 0) {
    alert("⚠️ الرجاء اختيار مشروع أولاً");
    return;
  }

  fetch("get_project_full_details.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ PID })
  })
    .then(res => res.json())
    .then(data => {
      if (data.status !== "success") {
        alert(data.message || "❌ فشل في تحميل بيانات المشروع");
        return;
      }

      const proj = data.project;
      const terms = data.terms;

      // ✅ تعبئة معلومات المشروع
      document.getElementById("project-name-display").textContent = `اسم المشروع: ${proj.project_name}`;
      document.getElementById("project-owner-display").textContent = `المالك: ${proj.project_owner}`;
      document.getElementById("project-status-display").textContent = `حالة المشروع: ${proj.project_status}`;
      document.getElementById("project-location-display").textContent = `موقع المشروع: ${proj.project_location}`;
      document.getElementById("project-cost-display").textContent = `تكلفة المشروع: ${formatCurrency(proj.project_cost)}`;
      document.getElementById("project-duration-display").textContent = `مدة المشروع: ${proj.project_duration}`;

      const attachmentInput = document.getElementById("AttachmentPath_fullDe");
      if (attachmentInput) {
        attachmentInput.value = proj.AttachmentPath || "";
      }

      document.getElementById("project-details").style.display = "block";

      // ✅ تعبئة جدول البنود
      const tbody = document.getElementById("items-table-body");
      tbody.innerHTML = "";

      if (terms.length === 0) {
        tbody.innerHTML = `<tr><td colspan="7" class="no-items">لا توجد بنود مضافة بعد</td></tr>`;
        return;
      }

      terms.forEach(term => {
        const row = document.createElement("tr");
        row.innerHTML = `
          <td>${term.item_name}</td>
          <td>—</td>
          <td>${term.unit}</td>
          <td>${term.quantity}</td>
          <td>${formatCurrency(term.price)}</td>
          <td>${formatCurrency(term.total)}</td>
          <td>${term.notes}</td>
        `;

        // ✅ عند الضغط على صف البند → تعبئة النموذج للتعديل
        row.addEventListener("click", () => {
          fillItemForm(term, PID);
           window.scrollBy({ top: 500, left: 0, behavior: 'smooth' });
        });

        tbody.appendChild(row);
      });
    })
    .catch(err => {
      console.error("❌ خطأ في الاتصال:", err);
      alert("❌ فشل الاتصال بالسيرفر");
    });
}

function fillItemForm(term, PID) {
  const form = document.getElementById("add-item-form");
  if (!form) return;

  const setVal = (selector, val) => {
    const el = form.querySelector(selector);
    if (el) el.value = val || "";
  };

  setVal('[name="item_name"]', term.item_name);
  setVal('[name="unit"]', term.unit);
  setVal('[name="quantity"]', term.quantity);
  setVal('[name="price"]', term.price);
  setVal('[name="total"]', term.total);
  setVal('[name="notes"]', term.notes);

  // ✅ حفظ معرف المشروع
  const hiddenProjectId = document.getElementById("project-id-hidden2nd");
  if (hiddenProjectId) hiddenProjectId.value = PID;

  // ✅ حفظ معرف البند في العنصر المخفي
  const itemIdInput = document.getElementById("item-id-hidden");
  if (itemIdInput) itemIdInput.value = term.id || "0";

  editingItemId = term.id || null;

  // ✅ إظهار القسم
  document.getElementById("add-item-section").style.display = "block";

  // ✅ إظهار زر الحذف
  const deleteBtn = document.getElementById("BTNDeleteItem");
  if (deleteBtn) deleteBtn.style.display = "block";

  // ✅ تغيير العنوان
  document.querySelector("#add-item-section h2").innerHTML =
    `<i class="fas fa-file-circle-plus" aria-hidden="true"></i> تعديل بند`;

  // ✅ تغيير زر الحفظ
  const saveBtn = document.getElementById("btnSaveItem");
  if (saveBtn) {
    const icon = saveBtn.querySelector("i");
    const tooltip = saveBtn.querySelector(".tooltip");

    saveBtn.setAttribute("aria-label", "تعديل البند");
    if (icon) icon.className = "fas fa-edit";
    if (tooltip) tooltip.textContent = "تعديل";
  }
}


function resetItemForm() {
  const form = document.getElementById("add-item-form");
  if (form) form.reset();

  editingItemId = null;

  const hiddenProjectId = document.getElementById("project-id-hidden2nd");
  if (hiddenProjectId) hiddenProjectId.value = "0";

  document.querySelector("#add-item-section h2").innerHTML =
    `<i class="fas fa-file-circle-plus" aria-hidden="true"></i> إضافة بند`;

  const saveBtn = document.getElementById("btnSaveItem");
  if (saveBtn) {
    const icon = saveBtn.querySelector("i");
    const tooltip = saveBtn.querySelector(".tooltip");

    saveBtn.setAttribute("aria-label", "حفظ البند");
    if (icon) icon.className = "fas fa-save";
    if (tooltip) tooltip.textContent = "حفظ";
  }

  const deleteBtn = document.getElementById("BTNDeleteItem");
  if (deleteBtn) deleteBtn.style.display = "none";

  const msgBox = document.getElementById("responseMsg");
  if (msgBox) {
    msgBox.textContent = "";
    msgBox.style.display = "none";
  }
}

// ✅ ترجمة حالة المشروع



// ✅ تنسيق العملةةmostafa
function formatCurrency(value) {
  const number = parseFloat(value).toLocaleString("en-US", {
    minimumFractionDigits: 2,
    maximumFractionDigits: 2
  });
  return `${number} ريال`;
}





//add Item 
async function saveItem() {
  const form = document.getElementById("add-item-form");
  if (!form) return alert("❌ نموذج البند غير موجود");

  const saveBtn = document.getElementById("btnSaveItem");
  const deleteBtn = document.getElementById("BTNDeleteItem");

  // تحديد هل العملية تعديل أم إضافة بناءً على ظهور زر الحذف
  const isEditMode = deleteBtn && getComputedStyle(deleteBtn).display !== "none";

  // تجميع البيانات من النموذج
  const formData = new FormData(form);
  const data = {};
  formData.forEach((val, key) => data[key] = val.trim());

  // التحقق من الحقول المطلوبة
  if (!data.item_name) {
    const msgBox = document.getElementById("responseMsg");
    if (msgBox) {
      msgBox.textContent = "⚠️ برجاء إدخال اسم البند";
      msgBox.style.color = "red";
      msgBox.style.display = "block";
      setTimeout(() => msgBox.style.opacity = "0", 4500);
      setTimeout(() => {
        msgBox.style.display = "none";
        msgBox.style.opacity = "1";
      }, 5000);
    }
    return;
  }

  // حساب الإجمالي تلقائيًا
  const quantity = parseFloat(data.quantity) || 0;
  const price = parseFloat(data.price) || 0;
  data.total = quantity * price;

  // تحديد المسار حسب الوضع
  let endpoint = "save_item.php";
  if (isEditMode) {
    const IID = parseInt(document.getElementById("item-id-hidden")?.value || "0");
    if (!IID) return alert("❌ لا يمكن تعديل بند بدون معرف صالح");
    data.id = IID;
    endpoint = "update_item.php";
  }

  try {
    const res = await fetch(endpoint, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      },
      body: JSON.stringify(data)
    });

    const json = await res.json();
    const msgBox = document.getElementById("responseMsg");
    if (msgBox) {
      msgBox.textContent = json.message || "✅ العملية تمت";
      msgBox.style.color = json.status === "success" ? "green" : "red";
      msgBox.style.display = "block";
      setTimeout(() => msgBox.style.opacity = "0", 4500);
      setTimeout(() => {
        msgBox.style.display = "none";
        msgBox.style.opacity = "1";
      }, 5000);
    }

    if (json.status === "success") {
      form.reset();
      document.getElementById("item-id-hidden").value = "0";
   
     

      if (deleteBtn) deleteBtn.style.display = "none";

      if (saveBtn) {
        const icon = saveBtn.querySelector("i");
        const tooltip = saveBtn.querySelector(".tooltip");
        saveBtn.setAttribute("aria-label", "حفظ");
        if (icon) icon.className = "fas fa-save";
        if (tooltip) tooltip.textContent = "حفظ";
      }

      if (typeof showProjectDetails === "function") showProjectDetails();
    }

  } catch (err) {
    console.error("❌ خطأ في الاتصال:", err);
    alert("❌ فشل الاتصال بالسيرفر");
  }
}

// ربط الزر بالدالة بعد تحميل الصفحة
document.addEventListener("DOMContentLoaded", () => {
  const saveBtn = document.getElementById("btnSaveItem");
  if (saveBtn) saveBtn.addEventListener("click", saveItem);
});







//PDF
document.addEventListener("DOMContentLoaded", () => {
  const selectPdfBtn = document.getElementById("selectPdfBtn");
  const fileInput = document.getElementById("pdfFileInput");
  const attachmentField = document.getElementById("AttachmentPath");
  const msg = document.getElementById("projectMsg");

  // عند الضغط على زر اختيار الملف
  selectPdfBtn.addEventListener("click", () => {
    fileInput.click();
  });

  // عند اختيار ملف PDF
  fileInput.addEventListener("change", () => {
    const file = fileInput.files[0];
    if (!file) return;

    const formData = new FormData();
    formData.append("pdfFile", file);

    fetch("upload_pdf.php", {
      method: "POST",
      body: formData
    })
    .then(res => res.json())
    .then(data => {
      if (data.status === "success") {
        const fullPath = data.path; // مثال: DocumentPDF/contract123.pdf
        attachmentField.value = fullPath;

        msg.textContent = `✅ تم رفع الملف: ${file.name}`;
        msg.style.color = "green";
        msg.style.display = "block";

        setTimeout(() => {
          msg.style.display = "none";
        }, 5000);
      } else {
        msg.textContent = `❌ فشل رفع الملف: ${data.message}`;
        msg.style.color = "red";
        msg.style.display = "block";
      }
    })
    .catch(err => {
      console.error("❌ خطأ في رفع الملف:", err);
      alert("❌ فشل الاتصال بالسيرفر");
    });
  });
});



function openPdfFromInput() {
  const input = document.getElementById("AttachmentPath_fullDe");
  const fileName = input.value.trim();

  if (!fileName) {
    alert("⚠️ لازم تدخل اسم الملف");
    return;
  }

  const currentPath = window.location.pathname;
  const folderPath = currentPath.substring(0, currentPath.lastIndexOf("/"));
  const fullURL = `${window.location.origin}${folderPath}/${fileName}`;

  console.log("📂 الرابط النهائي:", fullURL);
  window.open(fullURL, "_blank");
}





function toggleAddProject() {

    const AllProject = document.getElementById('all-projects');
    AllProject.style.display = 'none';


  const addItemSection = document.getElementById('add-item-section');
  const addProjectSection = document.getElementById('add-project-section');
  const projectDetails = document.getElementById('project-details');
  const selectedProjectText = document.getElementById('selected-project-text');


  if (addProjectSection) {
    // Toggle project section
    if (addProjectSection.style.display === 'block') {
      addProjectSection.style.display = 'none';
    } else {
      addProjectSection.style.display = 'block';
    }
  }

  // Hide other sections
  if (projectDetails) projectDetails.style.display = 'none';
  if (addItemSection) addItemSection.style.display = 'none';
  
  // Reset selection text
  if (selectedProjectText) selectedProjectText.textContent = "اختر المشروع...";

  window.scrollBy({ top: 160, left: 0, behavior: 'smooth' });
}

//update and add


async function saveProject() {
  const form = document.getElementById("add-project-form");
  if (!form) return alert("❌ النموذج غير موجود");

  const saveBtn = document.getElementById("save-project-btn");
  const deleteBtn = document.getElementById("BTNDelete");

  // تحديد هل العملية تعديل أم إضافة بناءً على ظهور زر الحذف
  const isEditMode = deleteBtn && getComputedStyle(deleteBtn).display !== "none";

  // تجميع البيانات من النموذج
  const formData = new FormData(form);
  const data = {};
  formData.forEach((val, key) => data[key] = val.trim());

  // التحقق من الحقول المطلوبة
  const required = [
    "project_name",
    "project_owner",
    "project_status",
    "project_location",
    "project_cost",
    "project_duration"
  ];
  for (const key of required) {
    if (!data[key]) {
      alert("⚠️ برجاء استكمال جميع بيانات المشروع");
      return;
    }
  }

  // تحديد المسار والبيانات حسب الوضع
  let endpoint = "save_project.php";
  if (isEditMode) {
     AllProject();
    setActiveNavIconS(this);
    const PID = parseInt(document.getElementById("project-id-hidden")?.value || "0");
    if (!PID) return alert("❌ لا يمكن تعديل مشروع بدون معرف صالح");
    data.id = PID;
    endpoint = "update_project.php";
  } else {
   AllProject();
    setActiveNavIconS(this);
  }

  try {
    const res = await fetch(endpoint, {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        "Accept": "application/json"
      },
      body: JSON.stringify(data)
    });

    const json = await res.json();
    alert(json.message || "✅ العملية تمت");

    // عرض الرسالة في div
    const msgBox = document.getElementById("projectMsg");
    if (msgBox) {
      msgBox.textContent = json.message || "✅ العملية تمت";
      msgBox.style.color = json.status === "success" ? "green" : "red";
      msgBox.style.display = "block";

      setTimeout(() => msgBox.style.opacity = "0", 4500);
      setTimeout(() => {
        msgBox.style.display = "none";
        msgBox.style.opacity = "1";
      }, 5000);
    }

    if (json.status === "success") {
      form.reset();
      document.getElementById("project-id-hidden").value = "0";
      document.getElementById("selected-project-text").innerText = "---";
      document.getElementById("selected-project-id").innerText = "---";

      if (deleteBtn) deleteBtn.style.display = "none";

      if (saveBtn) {
        const icon = saveBtn.querySelector("i");
        const tooltip = saveBtn.querySelector(".tooltip");
        saveBtn.setAttribute("aria-label", "حفظ");
        if (icon) icon.className = "fas fa-save";
        if (tooltip) tooltip.textContent = "حفظ";
      }

      if (typeof loadProjects === "function") loadProjects();
    }

  } catch (err) {
    console.error("❌ خطأ في الاتصال:", err);
    alert("❌ فشل الاتصال بالسيرفر");
  }
}

// ربط الزر بالدالة بعد تحميل الصفحة
document.addEventListener("DOMContentLoaded", () => {
  const saveBtn = document.getElementById("save-project-btn");
  if (saveBtn) saveBtn.addEventListener("click", saveProject);
});


function showMessage(msg, type = "info", responseMsg = "fund-message") {
    const msgDiv = document.getElementById(responseMsg);
    if (!msgDiv) return;

    msgDiv.textContent = msg;
    msgDiv.style.display = "block";
    msgDiv.style.backgroundColor = type === "success" ? "#d4edda" :
                                   type === "error"   ? "#f8d7da" : "#fff3cd";
    msgDiv.style.color = type === "success" ? "#155724" :
                         type === "error"   ? "#721c24" : "#856404";

    // إخفاء الرسالة بعد 5 ثواني
    setTimeout(() => {
        msgDiv.style.display = "none";
    }, 5000);
}




//delete

function deleteProject() {
  const projectId = parseInt(document.getElementById("project-id-hidden")?.value || "0");

  if (!projectId) {
    alert("⚠️ لا يوجد مشروع محدد للحذف");
    return;
  }

  if (!confirm("هل أنت متأكد أنك تريد حذف هذا المشروع؟")) return;

  fetch("delete_project.php", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      "Accept": "application/json"
    },
    body: JSON.stringify({ id: projectId })
  })
  .then(res => res.json())
  .then(result => {
    alert(result.message);
    if (result.status === "success") {
      document.getElementById("add-project-form").reset();
      document.getElementById("project-id-hidden").value = "0";
      document.getElementById("selected-project-text").innerText = "---";
      document.getElementById("selected-project-id").innerText = "---";
      document.getElementById("BTNDelete").style.display = "none";
      document.getElementById("add-project-section").style.display = "none";
      document.getElementById("all-projects").style.display = "block";
      if (typeof loadProjects === "function") loadProjects();
    }
  })
  .catch(err => {
    console.error("❌ خطأ أثناء حذف المشروع:", err);
    alert("❌ حدث خطأ أثناء عملية الحذف");
  });
}


//Delete Item

function deleteItem() {
  const itemId = parseInt(document.getElementById("item-id-hidden")?.value || "0");

  if (!itemId) {
    alert("⚠️ لا يوجد بند محدد للحذف");
    return;
  }

  if (!confirm("هل أنت متأكد أنك تريد حذف هذا البند؟")) return;

  fetch("delete_item.php", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      "Accept": "application/json"
    },
    body: JSON.stringify({ id: itemId })
  })
  .then(res => res.json())
  .then(result => {
    alert(result.message);
    if (result.status === "success") {
      document.getElementById("add-item-form").reset();
      document.getElementById("item-id-hidden").value = "0";
      document.getElementById("BTNDeleteItem").style.display = "none";
      document.getElementById("add-item-section").style.display = "none";
      document.getElementById("project-details").style.display = "block";
       resetItemForm();
      if (typeof showProjectDetails === "function") showProjectDetails();
    }
  })
  .catch(err => {
    console.error("❌ خطأ أثناء حذف البند:", err);
    alert("❌ حدث خطأ أثناء عملية الحذف");
  });
}



//aouo call
document.addEventListener("DOMContentLoaded", () => {
  const quantityInput = document.querySelector("input[name='quantity']");
  const priceInput = document.querySelector("input[name='price']");
  const totalInput = document.querySelector("input[name='total']");

  function updateTotalOnUserInput() {
    const quantity = parseFloat(quantityInput.value) || 0;
    const price = parseFloat(priceInput.value) || 0;
    totalInput.value = quantity * price;
  }

  if (quantityInput) {
    quantityInput.addEventListener("input", updateTotalOnUserInput);
    quantityInput.addEventListener("change", updateTotalOnUserInput);
  }

  if (priceInput) {
    priceInput.addEventListener("input", updateTotalOnUserInput);
    priceInput.addEventListener("change", updateTotalOnUserInput);
  }
});

