<?php
session_start(); // مهم لتخزين بيانات الجلسة

header("Content-Type: application/json; charset=UTF-8");
require_once "db.php"; // الاتصال بقاعدة البيانات

try {
    // قراءة بيانات JSON المرسلة عبر AJAX
    $input = json_decode(file_get_contents("php://input"), true);

    if (!$input || !isset($input['mobile']) || !isset($input['password'])) {
        echo json_encode(["success" => false, "message" => "يرجى إدخال رقم الجوال وكلمة المرور"]);
        exit;
    }

    $mobile = mysqli_real_escape_string($conn, $input['mobile']);
    $password = $input['password'];

    // البحث عن المستخدم في قاعدة البيانات
    $sql = "SELECT * FROM USEUSERSMH WHERE mobile = '$mobile' LIMIT 1";
    $result = mysqli_query($conn, $sql);

    if (!$result || mysqli_num_rows($result) == 0) {
        echo json_encode(["success" => false, "message" => "رقم الجوال غير موجود"]);
        exit;
    }

    $user = mysqli_fetch_assoc($result);

    // تحقق من كلمة المرور
    if (!password_verify($password, $user['password'])) {
        echo json_encode(["success" => false, "message" => "كلمة المرور غير صحيحة"]);
        exit;
    }

    // تحديث حالة المستخدم لتكون "نشط"
    $update = "UPDATE USEUSERSMH SET status = 'نشط' WHERE id = ".$user['id'];
    mysqli_query($conn, $update);

    // تخزين بيانات الجلسة
    $_SESSION['UID'] = $user['id'];
    $_SESSION['username'] = $user['username'];
    $_SESSION['usertype'] = $user['user_type'];
    $_SESSION['mobile'] = $user['mobile'];
    $_SESSION['email'] = $user['email'];

    // تسجيل الدخول ناجح
    echo json_encode([
        "success" => true,
        "message" => "تم تسجيل الدخول بنجاح",
        "user" => [
            "id" => $user['id'],
            "username" => $user['username'],
            "mobile" => $user['mobile'],
            "email" => $user['email'],
            "user_type" => $user['user_type'],
            "status" => "نشط"
        ]
    ]);

} catch(Exception $e) {
    echo json_encode(["success" => false, "message" => "حدث خطأ أثناء تسجيل الدخول: " . $e->getMessage()]);
}
?>
