<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
 <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">

  <meta name="theme-color" content="#ffffff">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="apple-mobile-web-app-status-bar-style" content="default">
  <title>MADAD HOLDING Management System</title>

  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
  <link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">


</head>
<body>

<!-- تحذير الوضع العمودي -->
<div id="landscape-warning" style="display:none;">
  <i class="fas fa-mobile-alt"></i>
  <i class="fas fa-sync-alt rotate-icon"></i>
  <p>يرجى تدوير الجهاز للوضع الأفقي لعرض أفضل</p>
</div>

<style>
#landscape-warning {
  position: fixed; top:0; left:0; width:100%; height:100%;
  background: rgba(0,0,0,0.85); color:white;
  display:flex; flex-direction: column; align-items:center; justify-content:center;
  font-family: sans-serif; text-align:center; padding:20px; z-index:9999;
  animation: fadeIn 0.3s ease;
}
#landscape-warning i { font-size:60px; margin-bottom:15px; }
#landscape-warning .rotate-icon { font-size:40px; margin-top:10px; animation: rotateAnim 2s infinite linear; }
@keyframes rotateAnim { from{transform:rotate(0deg);} to{transform:rotate(360deg);} }
@keyframes fadeIn { from{opacity:0;} to{opacity:1;} }
</style>

<script>
function checkOrientation() {
  const warning = document.getElementById("landscape-warning");
  if (window.innerHeight > window.innerWidth) {
    warning.style.display = "flex";
  } else {
    warning.style.display = "none";
  }
}
window.addEventListener("resize", checkOrientation);
window.addEventListener("load", checkOrientation);
</script>

<!-- Header -->
<header class="header" style="display:flex; justify-content:center; align-items:center; height:100px;">
  <div class="logo-container">
    <img src="MADADHOLDING.jpeg" alt="MADAD HOLDING" style="width:201px; height:auto;" />
  </div>
</header>

<main class="main-content">
  <br><br><br>
  <section id="login-section" class="projects-container">
    <div style="display: flex; align-items: center; justify-content: space-between;">
      <h2 class="section-title" style="margin:0; display:flex; align-items:center; gap:8px;">
        <i class="fas fa-lock"></i> تسجيل الدخول
      </h2>
    </div>

<form id="login-form" style="margin-top:15px; display:flex; align-items:center; gap:10px; direction:rtl;">
  <!-- رقم الجوال -->
  <div class="form-field" style="flex:1;">
    <i class="fas fa-mobile-alt icon-secondary"  style="position:absolute;"></i>
    <input type="tel" name="mobile" placeholder="رقم الجوال" required autocomplete="tel"
           pattern="[0-9]{11}" style="padding-right:40px; padding-left:40px; width:100%; direction:rtl;">
  </div>

  <!-- كلمة المرور -->
  <div class="form-field" style="flex:1; position:relative;">
    <i class="fas fa-key icon-secondary" style="color:#A19A87; position:absolute; right:10px; top:50%; transform:translateY(-50%);"></i>
    <input type="password" id="password" name="password" placeholder="كلمة المرور"
           required autocomplete="current-password"
           style="padding-right:40px; padding-left:40px; width:100%; direction:rtl;">
    <i id="togglePassword" class="fas fa-eye" style="position:absolute; left:10px; top:50%; transform:translateY(-50%);
        cursor:pointer; color:#A19A87;"></i>
  </div>

  <!-- زر تسجيل الدخول -->
  <div class="nav-icon" tabindex="0" role="button" style="width:50px;  cursor:pointer;" aria-label="تسجيل الدخول" onclick="loginUser()">
    <i class="fas fa-sign-in-alt"></i>
    <span class="tooltip">تسجيل الدخول</span>
  </div>
</form>

<!-- رسالة تسجيل الدخول -->
<div id="messageBox" style="margin-top:10px; padding:10px; border-radius:5px; display:none;"></div>

  </section>
  
</main>

<button id="scrollTopBtn" class="fas fa-arrow-up" onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>

<footer class="site-footer">
  <div class="footer-container">
    <p>
      <span class="footer-symbol">©</span>
      <span id="currentYear"></span>
      جميع الحقوق محفوظة لشركة مداد القابضة
    </p>
  </div>
</footer>

<script>
document.getElementById('currentYear').textContent = new Date().getFullYear();

// Toggle Password
if (!window.togglePasswordDefined) {
    const togglePassword = document.getElementById("togglePassword");
    const passwordInput = document.getElementById("password");
    togglePassword.addEventListener("click", () => {
        const isPassword = passwordInput.type === "password";
        passwordInput.type = isPassword ? "text" : "password";
        togglePassword.classList.toggle("fa-eye");
        togglePassword.classList.toggle("fa-eye-slash");
    });
    window.togglePasswordDefined = true;
}

// Enter key login
document.getElementById("login-form").addEventListener("keydown", function(e) {
    if (e.key === "Enter") {
        e.preventDefault();
        loginUser();
    }
});

// حماية الموقع
document.addEventListener('selectstart', e=>e.preventDefault());
document.addEventListener('contextmenu', e=>e.preventDefault());
document.addEventListener('dragstart', e=>e.preventDefault());
window.addEventListener('keydown', function(e){
    if (e.ctrlKey && ['s','u','p','c','x','a'].includes(e.key.toLowerCase())) { e.preventDefault(); alert("❌ هذا الاختصار معطل"); }
    if (e.key==='F12') { e.preventDefault(); alert("❌ أدوات المطور معطلة"); }
    if (e.ctrlKey && e.shiftKey && ['i','j'].includes(e.key.toLowerCase())) { e.preventDefault(); alert("❌ أدوات المطور معطلة"); }
}, true);
</script>



<script src="LoginAjax.js" defer></script>
<script src="script.js" defer></script>
</body>
</html>
