
function loadStats() {
  fetch('getStats.php')
    .then(res => res.json())
    .then(data => {
      // تحديث الإحصائيات المالية
      document.getElementById('fund-value').textContent = data.fund;
      document.getElementById('balance-value').textContent = data.balance;
      document.getElementById('revenues-value').textContent = data.revenues;
      document.getElementById('expenses-value').textContent = data.expenses;
      document.getElementById('profits-value').textContent = data.profits;
      document.getElementById('profits-percentage').innerHTML = data.profits_percentage;
      document.getElementById('custody-value').textContent = data.custody;

      // تحديث المشاريع النشطة
      const grid = document.getElementById('projects-grid');
      grid.innerHTML = ''; // مسح المشاريع القديمة

      data.projects.forEach(project => {
        const card = document.createElement('div');
        card.className = 'project-card';
        card.style.cursor = 'pointer';
        card.setAttribute('tabindex', '0');
        card.setAttribute('role', 'button');
        card.setAttribute('aria-label', project.project_name);

        card.innerHTML = `
          <h4 class="project-title">
            <i class="fas fa-building" aria-hidden="true"></i>
            ${project.project_name}
            <div class="project-status">${project.project_status}</div>
          </h4>
        `;

        card.addEventListener('click', () => {
          window.location.href = `projects.php?id=${project.id}`;
        });

        grid.appendChild(card);
      });
    })
    .catch(err => {
      console.error('❌ خطأ في تحميل البيانات:', err);
    });
}

// تحميل أول مرة
loadStats();

// تحديث كل 5 ثواني
setInterval(loadStats, 5000);





//proje

// تحميل المشاريع من قاعدة البيانات
fetch('get_projects.php')
  .then(async res => {
    const text = await res.text();

    try {
      const data = JSON.parse(text);

      // لو السيرفر رجّع خطأ داخل JSON
      if (data.error) {
        throw new Error(data.error);
      }

      const select = document.getElementById('selected-project');
      select.innerHTML = '<option value="All" >  المشاريع </option>';

      data.forEach(project => {
        const option = document.createElement('option');
        option.value = project.id;
        option.textContent = project.name;
        select.appendChild(option);
      });
    } catch (err) {
      console.error("❌ فشل تحويل البيانات إلى JSON:", err.message);
      console.log("🔍 الرد من السيرفر كان:", text);
    }
  })
  .catch(error => {
    console.error("❌ فشل تحميل المشاريع:", error.message);
  });



document.querySelectorAll('.time-btn').forEach(btn => {
  btn.addEventListener('click', () => {
    // إزالة الكلاس من الكل
    document.querySelectorAll('.time-btn').forEach(b => b.classList.remove('active'));
    // إضافة الكلاس للزر الحالي
    btn.classList.add('active');

    // جلب المشروع المختار
    const projectId = document.getElementById("selected-project").value;
    const projectName = document.getElementById("selected-project-text").textContent;

    // إعادة تحميل البيانات حسب الفلتر الجديد
    selectProject(projectId, projectName);
  });
});





