<?php
session_start();
if (!isset($_SESSION['username']) || !isset($_SESSION['usertype'])) {
    header("Location: Login.php");
    exit();
}
?>


<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=1024, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <!-- ألوان شريط الحالة للـ Android -->
<meta name="theme-color" content="#ffffff">
<!-- للـ iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
  <title>MADAD HOLDING Management System</title>
  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
<link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">
  <!-- Chart.js with 3D plugin -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-3d@latest/dist/chartjs-plugin-3d.min.js"></script>

  <script src="https://cdn.jsdelivr.net/npm/vanilla-tilt@1.7.0/dist/vanilla-tilt.min.js"></script>
  
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">



  <script src="Chartscript.js"></script>
</head>
<body>

  <!-- Header -->
<?php include 'header.php'; ?>



  <!-- Main Content -->
  <main class="main-content" role="main">

  
   <section class="projects-stats-section" aria-label="قسم المشاريع والإحصائيات">
  <!-- Projects -->
  <article class="projects-container" tabindex="0" aria-label="المشاريع النشطة"onclick="window.location.href='projects.php'" style=" max-height: 470px;overflow-y: auto;" >
    <h2 class="section-title">
      <i class="fas fa-city" aria-hidden="true"></i>
      المشاريع النشطة
    </h2>

    
    <div class="projects-grid" id="projects-grid" >
      <!-- سيتم تحميل المشاريع هنا بـ AJAX -->
    </div>
  </article>

  <!-- Stats -->
  <aside class="stats-grid" aria-label="الإحصائيات المالية">
    <div class="stat-card" data-type="fund"   onclick="window.location.href='fund.php'">
      
      <h4 class="stat-title"><i class="fas fa-chart-line"></i> راس المال</h4>
      <div class="stat-value" id="fund-value">...</div>
    </div>

    <div class="stat-card" data-type="balance"onclick="window.location.href='Balance.php'">
      <h4 class="stat-title"><i class="fas fa-wallet"></i> الرصيد الحالي</h4>
      <div class="stat-value" id="balance-value">...</div>
    </div>

    <div class="stat-card" data-type="revenues"  onclick="window.location.href='revenues.php'">
      <h4 class="stat-title"><i class="fas fa-money-bill-wave"></i> الإيرادات</h4>
      <div class="stat-value" id="revenues-value">...</div>
    </div>

    <div class="stat-card" data-type="expenses" onclick="window.location.href='expenses.php'">
      <h4 class="stat-title"><i class="fas fa-receipt"></i> المصروفات</h4>
      <div class="stat-value" id="expenses-value">...</div>
    </div>

    <div class="stat-card" data-type="profits" onclick="window.location.href='profits.php'">
      <h4 class="stat-title"><i class="fas fa-coins"></i> الأرباح</h4>
      <div class="stat-value" id="profits-value">...</div>
      <div class="stat-percentage positive" id="profits-percentage">...</div>
    </div>

    <div class="stat-card" data-type="custody" onclick="window.location.href='custody.php'">
      <h4 class="stat-title"><i class="fas fa-sack-dollar"></i> العُهدة</h4>
      <div class="stat-value" id="custody-value">...</div>
    </div>
  </aside>
</section>


    <!-- Chart Section -->
    <section class="chart-container" aria-label="قسم الرسم البياني" dir="rtl">
      <div class="chart-header">
        <h3 class="chart-title">
          <i class="fas fa-chart-line icon-primary"></i>
           التحليل المالي
        </h3>

        <!-- Project Selector -->
         <div class="form-field" >
        <i class="fas fa-building icon-secondary"></i>
       
          <select id="selected-project" onchange="handleProjectChange(this)" required  >

          <option value="All" >  المشاريع </option>
        </select>
      </div>
    </div>


   <div class="selected-info">

   <p hidden>اسم المشروع: <span id="selected-project-text">---</span></p>
<p hidden>رقم المشروع (ID): <span id="selected-project-id">---</span></p>

<!-- تجربة عرض الـ ID في input -->
<input type="hidden" value="0" id="project-id-hidden" name="project_id">
</div>

        <!-- Chart Controls -->
        <div class="chart-controls" >
          <!-- Chart Type -->
         

          <!-- Time Filter -->
        <div class="time-btn-group" role="group" aria-label="اختيار الفترة الزمنية">
  <button class="time-btn" data-range="week"><i class="fas fa-calendar-week"></i> أسبوع </button>
  <button class="time-btn" data-range="month"><i class="fas fa-calendar-alt"></i> شهر </button>
  <button class="time-btn" data-range="year"><i class="fas fa-calendar"></i> سنة </button>
  <button class="time-btn" id="custom-btn" data-range="custom"><i class="fas fa-calendar-day"></i> مخصص </button>
  <button class="time-btn" data-range="all"><i class="fas fa-infinity"></i> الكل </button>
</div>

<!-- Div التاريخ المخصص -->
<div id="custom-date-container" style="display: none; margin-top: 10px; gap: 10px; display: flex;">
  <!-- حقل من -->
  <div style="position: relative; flex: 1;">
    <input type="date" id="custom-from" class="custom-date-input">
    <i class="fas fa-arrow-right-from-bracket" 
       style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #A19A87; pointer-events: none;"
       title="من"></i><span class="tooltip" role="tooltip"> </span>
  </div>

  <!-- حقل إلى -->
  <div style="position: relative; flex: 1;">
    <input type="date" id="custom-to" class="custom-date-input">
    <i class="fas fa-arrow-right-to-bracket" 
       style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #A19A87; pointer-events: none;"
       title="إلى"></i> 
  </div>
</div>











        </div>
      </div>

      <!-- Chart -->
      <div class="chart-placeholder" >
        <div class="chart-loader">
          <div class="loader"></div>
          <p>جاري تحميل البيانات...</p>
        </div>
        <canvas id="financialChart"></canvas>



      </div>
    </section>
  </main>



<script>
  const customBtn = document.getElementById('custom-btn');
  const customContainer = document.getElementById('custom-date-container');
  const fromInput = document.getElementById('custom-from');
  const toInput = document.getElementById('custom-to');
  const timeButtons = document.querySelectorAll('.time-btn');

  // إظهار/إخفاء div عند الضغط على مخصص
  customBtn.addEventListener('click', () => {
    customContainer.style.display = customContainer.style.display === 'none' ? 'flex' : 'none';
    setActiveButton(customBtn);
  });

  // إخفاء div عند اختيار أي زر آخر
  function hideCustomDiv() {
    customContainer.style.display = 'none';
  }

  // تنفيذ الدالة مباشرة عند اختيار أي تاريخ
  function applyCustomDate() {
    const fromDate = fromInput.value;
    const toDate = toInput.value;

    if (!fromDate || !toDate) return;

    console.log('تم اختيار التاريخ المخصص:', fromDate, 'إلى', toDate);

    // هنا ضع دالتك لتنفيذ الفلترة أو أي عملية
    // مثال: filterDataByDate(fromDate, toDate);
  }

  fromInput.addEventListener('change', applyCustomDate);
  toInput.addEventListener('change', applyCustomDate);

  // لتحديد الزر النشط
  function setActiveButton(btn) {
    timeButtons.forEach(b => b.classList.remove('active'));
    btn.classList.add('active');
  }

  // تعيين الأسبوع كزر افتراضي عند تحميل الصفحة
  window.addEventListener('DOMContentLoaded', () => {
    setActiveButton(timeButtons[0]); // الأسبوع
    customContainer.style.display = 'none'; // تأكيد الإخفاء
  });
</script>

  <!-- Scroll Top Button -->
  <button id="scrollTopBtn" class="fas fa-arrow-up"
          onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>



          <?php
session_start();
$UID = isset($_SESSION['UID']) ? $_SESSION['UID'] : '';
$username = isset($_SESSION['username']) ? $_SESSION['username'] : '';
$usertype = isset($_SESSION['usertype']) ? $_SESSION['usertype'] : '';
?>


<!-- Home.php -->




<?php
session_start();
include 'footer.php';
?>

  <!-- Scripts -->
  <script>
    document.getElementById('currentYear').textContent = new Date().getFullYear();
  </script>
<script>
// منع تحديد النصوص
document.addEventListener('selectstart', function (e) {
    e.preventDefault();
}, false);

// منع الكليك يمين
document.addEventListener('contextmenu', function (e) {
    e.preventDefault();
}, false);

// منع السحب
document.addEventListener('dragstart', function (e) {
    e.preventDefault();
}, false);

// منع الحفظ وأوامر المطور
window.addEventListener('keydown', function (e) {
    // اختصارات Ctrl + (S, U, P, C, X, A)
    if (e.ctrlKey && ['s', 'u', 'p', 'c', 'x', 'a'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ هذا الاختصار معطل على هذا الموقع");
    }
    // منع F12
    if (e.key === 'F12') {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
    // منع Ctrl+Shift+I و Ctrl+Shift+J
    if (e.ctrlKey && e.shiftKey && ['i', 'j'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
}, true); // capture mode
</script>





    <script src="HomeAjax.js"></script>
   <script>
  window.addEventListener('DOMContentLoaded', () => {
    const defaultProjectId = 'All';
    const defaultProjectName = 'المشاريع';
    selectProject(defaultProjectId, defaultProjectName);
  });
</script>

  <script src="script.js"></script>
</body>
</html>