let chart;

function selectProject(projectId, projectName) {
  // تحديث النص في اختيار المشروع العلوي
  document.getElementById("selected-project-text").textContent = projectName;
  document.getElementById("selected-project").value = projectId;

  // عرض الجدول
  document.getElementById("profits-section").style.display = "block";

  // عرض الرسم البياني
  document.getElementById("chart-section").style.display = "block";

  // تحديث البيانات
  updateChart([8000, 3000, 5000]); // [إيرادات, مصروفات, ربح]
}

function updateChart(data) {
  const ctx = document.getElementById('financialChart').getContext('2d');
  
  if (chart) {
    chart.destroy();
  }

  chart = new Chart(ctx, {
    type: 'bar',
    data: {
      labels: ['الإيرادات', 'المصروفات', 'الربح'],
      datasets: [{
        label: 'القيمة بالريال',
        data: data,
        backgroundColor: [
          'rgba(72, 94, 71, 0.7)',   // الإيرادات - primary
    'rgba(161, 154, 135, 0.7)', // المصروفات - secondary
    'rgba(51, 51, 51, 0.7)'     // الربح - dark-gray
        ],
        borderWidth: 1
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { display: false }
      },
      scales: {
        y: { beginAtZero: true }
      }
    }
  });
}
