<?php
session_start();
if (!isset($_SESSION['username']) || !isset($_SESSION['usertype'])) {
    header("Location: Login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
   <meta name="viewport" content="width=1024, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <!-- ألوان شريط الحالة للـ Android -->
<meta name="theme-color" content="#ffffff">
<!-- للـ iOS -->
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
<title>MADAD HOLDING Management System</title>
  
    <script>
  
</script>

  <!-- CSS -->
  <link rel="stylesheet" href="style.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
 <link rel="icon" type="image/png" href="MADADHOLDINGTrans.png">
  <!-- Chart.js with 3D plugin -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-3d@latest/dist/chartjs-plugin-3d.min.js"></script>











</head>
<body>

 <!-- Header -->
<?php include 'header.php'; ?>


  <!-- Main Content -->
  <main class="main-content" role="main">

  <section class="projects-container" aria-label="الرصيد">
   <div class="section-header" style="display: flex; align-items: center; justify-content: space-between;">
    
    <!-- العنوان -->
    <h2 class="section-title" style="display: flex; align-items: center; gap: 8px; margin: 0;">
      <i class="fas fa-wallet" aria-hidden="true"></i>
      الرصيد
    </h2>

    <!-- الأيقونات -->
    <div style="display: flex; align-items: center; gap: 10px;">
      
      <!-- إضافة رصيد -->
      <div class="navS-icon" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;"
           aria-label="إضافة رصيد" 
           onclick="toggleAddBalance(); setActiveNavIconS(this)">
        <i class="fas fa-plus-circle"></i>
        <span class="tooltip" role="tooltip">إضافة الرصيد</span>
      </div>

      <!-- خصم رصيد -->
      <div class="navS-icon" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;"
           aria-label="خصم رصيد" 
           onclick="toggleDeductBalance(); setActiveNavIconS(this)" hidden>
        <i class="fas fa-minus-circle"></i>
        <span class="tooltip" role="tooltip">خصم رصيد</span>
      </div>

      <!-- عرض الرصيد (active) -->
      <div class="navS-icon active" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="عرض الرصيد" 
           onclick="toggleBalanceView(); setActiveNavIconS(this)">
        <i class="fas fa-list"></i>
        <span class="tooltip" role="tooltip">الرصيد</span>
      </div>

    </div>
  </div>
</section>


 
<br>
<section id="add-balance-section" class="projects-container" aria-label="إضافة رصيد" style="display: none;">
  <div style="display: flex; align-items: center; justify-content: space-between;">
    <h2 class="section-title" style="margin: 0; display: flex; align-items: center; gap: 8px;">
      <i class="fas fa-wallet" aria-hidden="true"></i> تعديل الرصيد
    </h2>

   <div style="display: flex; gap: 10px;">
    <!-- زر الحذف -->
    <div class="navS-icon" id="BTNDelete" tabindex="0" role="button" 
         style="display:none; width: 50px; cursor: pointer;" aria-label="حذف" onclick="deleteBalance()">
      <i class="fas fa-trash-alt"></i>
      <span class="tooltip" role="tooltip">حذف</span>
    </div>
      <!-- زر حفظ -->
      <div class="navS-icon" tabindex="0" id="BTNSaveEdit" role="button" style="width: 50px; cursor: pointer;" aria-label="حفظ" onclick="saveBalanceUnified()">
        <i class="fas fa-save"></i>
        <span class="tooltip" role="tooltip">حفظ</span>
      </div>

        <div class="navS-icon" id="selectPdfBtn" tabindex="0" role="button" style="width: 50px; cursor: pointer;" aria-label="العقد PDF">
  <i class="fas fa-file-pdf"></i>
  <span class="tooltip" role="tooltip"> PDF</span>
</div>

<!-- عنصر اختيار الملف المخفي -->
<input type="file" id="pdfFileInput" accept=".pdf" style="display: none;">
    </div>
  </div>

  <!-- الفورم -->
  <form id="add-balance-form" style="margin-top: 15px; display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px;">
    <div class="form-field">
      <i class="fas fa-credit-card icon-secondary"></i>
      <select name="payment_method" required>
        <option value="" disabled selected>اختر طريقة الاضافه</option>
        <option value="حساب بنكي">حساب بنكي</option>
        <option value="كاش">كاش</option>
        <option value="أصول">أصول</option>
      </select>
    </div>

    <div class="form-field">
      <i class="fas fa-calendar-alt icon-secondary"></i>
      <input type="date" name="deposit_date" id="deposit_date" placeholder="تاريخ الإيداع" required>
    </div>

    <div class="form-field">
      <i class="fas fa-dollar-sign icon-secondary"></i>
      <input type="number" name="balance_value" placeholder="قيمة الرصيد" required>
    </div>


    <div class="form-field">
      <i class="fas fa-credit-card icon-secondary"></i>
      <select name="ActionType" id="ActionType" required>
        <option value="" disabled selected>اختر  نوع العمليه </option>
        <option value="مدخل">مدخل </option>
        <option value="مخرج">مخرج</option>
      
      </select>
    </div>



    <div class="form-field">
      <i class="fas fa-hashtag icon-secondary"></i>
      <input type="text" name="reference_number" placeholder="رقم المرجع (اختياري)">
    </div>

    <div class="form-field" style="grid-column: span 3;">
      <i class="fas fa-sticky-note icon-secondary"></i>
      <input type="text" name="notes" placeholder="ملاحظات">
    </div>

     <input type="hidden" value="" id="AttachmentPath" name="AttachmentPath">
  </form>

<!-- ثم ضع الـ container للرسائل -->

<div id="toast-container" style="margin-top:10px; padding:10px; border-radius:5px; display:none;"></div>

</section>




<section id="deduct-balance-section" class="projects-container" aria-label="خصم رصيد" style="display: none;">

  <div style="display: flex; align-items: center; justify-content: space-between;">
    <!-- العنوان -->
    <h2 class="section-title" style="margin: 0; display: flex; align-items: center; gap: 8px;">
      <i class="fas fa-wallet" aria-hidden="true"></i>
      خصم رصيد
    </h2>

    <!-- الأزرار (على اليمين) -->
    <div style="display: flex; gap: 10px; margin-right: auto;">
      <div class="nav-icon0" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="حفظ" id="save-balance-btn">
        <i class="fas fa-save"></i>
        <span class="tooltip" role="tooltip">حفظ</span>
      </div>

      <div class="nav-icon0" tabindex="0" role="button" 
           style="width: 50px; cursor: pointer;" 
           aria-label="مرجع PDF" onclick="downloadDeductPDF()">
        <i class="fas fa-file-pdf"></i>
        <span class="tooltip" role="tooltip">اضافه مرجع PDF</span>
      </div>
    </div>
  </div>

  <!-- الفورم -->
  <form id="deduct-balance-form" style="margin-top: 15px; display: grid; grid-template-columns: repeat(3, 1fr); gap: 15px;">

    <!-- سبب الخصم -->
    <div class="form-field">
      <i class="fas fa-credit-card icon-secondary"></i>
      <select name="deduct_reason" required>
         <option value="" disabled selected>اختر طريقة الخصم</option>
    <option value="bank">حساب بنكي</option>
    <option value="cash">كاش</option>
        <option value="other">أخرى</option>
      </select>
    </div>

    <!-- تاريخ الخصم -->
    <div class="form-field">
      <i class="fas fa-calendar-alt icon-secondary"></i>
      <input type="date" name="deduct_date" id="deduct_date" placeholder="تاريخ الخصم" required>
    </div>

    <!-- قيمة الخصم -->
    <div class="form-field">
      <i class="fas fa-dollar-sign icon-secondary"></i>
      <input type="number" name="deduct_value" placeholder="قيمة الخصم" required>
    </div>

    <!-- رقم المرجع (اختياري) -->
    <div class="form-field">
      <i class="fas fa-hashtag icon-secondary"></i>
      <input type="text" name="deduct_reference_number" placeholder="رقم المرجع (اختياري)">
    </div>

    <!-- ملاحظات -->
    <div class="form-field" style="grid-column: span 3;">
      <i class="fas fa-sticky-note icon-secondary"></i>
      <input type="text" name="deduct_notes" placeholder="ملاحظات">
    </div>

  </form>
</section>



<section id="transactions-section" class="projects-container" aria-label="الحركات المالية">

  <!-- العنوان -->
<div style="display: flex; align-items: center; justify-content: space-between; flex-wrap: wrap; margin: 10px 0;">

  <!-- العنوان -->
  <h2 class="section-title" style="display: flex; align-items: center; gap: 8px; margin: 0;">
    <i class="fas fa-exchange-alt" aria-hidden="true"></i>
    الحركات المالية
  </h2>

  <!-- الفلاتر -->
  <div style="display: flex; align-items: center; gap: 20px; flex-wrap: wrap; justify-content: flex-end;">

    <!-- فلتر النوع -->
    <div style="display: flex; gap: 10px;">
      <div class="navT-icon" role="button" tabindex="0" onclick="filterByType('all')" aria-label="عرض الكل">
        <i class="fas fa-list"></i>
        <span class="tooltip">عرض الكل</span>
      </div>
      <div class="navT-icon" role="button" tabindex="0" onclick="filterByType('مدخل')" aria-label="اضافه">
        <i class="fas fa-plus-circle" style="color: var(--secondary);"></i>
        <span class="tooltip">مدخل</span>
      </div>
      <div class="navT-icon" role="button" tabindex="0" onclick="filterByType('مخرج')" aria-label="سحب">
        <i class="fas fa-minus-circle" style="color: var(--secondary);"></i>
        <span class="tooltip">مخرج</span>
      </div>
    </div>

    <!-- فلتر المستخدم -->
    <div class="form-field" style="flex:1; max-width: 250px;">
      <i class="fas fa-user icon-secondary"></i>
      <input type="text" id="userFilter" placeholder="ابحث باسم المستخدم" oninput="filterByUser()">
    </div>

    <!-- فلتر الطريقة -->
    <div style="display: flex; gap: 10px;">
      <div class="navT-icon" role="button" tabindex="0" onclick="filterByMethod('all')" aria-label="كل الطرق">
        <i class="fas fa-random"></i>
        <span class="tooltip">كل الطرق</span>
      </div>
      <div class="navT-icon" role="button" tabindex="0" onclick="filterByMethod('كاش')" aria-label="كاش">
        <i class="fas fa-money-bill-wave" style="color:var(--secondary);"></i>
        <span class="tooltip">كاش</span>
      </div>
      <div class="navT-icon" role="button" tabindex="0" onclick="filterByMethod('حساب بنكي')" aria-label="تحويل بنكي">
        <i class="fas fa-university" style="color: var(--secondary);"></i>
        <span class="tooltip">تحويل بنكي</span>
      </div>

      <div class="navT-icon" role="button" tabindex="0" onclick="filterByMethod('أصول')" aria-label="أصول">
    <i class="fas fa-boxes" style="color: var(--secondary);"></i>
    <span class="tooltip">أصول</span>
</div>

    </div>

  </div>
</div>


  <!-- الجدول -->
  <table class="items-table">
    <thead>
      <tr>
        
        <th><i class="fas fa-credit-card icon-secondary"></i> طريقة العملية</th>
        <th><i class="fas fa-calendar-alt icon-secondary"></i> التاريخ</th>
        <th><i class="fas fa-dollar-sign icon-secondary"></i> القيمة</th>
         <th><i class="fas fa-random icon-secondary"></i> النوع</th>
          <th><i class="fas fa-hashtag icon-secondary"></i> رقم المرجع </th>
        <th><i class="fas fa-user icon-secondary"></i> المستخدم</th>
        <th><i class="fas fa-file-pdf icon-secondary"></i> المستند</th>
        <th><i class="fas fa-sticky-note icon-secondary"></i> الملاحظات</th>
      </tr>
    </thead>
    <tbody id="transactions-table-body">
      <tr>
        <td colspan="7" class="no-items">لا توجد بيانات مضافة بعد</td>
      </tr>
    </tbody>
  </table>

</section>






  </main>

  <!-- Scroll Top Button -->
  <button id="scrollTopBtn" class="fas fa-arrow-up"
          onclick="window.scrollTo({top:0,behavior:'smooth'})"></button>

  <!-- Footer -->
<?php include 'footer.php'; ?>

  <!-- Scripts -->
  <script>
    document.getElementById('currentYear').textContent = new Date().getFullYear();
  </script>

  <script>
// منع تحديد النصوص
document.addEventListener('selectstart', function (e) {
    e.preventDefault();
}, false);

// منع الكليك يمين
document.addEventListener('contextmenu', function (e) {
    e.preventDefault();
}, false);

// منع السحب
document.addEventListener('dragstart', function (e) {
    e.preventDefault();
}, false);

// منع الحفظ وأوامر المطور
window.addEventListener('keydown', function (e) {
    // اختصارات Ctrl + (S, U, P, C, X, A)
    if (e.ctrlKey && ['s', 'u', 'p', 'c', 'x', 'a'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ هذا الاختصار معطل على هذا الموقع");
    }
    // منع F12
    if (e.key === 'F12') {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
    // منع Ctrl+Shift+I و Ctrl+Shift+J
    if (e.ctrlKey && e.shiftKey && ['i', 'j'].includes(e.key.toLowerCase())) {
        e.preventDefault();
        e.stopPropagation();
        alert("❌ أدوات المطور معطلة");
    }
}, true); // capture mode
</script>



     <script>
const today = new Date().toISOString().split('T')[0];
document.getElementById('deposit_date').value = today;
document.getElementById('deduct_date').value = today;
</script>





<script>
  let pageIdentifier = "Balance";
</script>
  <script src="script.js"></script>

 

<script src="BalanceAjax.js"></script>
   
</body>
</html>