// تحميل المشاريع من قاعدة البيانات
fetch('get_projects.php')
  .then(async res => {
    const text = await res.text();

    try {
      const data = JSON.parse(text);

      // لو السيرفر رجّع خطأ داخل JSON
      if (data.error) {
        throw new Error(data.error);
      }

      const select = document.getElementById('selected-project');
      select.innerHTML = '<option value="All" >  المشاريع </option>';

      data.forEach(project => {
        const option = document.createElement('option');
        option.value = project.id;
        option.textContent = project.name;
        select.appendChild(option);
      });
    } catch (err) {
      console.error("❌ فشل تحويل البيانات إلى JSON:", err.message);
      console.log("🔍 الرد من السيرفر كان:", text);
    }
  })
  .catch(error => {
    console.error("❌ فشل تحميل المشاريع:", error.message);
  });

// التعامل مع اختيار مشروع
handleProjectChange = (selectElement) => {
  const selectedId = selectElement.value;
  const selectedName = selectElement.options[selectElement.selectedIndex].text;

  // ✅ تحويل "All" إلى 0
  const PID = selectedId === "All" ? 0 : parseInt(selectedId);

  // ✅ تحديث النصوص والحقول
  document.getElementById('selected-project-text').textContent = selectedName;
  document.getElementById('selected-project-id').textContent = PID;
  document.getElementById('project-id-hidden').value = PID;

  console.log("✅ تم اختيار المشروع:", PID, selectedName);
  console.log("📌 القيمة النهائية في hidden input:", document.getElementById('project-id-hidden').value);

  // تحميل الإيرادات حسب المشروع

//loadCustodies();
}












/****************************
 *  🏗️ PROJECTS & ITEMS
 ****************************/
let CURRENT_PROJECT_ID = null;

function setAddItemEnabled(enabled) {
  const btn = document.getElementById('btnAddItem');
  if (!btn) return;
  btn.setAttribute('aria-disabled', enabled ? 'false' : 'true');
  btn.style.opacity = enabled ? '1' : '0.5';
  btn.style.pointerEvents = enabled ? 'auto' : 'none';
  btn.style.cursor = enabled ? 'pointer' : 'not-allowed';
}

// حساب الإجمالي تلقائي
(function attachTotalCalc(){
  const itemForm = document.getElementById("add-item-form");
  if (!itemForm) return;
  const q = itemForm.querySelector('input[name="quantity"]');
  const p = itemForm.querySelector('input[name="price"]');
  const t = itemForm.querySelector('input[name="total"]');
  const recalc = () => {
    const qq = parseFloat(q.value || 0);
    const pp = parseFloat(p.value || 0);
    t.value = (qq * pp).toFixed(2);
  };
  ['input','change'].forEach(ev => {
    q?.addEventListener(ev, recalc);
    p?.addEventListener(ev, recalc);
  });
})();

// حفظ المشروع
document.getElementById("btnSaveProject").addEventListener("click", function () {
  const form = document.getElementById("add-project-form");
  const formData = new FormData(form);

  // إضافة الـ ID لو موجود
  const projectId = document.getElementById("project-id-hidden").value;
  formData.append("project_id", projectId);

  fetch("save_project.php", {
    method: "POST",
    body: formData
  })
  .then(response => response.json())
  .then(data => {
    if (data.success) {
      alert("✅ تم حفظ المشروع بنجاح");
      // ممكن تنظف الفورم أو تحدث الجدول حسب ما تحب
    } else {
      alert("❌ حدث خطأ أثناء الحفظ: " + data.message);
    }
  })
  .catch(error => {
    console.error("خطأ في الاتصال:", error);
    alert("❌ فشل الاتصال بالسيرفر");
  });
});


// إظهار فورم البند
function addItem() {
  const btn = document.getElementById('btnAddItem');
  if (btn.getAttribute('aria-disabled') === 'true') return;

  const sec = document.getElementById('add-item-section');
  if (sec) sec.style.display = 'block';
}

// حفظ البند

function saveItem() {
  const PIDraw = document.getElementById('saved_project_id')?.value || "";
  const PID = parseInt(PIDraw.trim(), 10);

  if (!PID || isNaN(PID)) {
    alert("⚠️ من فضلك احفظ المشروع أولًا قبل إضافة البنود.");
    console.log("❌ PID مش صحيح:", PIDraw);
    return;
  }

  const itemForm = document.getElementById("add-item-form");
  if (!itemForm) return;

  const item = {};
  new FormData(itemForm).forEach((val, key) => {
    if (key !== "saved_project_id" && key !== "total") {
      item[key] = val.trim();
    }
  });

  console.log("📌 PID:", PID, "📌 item:", item);

  // التحقق من الحقول المطلوبة
  const required = ["item_name", "unit", "quantity", "price"];
  for (const k of required) {
    if (!item[k] || item[k] === "") {
      alert("⚠️ برجاء استكمال بيانات البند: " + k);
      return;
    }
  }

  const qq = parseFloat(item.quantity);
  const pp = parseFloat(item.price);
  if (isNaN(qq) || isNaN(pp) || qq <= 0 || pp <= 0) {
    alert("⚠️ تأكد من أن الكمية والسعر أرقام صحيحة أكبر من صفر.");
    return;
  }

  const tt = qq * pp;

  // تحديث حقل total في الفورم مباشرة للعرض
  const totalInput = itemForm.querySelector('input[name="total"]');
  if (totalInput) totalInput.value = tt.toFixed(2);

  // إنشاء payload النهائي لإرسال PHP
  const payload = {
    saved_project_id: PID,
    item_name: item.item_name,
    unit: item.unit,
    quantity: qq,
    price: pp,
    total: tt,
    notes: item.notes || ''
  };

  fetch("save_item.php", {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify(payload)
  })
  .then(res => res.json())
  .then(response => {
    const msgBox = document.getElementById("responseMsg");
    if (response.status === "success") {
      msgBox.style.color = "green";
      msgBox.textContent = response.message;
      itemForm.reset();
      setAddItemEnabled(false);
    } else {
      msgBox.style.color = "red";
      msgBox.textContent = response.message;
    }
  })
  .catch(err => {
    console.error("❌ Fetch Error:", err);
    const msgBox = document.getElementById("responseMsg");
    msgBox.style.color = "red";
    msgBox.textContent = "❌ السيرفر رجع رد غير متوقع";
  });
}

// عند تحميل الصفحة → اقفل زر إضافة البند
document.addEventListener('DOMContentLoaded', () => setAddItemEnabled(false));

// ربط الأزرار بالأحداث بعد تحميل الـ DOM
document.addEventListener('DOMContentLoaded', () => {
  const btnSaveProject = document.getElementById('btnSaveProject');
  if (btnSaveProject) {
    btnSaveProject.addEventListener('click', (e) => {
      e.preventDefault();
      e.stopPropagation();
      saveProject();
    });
    btnSaveProject.addEventListener('keydown', (e) => {
      if (e.key === 'Enter' || e.key === ' ') {
        e.preventDefault();
        saveProject();
      }
    });
  }

  setAddItemEnabled(false);

  const btnSaveItem = document.getElementById('btnSaveItem');
  if (btnSaveItem) {
    btnSaveItem.addEventListener('click', (e) => {
      e.preventDefault();
      e.stopPropagation();
      saveItem();
    });
  }
});




//balance



